/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 July 2011
// Last modified:
#include "FStep.h"

FStep::FStep(){
    //ctor
}
FStep::FStep(const int rId, const int rDimNumber, char *rName):BenchmarkFunction(rId, rDimNumber, rName){

    setSearchRange<double>(-100,100);

     initialize();
}
FStep::FStep(const int rId, const int rDimNumber, char *rName, double rL, double rU):BenchmarkFunction(rId, rDimNumber, rName){
    setSearchRange<double>(rL,rU);
    initialize();
}
FStep::FStep(const int rId, const int rDimNumber, char *rName, double *rL, double *rU):BenchmarkFunction(rId, rDimNumber, rName){

    setSearchRange<double>(rL,rU);
    initialize();
}
FStep::~FStep(){
    //dtor
}
void FStep::initialize(){
    setOriginalGlobalOpt();

    setGlobalOpt();

}

double FStep::evaluate_(double const *x){
    double fitness=0;
	for(int i=0;i<m_dimNumber;i++){
		fitness+=fabs((double)int(x[i]+0.5)*int(x[i]+0.5));
	}

    return fitness+m_bias;

}

