/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 11 May 2011
// Last modified:
#ifndef HYBRIDCOMP_H
#define HYBRIDCOMP_H
#include <map>

#include "BenchmarkFunction.h"




class HybridComp : public BenchmarkFunction
{
    public:
        HybridComp();
        HybridComp(const int rId, const int rDimNumber, char *rName);
        virtual ~HybridComp();
        void setFunction(ProblemTag * rId, char *rFucs[]);
        int getNumFuncs();
        virtual double evaluate_(double const  *x);

    protected:
        virtual void allocateMemory(const int rNumDim, const int rNumFuc);
        virtual void freeMemory();
        virtual void initialize();
        virtual bool loadTranslation();
        virtual bool loadRotation();

        void setUpFCom();
        void SetUpFCom_CEC05();
        void SetUpFRH_Com_CEC05();
        void SetUpFRH001_Com_CEC05();
        void SetUpFRH002_Com_CEC05();
        virtual void setGlobalOpt();
        void setOriginalGlobalOpt();

    private:
        static const  int  m_numFuncs=10;				// number of basic functions, for hybrid functions
        BenchmarkFunction **mpp_f; // the functions

        double *mp_convergeSeverity;        // severity of converge range for each function
        double *mp_stretchSeverity;          // severity of stretching original function, greater than 1 for stretch
        double *mp_weight;                  // weight value of each basic function

        double *mp_fit;                      // objective value of each basic funciton
        double *mp_height;
        double *mp_fmax;

        double m_heightNormalizeSeverity;   // constant number for noralizing all basic function with similar height


};

#endif // HYBRIDCOMP_H
