/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 July 2011
// Last modified:
#include "Schwefel_2_21.h"

FSchwefel_2_21::FSchwefel_2_21(){
    //ctor
}
FSchwefel_2_21::FSchwefel_2_21(const int rId, const int rDimNumber, char *rName):BenchmarkFunction(rId, rDimNumber, rName){

    setSearchRange<double>(-100,100);

     initialize();
}
FSchwefel_2_21::FSchwefel_2_21(const int rId, const int rDimNumber, char *rName, double rL, double rU):BenchmarkFunction(rId, rDimNumber, rName){
    setSearchRange<double>(rL,rU);
    initialize();
}
FSchwefel_2_21::FSchwefel_2_21(const int rId, const int rDimNumber, char *rName, double *rL, double *rU):BenchmarkFunction(rId, rDimNumber, rName){

    setSearchRange<double>(rL,rU);
    initialize();
}
FSchwefel_2_21::~FSchwefel_2_21(){
    //dtor
}
void FSchwefel_2_21::initialize(){
    setOriginalGlobalOpt();
    setGlobalOpt();

}

double FSchwefel_2_21::evaluate_(double const *x){
   	double * y = new double[m_dimNumber];
	for(int i=0;i<m_dimNumber;i++) y[i]= fabs(x[i]);
	double max=gExtremum(y,m_dimNumber,MAX_OPT);
	delete []y;

    return max+m_bias;

}
