/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 11 May 2011
// Last modified:
#include "Sphere.h"

FSphere::FSphere(){
    //ctor
}
FSphere::FSphere(const int rId, const int rDimNumber, char *rName):BenchmarkFunction(rId, rDimNumber, rName){

    setSearchRange<double>(-100,100);

     initialize();
}
FSphere::FSphere(const int rId, const int rDimNumber, char *rName, double rL, double rU):BenchmarkFunction(rId, rDimNumber, rName){
    setSearchRange<double>(rL,rU);
    initialize();
}
FSphere::FSphere(const int rId, const int rDimNumber, char *rName, double *rL, double *rU):BenchmarkFunction(rId, rDimNumber, rName){

    setSearchRange<double>(rL,rU);
    initialize();
}
FSphere::~FSphere(){
    //dtor
}
void FSphere::initialize(){
    setOriginalGlobalOpt();

    switch(m_id){
        case Sphere: case Sphere_Noisy: case Sphere_Noisy_CEC05:
            break;
        case S_Sphere:
            loadTranslation();
            break;
        case R_Sphere:
            setConditionNumber(2);
            loadRotation();
            break;
        case RS_Sphere:
            setConditionNumber(2);
            loadTranslation();
            loadRotation();
            break;
        case S_Sphere_CEC05: case S_Sphere_CEC08:
            setBias(-450);
            loadTranslation();
            break;
        default:
        Throw(Invalid_argument("Error: please check the problem ID"));
        exit(0);
        break;
    }
    setGlobalOpt();

}
void FSphere::setGlobalOpt(){
    m_globalOpt.m_knownFlag=true;
    gCopy(m_globalOpt.mp_location,mp_translation,m_dimNumber);
    m_globalOpt.m_value=BenchmarkFunction::evaluate(m_globalOpt.mp_location,false);

}

double FSphere::evaluate_(double const *x){
    double fit=0;
    if(m_id==Sphere_Noisy){
        double noise;
        for(int i=0;i<m_dimNumber;i++){
            noise=0.01*Global::gp_uniformPro->Next();
            fit+=(x[i]+noise)*(x[i]+noise);
        }
    }
    else if(m_id == Sphere_Noisy_CEC05){
        for(int i=0;i<m_dimNumber;i++)	fit+=x[i]*x[i];
        fit *= (1.0 + 0.1 * fabs(Global::gp_normalPro->Next()));
    }
    else{
        for(int i=0;i<m_dimNumber;i++)	{ fit+=x[i]*x[i]; }
    }

    return fit+m_bias;

}
