/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 11 May 2011
// Last modified:

#include "Problem.h"

Problem::Problem():m_searchRange(0),m_evals(0),m_objectives(0){
    //ctor
    ma_name[0]='\0';
    m_id=-1;
    m_dimNumber=-1;
	mp_bestSoFar=0;

}
Problem::Problem(const int rId, const int rDimNumber,const  Encoding rEncoding, const ProCategory rCat, char *rName):m_id(rId),
m_dimNumber(rDimNumber),m_problemType(MIN_OPT),m_encoding(rEncoding),m_cat(rCat),m_evals(0),m_objectives(1),m_objIdx(0){

    //m_searchRange=new void* [m_dimNumber];
    if(rName!=0){
        if(strlen(rName)<=MAX_NAME_LENGTH){
            strcpy(ma_name,rName);
        }else{
            Throw(Length_error(rName));
            exit(0);

        }

    }else{

        ma_name[0]='\0';
    }
    Global::g_dimNumber=rDimNumber;
	
	allocateMemory(rDimNumber);

    m_proPar<<"Dimension:"<<m_dimNumber<<"; ";

}
void Problem::allocateMemory(int const rDim){
     m_searchRange=new void* [rDim];
	 mp_bestSoFar=new double[m_objectives];
}
Problem::~Problem()
{
    //dtor
    freeMemory();
}

void Problem::freeMemory(){
    delete []  m_searchRange;
    m_searchRange=0;
	delete [] mp_bestSoFar;
	mp_bestSoFar=0;
}

Problem& Problem::operator=(const Problem & rP){
    if(this== &rP) return *this;

    m_id=rP.m_id;

    m_encoding=rP.m_encoding;
    m_cat=rP.m_cat;
	m_problemType=rP.m_problemType;
    m_evals=rP.m_evals;
	m_objectives=rP.m_objectives;
	m_objIdx=rP.m_objIdx;

    if(m_dimNumber!=rP.m_dimNumber) {
        delete[] m_searchRange;
        m_dimNumber=rP.m_dimNumber;
        m_searchRange=new void* [m_dimNumber];
    }


    strcpy(ma_name,rP.ma_name);

	gCopy<double>(mp_bestSoFar,rP.mp_bestSoFar,m_objectives);
    return *this;
}
void Problem::parameterSetting(Problem * rP){
	
    m_id=rP->m_id;

    m_encoding=rP->m_encoding;
    m_cat=rP->m_cat;
	m_problemType=rP->m_problemType;
    m_evals=rP->m_evals;
	m_objectives=rP->m_objectives;
	m_objIdx=rP->m_objIdx;
	gCopy<double>(mp_bestSoFar,rP->mp_bestSoFar,m_objectives);

}
/*
void Problem::setSearchRange(const double rLower, const double rUpper)
void Problem::setSearchRange(const double *const rLower, const double * const rUpper){
    if(sizeof(rLower)/(sizeof(double))!=m_dimNumber||sizeof(rUpper)/(sizeof(double))!=m_dimNumber){
        Throw(Out_of_range("the number of dimensions must be ....."));
        exit(0);
    }
    for(int i=0;i<m_dimNumber;i++)     m_searchRange[i].setBoundary(rLower[i],rUpper[i]);
}

void Problem::getSearchRange(double &rLower, double &rUpper, const int rD){
    rLower=m_searchRange[ rD].lower;
    rUpper=m_searchRange[ rD].upper;
}*/
