/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 July 2011
// Last modified:
#include "FGear_Train.h"


FGear_Train::FGear_Train(){
    //ctor
}
FGear_Train::FGear_Train(const int rId, const int rDim, char *rName):BenchmarkFunction(rId, 4, rName){

    setSearchRange<double>(12,60);

     initialize();
}
FGear_Train::FGear_Train(const int rId, char *rName, double rL, double rU):BenchmarkFunction(rId, 4, rName){
    setSearchRange<double>(rL,rU);
    initialize();
}
FGear_Train::FGear_Train(const int rId,  char *rName, double *rL, double *rU):BenchmarkFunction(rId, 4, rName){

    setSearchRange<double>(rL,rU);
    initialize();
}
FGear_Train::~FGear_Train(){
    //dtor
}


void FGear_Train::initialize(){
    setOriginalGlobalOpt();

    setGlobalOpt();

}
void FGear_Train::setGlobalOpt(){
    m_globalOpt.m_knownFlag=true;
    m_globalOpt.mp_location[0]=15;  m_globalOpt.mp_location[1]=20;
    m_globalOpt.mp_location[2]=57;	 m_globalOpt.mp_location[3]=59;

    m_globalOpt.m_value=BenchmarkFunction::evaluate(m_globalOpt.mp_location,false);

}
void FGear_Train::setOriginalGlobalOpt(){

    m_originalGlobalOpt.m_knownFlag=true;
    m_originalGlobalOpt.mp_location[0]=15;  m_originalGlobalOpt.mp_location[1]=20;
    m_originalGlobalOpt.mp_location[2]=57;	 m_originalGlobalOpt.mp_location[3]=59;

    m_originalGlobalOpt.m_value=BenchmarkFunction::evaluate(m_originalGlobalOpt.mp_location,false);

}


double FGear_Train::evaluate_(double const *x){

    int x1,x2,x3,x4;
	double s;
	x1=(int)x[0]; x2=(int)x[1]; x3=(int)x[2];x4=(int)x[3];
	s=1./6.931-x1*x2/(double)(x3*x4);

	return s*s;

}
