/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 July 2011
// Last modified:
#include "FParEst_FMSoundWaves.h"


FParEst_FMSoundWaves::FParEst_FMSoundWaves(){
    //ctor
}
FParEst_FMSoundWaves::FParEst_FMSoundWaves(const int rId,  const int rDim, char *rName):BenchmarkFunction(rId, 6, rName){

    setSearchRange<double>(-6.4,6.35);

     initialize();
}
FParEst_FMSoundWaves::FParEst_FMSoundWaves(const int rId, char *rName, double rL, double rU):BenchmarkFunction(rId, 6, rName){
    setSearchRange<double>(rL,rU);
    initialize();
}
FParEst_FMSoundWaves::FParEst_FMSoundWaves(const int rId,  char *rName, double *rL, double *rU):BenchmarkFunction(rId, 6, rName){

    setSearchRange<double>(rL,rU);
    initialize();
}
FParEst_FMSoundWaves::~FParEst_FMSoundWaves(){
    //dtor
}


void FParEst_FMSoundWaves::initialize(){
    setOriginalGlobalOpt();

    setGlobalOpt();

}
void FParEst_FMSoundWaves::setGlobalOpt(){
    m_globalOpt.m_knownFlag=true;
    m_globalOpt.mp_location[0]=1.0;  m_globalOpt.mp_location[1]=5.0;
    m_globalOpt.mp_location[2]=1.5;	 m_globalOpt.mp_location[3]=4.8;
    m_globalOpt.mp_location[4]=2.0;	 m_globalOpt.mp_location[5]=4.9;

    m_globalOpt.m_value=BenchmarkFunction::evaluate(m_globalOpt.mp_location,false);

}
void FParEst_FMSoundWaves::setOriginalGlobalOpt(){

    m_originalGlobalOpt.m_knownFlag=true;
    m_originalGlobalOpt.mp_location[0]=1.0;  m_originalGlobalOpt.mp_location[1]=5.0;
    m_originalGlobalOpt.mp_location[2]=1.5;	 m_originalGlobalOpt.mp_location[3]=4.8;
    m_originalGlobalOpt.mp_location[4]=2.0;	 m_originalGlobalOpt.mp_location[5]=4.9;

    m_originalGlobalOpt.m_value=BenchmarkFunction::evaluate(m_originalGlobalOpt.mp_location,false);

}


double FParEst_FMSoundWaves::evaluate_(double const *x){

	double theta=2*PI/100.;
	double s=0,t;
	for(int i=0;i<100;i++){
		t=x[0]*sin(x[1]*i*theta+x[2]*sin(x[3]*i*theta+x[4]*sin(x[5]*i*theta)))-sin(5.*i*theta+1.5*sin(4.8*i*theta+2.0*sin(4.9*i*theta)));
		s+=t*t;
	}
	return s;

}
