/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/

/************************************************************************
parameter estimation for frequency-modulated (FM) sound waves is to estimate
the parameters of a FM synthesizer.

S.~Das and P.~N. Suganthan, ``Problem definitions and evaluation criteria for
  cec 2011 competition on testing evolutionary algorithms on real world
  optimization problem,'' Dept. of Electronics and Telecommunication Engg.,
  Jadavpur University, Kolkata, India, Tech. Rep., 2011.

*****************************************************************************************/



// Created: 21 July 2011
// Last modified:
#ifndef FPAREST_FMSOUNDWAVES_H
#define FPAREST_FMSOUNDWAVES_H


#include "../FunctionOpt/BenchmarkFunction.h"

class FParEst_FMSoundWaves : public BenchmarkFunction
{
    public:
        FParEst_FMSoundWaves();
        FParEst_FMSoundWaves(const int rId,  const int rDim, char *rName);
        FParEst_FMSoundWaves(const int rId,  char *rName, double rL,double rU);
        FParEst_FMSoundWaves(const int rId,  char *rName, double *rL, double *rU);
        virtual ~FParEst_FMSoundWaves();
    protected:
        void initialize();
        void setGlobalOpt();
        void setOriginalGlobalOpt();
        virtual double evaluate_(double const *x);
    private:
};

#endif // FPAREST_FMSOUNDWAVES_H
