#include "../ToolnDef/Global.h"
#include "../ToolnDef/StructDec.h"
#include "../Algorithms/PSO/SLPSO/SLSwarm.h"

extern BasicFunc gFunctionInstance;

void setGPopSize(){
	if(Global::g_algNumber==ALG_CPSOR)	{
		if(Global::g_proNumber==MovingPeak_DOP) Global::g_gPopsize=300*(1-exp(-0.33*pow(dynamic_cast<DynamicProblem*>(Global::gp_problem)->getNumberofPeak(),0.5)));
		else {
			//TO DO
		}
	}
	else if(Global::g_algNumber==ALG_CPSO){
		if(Global::g_proNumber==MovingPeak_DOP) Global::g_gPopsize=70;
		else{
			//TO DO
		}

	}
	/// TO DO else if(Global::g_algNumber==ALG_CDER) Global::g_gPopsize=??//
}
void setsubPopSize(){
	if(Global::g_algNumber==ALG_CPSOR)	{
		if(Global::g_proNumber==MovingPeak_DOP)Global::g_subSize=7;
		else {
			//TO DO
		}
	}
	else if(Global::g_algNumber==ALG_CPSO) {
		if(Global::g_proNumber==MovingPeak_DOP) Global::g_subSize=3;
		else{
			//TO DO
		}
	}
	/// TO DO else if(Global::g_algNumber==ALG_CDER) Global::g_subSize=??//

}
void setDiversityDegree(){
	if(Global::g_algNumber==ALG_CPSOR){
		if(Global::g_proNumber==MovingPeak_DOP)Global::g_diversityDegree=1-exp(-0.2*pow(dynamic_cast<DynamicProblem*>(Global::gp_problem)->getNumberofPeak(),0.45));
		else {
			//TO DO
		}
	}
	else if(Global::g_algNumber==ALG_CDER){
		// TO DO
		cout<<"not figure out"<<endl;
		Global::g_diversityDegree=0.7;

	}
}
void setOverlapDegree(){
	if(Global::g_algNumber==ALG_CPSOR)	Global::g_overlapDegree=0.1;
	else if(Global::g_algNumber==ALG_CPSO)  Global::g_overlapDegree=0.1;
	else if(Global::g_algNumber==ALG_CDER)  Global::g_overlapDegree=0.1;
}
void initializeSystem(){
    //initilize the two random number generation system here
    gCreateRandPro(0.5);
    gCreateRandAlg(0.5);

    //make pair of problem ID and problem name
    for(int i=Sphere;i<=Binary_DOP;i++)    gProblem[gProName[i].c_str()]=(ProblemTag)i;
    //make pair of algorithm ID and algorithm name
    for(int i=ALG_SPSO;i<=ALG_HRCGA;i++) gAlgorithm[gAlgName[i].c_str()]=(AlgorithmTag)i;


    gAlgPro=new bool*[gAlgorithm.size()];
    for(unsigned int i=0;i<gAlgorithm.size();i++){
        gAlgPro[i]=new bool[gProblem.size()];
        for(unsigned int j=0;j<gProblem.size();j++)
        gAlgPro[i][j]=false;
    }

    ///initialize the problems that each algorithm can solve here
    for(int i=Sphere;i<=RW_ParEst_FMSoundWaves;i++){
        gAlgPro[ALG_SPSO][i]=true;
        gAlgPro[ALG_SPSO07][i]=true;
        gAlgPro[ALG_CRDE][i]=true;
		gAlgPro[ALG_SGA_REAL][i]=true;
		gAlgPro[ALG_SLPSO][i]=true;
    }
    for(int i=CompositionDBG_DOP;i<=DF1_DOP;i++){
        gAlgPro[ALG_CPSO][i]=true;
        gAlgPro[ALG_CPSOR][i]=true;
		gAlgPro[ALG_CDER][i]=true;
		gAlgPro[ALG_ESCA][i]=true;
		gAlgPro[ALG_SPSO_Parrott][i]=true;
		gAlgPro[ALG_rSPSO][i]=true;
		gAlgPro[ALG_mQSO][i]=true;
		gAlgPro[ALG_mCPSO][i]=true;
		gAlgPro[ALG_PSO_CP][i]=true;
		gAlgPro[ALG_HmSO][i]=true;

    }

    //register the function classes
    for(int i=Sphere;i<=RW_ParEst_FMSoundWaves;i++){
        if(gProName[i].find("Sphere")!=string::npos) gFunctionInstance[gProName[i]]= &createFunction<FSphere>;
        else if(gProName[i].find("Rastrigin")!=string::npos) gFunctionInstance[gProName[i]]= &createFunction<FRastrigin>;
        else if(gProName[i].find("Noncont_Rastrigin")!=string::npos) gFunctionInstance[gProName[i]]= &createFunction<FNoncont_Rastrigin>;
        else if(gProName[i].find("Weierstrass")!=string::npos) gFunctionInstance[gProName[i]]= &createFunction<FWeierstrass>;
        else if(gProName[i].find("Griewank")!=string::npos) gFunctionInstance[gProName[i]]= &createFunction<FGriewank>;
        else if(gProName[i].find("Ackley")!=string::npos) gFunctionInstance[gProName[i]]= &createFunction<FAckley>;
        else if(gProName[i].find("Step")!=string::npos) gFunctionInstance[gProName[i]]= &createFunction<FStep>;
        else if(gProName[i].find("Quartic_Noisy")!=string::npos) gFunctionInstance[gProName[i]]= &createFunction<FQuartic_Noisy>;
        else if(gProName[i].find("Scaffer_F6")!=string::npos) gFunctionInstance[gProName[i]]= &createFunction<FScaffer_F6>;
        else if(gProName[i].find("Rosenbrock")!=string::npos) gFunctionInstance[gProName[i]]= &createFunction<FRosenbrock>;
        else if(gProName[i].find("Schwefel")!=string::npos) gFunctionInstance[gProName[i]]= &createFunction<FSchwefel>;
        else if(gProName[i].find("Schwefel_2_22")!=string::npos) gFunctionInstance[gProName[i]]= &createFunction<FSchwefel_2_22>;
        else if(gProName[i].find("Schwefel_1_2")!=string::npos) gFunctionInstance[gProName[i]]= &createFunction<FSchwefel_1_2>;
        else if(gProName[i].find("Schwefel_2_21")!=string::npos) gFunctionInstance[gProName[i]]= &createFunction<FSchwefel_2_21>;
        else if(gProName[i].find("Penalized_1")!=string::npos) gFunctionInstance[gProName[i]]= &createFunction<FPenalized_1>;
        else if(gProName[i].find("Penalized_2")!=string::npos) gFunctionInstance[gProName[i]]= &createFunction<FPenalized_2>;
        else if(gProName[i].find("Com")!=string::npos) gFunctionInstance[gProName[i]]= &createFunction<HybridComp>;
        else if(gProName[i].find("M_global1")!=string::npos) gFunctionInstance[gProName[i]]= &createFunction<FMAX_global1>;
        else if(gProName[i].find("M_global2")!=string::npos) gFunctionInstance[gProName[i]]= &createFunction<FMAX_global2>;
        else if(gProName[i].find("M_global3")!=string::npos) gFunctionInstance[gProName[i]]= &createFunction<FMAX_global3>;
        else if(gProName[i].find("M_global4")!=string::npos) gFunctionInstance[gProName[i]]= &createFunction<FMAX_global4>;
        else if(gProName[i].find("M_global5")!=string::npos) gFunctionInstance[gProName[i]]= &createFunction<FMAX_global5>;
        else if(gProName[i].find("Gear_Train")!=string::npos) gFunctionInstance[gProName[i]]= &createFunction<FGear_Train>;
        else if(gProName[i].find("FMSoundWaves")!=string::npos) gFunctionInstance[gProName[i]]= &createFunction<FParEst_FMSoundWaves>;

    }
}
void outPutResult(){

    switch(Global::g_proNumber){
        case Sphere: case Sphere_Noisy: case S_Sphere: case R_Sphere: case RS_Sphere: case S_Sphere_CEC05: case Sphere_Noisy_CEC05:
               case Rastrigin: case Rastrigin_Noisy: case S_Rastrigin: case R_Rastrigin: case RS_Rastrigin: case S_Rastrigin_CEC05: case RS_Rastrigin_CEC05:
               case Weierstrass: case RS_Weierstrass: case R_Weierstrass: case RS_Weierstrass_CEC05:
               case Griewank: case R_Griewank: case RS_Griewank:  case RS_Griewank_noBounds_CEC05: case Griewank_Rosenbrock_F13_CEC05: case S_Griewank_Rosenbrock_F13_CEC05:
               case Ackley: case Ackley_Noisy: case S_Ackley: case R_Ackley: case RS_Ackley: case RS_Ackley_Bound_CEC05:
               case Step:
               case Quartic_Noisy:
               case Scaffer_F6:  case Expanded_Scaffer_F6_CEC05: case Noncont_Expanded_Scaffer_F6_CEC05: case RS_Expanded_Scaffer_F6_CEC05:
               case Rosenbrock: case S_Rosenbrock: case S_Rosenbrock_CEC05:
               case Schwefel_2_13_CEC05:
               case Schwefel_2_22: case Schwefel_2_22_Noisy: case S_Schwefel_2_22: case R_Schwefel_2_22: case RS_Schwefel_2_22:
               case Schwefel: case Schwefel_Noisy: case S_Schwefel: case R_Schwefel: case RS_Schwefel:
               case Schwefel_1_2: case Schwefel_1_2_Noisy: case S_Schwefel_1_2: case S_Schwefel_1_2_Noisy: case R_Schwefel_1_2: case RS_Schwefel_1_2:  case S_Schwefel_1_2_CEC05:  case S_Schwefel_1_2_Noisy_CEC05:
               case Schwefel_2_21:
               case Schwefel_2_6_Bound_CEC05:
               case Penalized_1:
               case Penalized_2:
               case Noncont_Rastrigin:
               case RS_Elliptic_CEC05: case Elliptic:
               case Com: case R_Com: case Com_CEC05: case H_Com_CEC05: case H_Com_Noisy_CEC05:
               case RH_Com_CEC05: case RH_Com_NarrowBasin_CEC05: case RH_Com_Bound_CEC05:
               case RH_Com_F21_CEC05:  case RH_Com_HighConNumMatrix_F22_CEC05:  case Noncont_RH_Com_F23_CEC05:  case RH_Com_F24_CEC05:  case RH_Com_noBounds_F25_CEC05:
               case M_global1: case M_global2: case M_global3: case M_global4: case M_global5:
               case S_Sphere_CEC08: case Schwefel_2_21_CEC08: case S_Rosenbrock_CEC08: case S_Rastrigin_CEC08: case S_Griewank_CEC08: case S_Ackley_CEC08:
               case RW_Gear_Train: case RW_ParEst_FMSoundWaves:

            PerformSingleObj::getPerformSingleObj()->calculatePerformance();
            PerformSingleObj::getPerformSingleObj()->outputResult();

            PerformSingleObj::deletePerformSingleObj();
            delete Global::gp_problem;
            break;
        ///Dynamic Problems
        case CompositionDBG_DOP: case RotationDBG_DOP: case MovingPeak_DOP: case DF1_DOP:
        case Binary_DOP:
            PerformSingleObj::getPerformSingleObj()->calculatePerformance();
            PerformSingleObj::getPerformSingleObj()->setProgrOutputFlag(false);
            PerformSingleObj::getPerformSingleObj()->outputResult();
            PerformSingleObj::deletePerformSingleObj();

            if(Global::g_algNumber==ALG_CPSOR||Global::g_algNumber==ALG_CPSO||Global::g_algNumber==ALG_CDER){
                //PopulationInforDOP::getPopInfor()->setOutProgFlag(true);
                //PopulationInforDOP::getPopInfor()->output();
                PopulationInforDOP::deletePerformPopInforDOP();
            }

            delete Global::gp_problem;
            break;
    }
}



bool initializeProblem(char *rPar[], int num){

 ///**************************************PARAMETERS INPUT FORMAT****************************************///
 ///                                    ALGORITHMS:
 /// SLPSO,CLPSO,FIPS,SPSOGBEST,SPSOLBEST,SDE
 ///                                    PROBLEMS:
 /// FUNCTION OPTIMIZATION PROBLEMS
 ///                                    PARAMETERS:
 /// algorithm,problem, g_numRuns,g_tEvals,g_sampleFre, DimNumber,  popsize
 ///*****************************************************************************************************///
 ///                                    ALGORITHMS:
 /// CPSO
 ///                                    PROBLEMS:
 /// MOVING PEAKS
 ///                                    PARAMETERS:
 /// algorithm,problem, g_numRuns,g_tEvals,g_sampleFre, DimNumber,  numPeaks,  changeRatio, vlength,
 /// changeFre,gPopsize, subPopsize, overlapDegree
 ///                                    PROBLEMS:
 /// COMPOSITION_DOP
 ///                                    PARAMETERS:
 /// algorithm,problem, g_numRuns,g_tEvals,g_sampleFre, DimNumber,  numPeaks, changeRatio, changeType,
 /// subProblem, changeFre,gPopsize, subPopsize, overlapDegree
 ///                                    PROBLEMS:
 /// ROTATION_DOP
 ///                                    PARAMETERS:
 /// algorithm,problem, g_numRuns,g_tEvals,g_sampleFre, DimNumber,  numPeaks, changeRatio, changeType,
 /// changeFre, gPopsize, subPopsize, overlapDegree
 ///*****************************************************************************************************///
 ///                                    ALGORITHMS:
 /// CPSOR,CDER
 ///                                    PROBLEMS:
 /// MOVING PEAKS
 ///                                    PARAMETERS:
 /// algorithm,problem, g_numRuns,g_tEvals,g_sampleFre, DimNumber,  numPeaks,  changeRatio, vlength,
 /// changeFre,gPopsize, subPopsize, overlapDegree, diversityDegree
 ///                                    PROBLEMS:
 /// COMPOSITION_DOP
 ///                                    PARAMETERS:
 /// algorithm,problem, g_numRuns,g_tEvals,g_sampleFre, DimNumber,  numPeaks, changeRatio, changeType,
 /// subProblem, changeFre,gPopsize, subPopsize, overlapDegree, diversityDegree
 ///                                    PROBLEMS:
 /// ROTATION_DOP
 ///                                    PARAMETERS:
 /// algorithm,problem, g_numRuns,g_tEvals,g_sampleFre, DimNumber,  numPeaks, changeRatio, changeType,
 /// changeFre, gPopsize, subPopsize, overlapDegree, diversityDegree

 ///*****************************************************************************************************///
 /// note: if a parameter's value is set automatically, corresponding input could be some particular
 /// values, e.g., gPopsize=-1 denotes the gPopsize will be assigned a value automatically.
 ///*****************************************************************************************************///
//Cases tested:
//SPSO Sphere 30 50000 100 10 10
//SPSO07 Sphere 30 50000 100 10 10
//SGA_REAL Sphere 2 50000 100 10 10
//SLPSO Sphere 2 50000 100 10 10 -1 -1 -1
//SLPSO Com 2 50000 100 10 10 -1 -1 -1


//CPSO MovingPeak_DOP 30 500000 200 5 10 1 1 5000 100 7 0.1
//CPSO CompositionDBG_DOP 2 500000 200 5 10 1 0 0 10000 100 7 0.1
//CPSO CompositionDBG_DOP 2 500000 200 5 10 1 6 0 10000 100 7 0.1
//CPSO CompositionDBG_DOP 2 500000 200 5 10 1 7 0 10000 100 7 0.1
//CPSO RotationDBG_DOP 2 500000 200 5 10 1 0 10000 100 7 0.1
//CPSO RotationDBG_DOP 2 500000 200 5 10 1 6 10000 100 7 0.1
//CPSO RotationDBG_DOP 2 500000 200 5 10 1 7 10000 100 7 0.1

//CPSOR MovingPeak_DOP 2 500000 200 5 10 1 1 5000 100 7 0.1 0.8
//CPSOR CompositionDBG_DOP 2 500000 200 5 10 1 0 0 10000 100 7 0.1 0.8
//CPSOR CompositionDBG_DOP 2 500000 200 5 10 1 6 0 10000 100 7 0.1 0.8
//CPSOR CompositionDBG_DOP 2 500000 200 5 10 1 7 0 10000 100 7 0.1 0.8
//CPSOR RotationDBG_DOP 2 500000 200 5 10 1 0 10000 100 7 0.1 0.8
//CPSOR RotationDBG_DOP 2 500000 200 5 10 1 6 10000 100 7 0.1 0.8
//CPSOR RotationDBG_DOP 2 500000 200 5 10 1 7 10000 100 7 0.1 0.8
//CPSOR MovingPeak_DOP 30 500000 200 5 10 1 1 5000 -1 -1 -1 -1

//CDER MovingPeak_DOP 2 500000 200 5 10 1 1 5000 100 7 0.1 0.8
//CRDE Sphere 30 50000 100 10 100
//CRDE Schwefel 30 50000 100 10 100

//ESCA MovingPeak_DOP 2 500000 200 5 10 1 1 5000 10




    if(gAlgorithm.end()==gAlgorithm.find(rPar[1])||gProblem.end()==gProblem.find(rPar[2])){
        stringstream ss;
        ss<<"error: The algorithm "<<rPar[1]<<" or the problem "<<rPar[2]<<" do not exist";
       Throw(Invalid_argument(ss.str().c_str()));
       return false;
    }

    if(!gAlgPro[gAlgorithm[rPar[1]]][gProblem[rPar[2]]]){
        stringstream ss;
        ss<<"error: The algorithm "<<rPar[1]<<" can not be allplied to solve the problem "<<rPar[2];
        Throw(Invalid_argument(ss.str().c_str()));
        return false;
    }

    Global::g_algNumber=(AlgorithmTag)gAlgorithm[rPar[1]];
    Global::g_proNumber=(ProblemTag)(gProblem[rPar[2]]);
    Global::g_numRuns=atoi(rPar[3]);
    Global::g_tEvals=atoi(rPar[4]);
    Global::g_sampleFre=atoi(rPar[5]);
    Global::g_runIdx=0;

    switch(Global::g_proNumber){
        case Sphere: case Sphere_Noisy: case S_Sphere: case R_Sphere: case RS_Sphere: case S_Sphere_CEC05: case Sphere_Noisy_CEC05:
               case Rastrigin: case Rastrigin_Noisy: case S_Rastrigin: case R_Rastrigin: case RS_Rastrigin: case S_Rastrigin_CEC05: case RS_Rastrigin_CEC05:
               case Weierstrass: case RS_Weierstrass: case R_Weierstrass: case RS_Weierstrass_CEC05:
               case Griewank: case R_Griewank: case RS_Griewank:  case RS_Griewank_noBounds_CEC05: case Griewank_Rosenbrock_F13_CEC05: case S_Griewank_Rosenbrock_F13_CEC05:
               case Ackley: case Ackley_Noisy: case S_Ackley: case R_Ackley: case RS_Ackley: case RS_Ackley_Bound_CEC05:
               case Step:
               case Quartic_Noisy:
               case Scaffer_F6:  case Expanded_Scaffer_F6_CEC05: case Noncont_Expanded_Scaffer_F6_CEC05: case RS_Expanded_Scaffer_F6_CEC05:
               case Rosenbrock: case S_Rosenbrock: case S_Rosenbrock_CEC05:
               case Schwefel_2_13_CEC05:
               case Schwefel_2_22: case Schwefel_2_22_Noisy: case S_Schwefel_2_22: case R_Schwefel_2_22: case RS_Schwefel_2_22:
               case Schwefel: case Schwefel_Noisy: case S_Schwefel: case R_Schwefel: case RS_Schwefel:
               case Schwefel_1_2: case Schwefel_1_2_Noisy: case S_Schwefel_1_2: case S_Schwefel_1_2_Noisy: case R_Schwefel_1_2: case RS_Schwefel_1_2:  case S_Schwefel_1_2_CEC05:  case S_Schwefel_1_2_Noisy_CEC05:
               case Schwefel_2_21:
               case Schwefel_2_6_Bound_CEC05:
               case Penalized_1:
               case Penalized_2:
               case Noncont_Rastrigin:
               case RS_Elliptic_CEC05: case Elliptic:
               case Com: case R_Com: case Com_CEC05: case H_Com_CEC05: case H_Com_Noisy_CEC05:
               case RH_Com_CEC05: case RH_Com_NarrowBasin_CEC05: case RH_Com_Bound_CEC05:
               case RH_Com_F21_CEC05:  case RH_Com_HighConNumMatrix_F22_CEC05:  case Noncont_RH_Com_F23_CEC05:  case RH_Com_F24_CEC05:  case RH_Com_noBounds_F25_CEC05:
               case M_global1: case M_global2: case M_global3: case M_global4: case M_global5:
               case S_Sphere_CEC08: case Schwefel_2_21_CEC08: case S_Rosenbrock_CEC08: case S_Rastrigin_CEC08: case S_Griewank_CEC08: case S_Ackley_CEC08:
               case RW_Gear_Train: case RW_ParEst_FMSoundWaves:{

            Global::gp_problem= gFunctionInstance[rPar[2]](gProblem[rPar[2]],atoi(rPar[6]),rPar[2]);
            Global::g_changeFre=Global::g_tEvals;
            PerformSingleObj::initialize(dynamic_cast< BenchmarkFunction *>(Global::gp_problem)->getKnownFlagGOpt());
            stringstream ss;
            ss<<"Alg"<<rPar[1]<<"_Pro"<<rPar[2]<<"_Dim"<<rPar[6]<<"_Popsize"<<rPar[7];
            Global::g_gPopsize=atoi(rPar[7]);
			if(Global::g_algNumber==ALG_SLPSO){
				SLSwarm::ms_updateFre=atoi(rPar[8]);
				SLSwarm::ms_learnRatio=atoi(rPar[9]);
				SLSwarm::ms_ratioLearnToGbest=atoi(rPar[10]);

				ss<<"_UpdateFre"<<rPar[8]<<"_LearnRatio"<<rPar[9]<<"_RatioLearnGbest"<<rPar[10];
			}
            PerformSingleObj::getPerformSingleObj()->setFileName(ss);
        }
        break;

        ///Dynamic Problems
        case CompositionDBG_DOP: {
            if(atoi(rPar[10])<0||atoi(rPar[10])>=CompositionDBG::msc_numFuns) {
                 Throw(Invalid_argument("error: no such sub-problem in CompositionDBG_DOP"));
                 return false;
            }
            if(atoi(rPar[9])<0||atoi(rPar[9])>=CompositionDBG::msc_NumChangeTypies){
                Throw(Invalid_argument("error: no such change type in CompositionDBG_DOP"));
                 return false;
            }
            if((ChangeType)(atoi(rPar[9]))==CompositionDBG::msc_NumChangeTypies-2)    CompositionDBG::initialize(atoi(rPar[6]),atoi(rPar[7]),(ChangeType)(atoi(rPar[9])),(ComDBGFuncID)(atoi(rPar[10])),atof(rPar[8]),true,false);
            else if((ChangeType)(atoi(rPar[9]))==CompositionDBG::msc_NumChangeTypies-1)   CompositionDBG::initialize(atoi(rPar[6]),atoi(rPar[7]),(ChangeType)(atoi(rPar[9])),(ComDBGFuncID)atoi(rPar[10]),atof(rPar[8]),false,true);
            else CompositionDBG::initialize(atoi(rPar[6]),atoi(rPar[7]),(ChangeType)(atoi(rPar[9])),(ComDBGFuncID)(atoi(rPar[10])),atof(rPar[8]),false,false);

            Global::gp_problem=CompositionDBG::getCompositionDBG();
            Global::g_changeFre=atoi(rPar[11]);
            CompositionDBG::getCompositionDBG()->setChangeFre( Global::g_changeFre);
            CompositionDBG::getCompositionDBG()->setMaxChangeNumber(Global::g_tEvals/Global::g_changeFre);

            PerformSingleObj::initialize(true);

			 if(atoi(rPar[12])==-1) setGPopSize();
            else  Global::g_gPopsize=atoi(rPar[12]);


			if(Global::g_algNumber==ALG_CPSOR||Global::g_algNumber==ALG_CPSO||Global::g_algNumber==ALG_CDER)        PopulationInforDOP::initialize();

            stringstream ss;
			if(Global::g_algNumber==ALG_CPSOR||Global::g_algNumber==ALG_CDER)
			ss<<"Alg"<<rPar[1]<<"_Pro"<<rPar[2]<<"_Dim"<<rPar[6]<<"_Peaks"<<atoi(rPar[7])<<"_ChangeRatio"<<rPar[8]<<"_SubPro"<<rPar[10]<<"_Type"<<atoi(rPar[9])<<"_gPopsize"<<rPar[12]<<"_subSize"<<rPar[13]<<"_overlapDgr"<<rPar[14]<<"_diverDgr"<<atof(rPar[15]);
			else if(Global::g_algNumber==ALG_CPSO)
			ss<<"Alg"<<rPar[1]<<"_Pro"<<rPar[2]<<"_Dim"<<rPar[6]<<"_Peaks"<<atoi(rPar[7])<<"_ChangeRatio"<<rPar[8]<<"_SubPro"<<rPar[10]<<"_Type"<<atoi(rPar[9])<<"_gPopsize"<<rPar[12]<<"_subSize"<<rPar[13]<<"_overlapDgr"<<rPar[14];
			else if(Global::g_algNumber==ALG_SPSO_Parrott||Global::g_algNumber==ALG_rSPSO)
				ss<<"Alg"<<rPar[1]<<"_Pro"<<rPar[2]<<"_Dim"<<rPar[6]<<"_Peaks"<<atoi(rPar[7])<<"_ChangeRatio"<<rPar[8]<<"_SubPro"<<rPar[10]<<"_Type"<<atoi(rPar[9])<<"_gPopsize"<<rPar[12]<<"_pMax"<<rPar[13]<<"_radius"<<rPar[14];
            else if(Global::g_algNumber==ALG_ESCA||Global::g_algNumber==ALG_mCPSO||Global::g_algNumber==ALG_mQSO||Global::g_algNumber==ALG_PSO_CP)
            ss<<"Alg"<<rPar[1]<<"_Pro"<<rPar[2]<<"_Dim"<<rPar[6]<<"_Peaks"<<atoi(rPar[7])<<"_ChangeRatio"<<rPar[8]<<"_SubPro"<<rPar[10]<<"_Type"<<atoi(rPar[9])<<"_gPopsize"<<rPar[12];
			else if(Global::g_algNumber==ALG_HmSO)
				ss<<"Alg"<<rPar[1]<<"_Pro"<<rPar[2]<<"_Dim"<<rPar[6]<<"_Peaks"<<atoi(rPar[7])<<"_ChangeRatio"<<rPar[8]<<"_SubPro"<<rPar[10]<<"_Type"<<atoi(rPar[9])<<"_gPopsize"<<rPar[12]<<"_subSize"<<rPar[13];

			if(Global::g_algNumber==ALG_HmSO){
				 if(atoi(rPar[13])==-1) setsubPopSize();
				else  Global::g_subSize=atoi(rPar[13]);
            }
			if(Global::g_algNumber==ALG_CPSO){
				if(atoi(rPar[13])==-1) setsubPopSize();
				else  Global::g_subSize=atoi(rPar[13]);
                if(atoi(rPar[14])==-1) setOverlapDegree();
                else  Global::g_overlapDegree=atof(rPar[14]);
            }

			if(Global::g_algNumber==ALG_SPSO_Parrott||Global::g_algNumber==ALG_rSPSO){
			 Global::g_subSize=atoi(rPar[13]);
             Global::g_overlapDegree=atof(rPar[14]); // overlapDegree denotes radius in SPSO_Parrott algorithm
			}

            if(Global::g_algNumber==ALG_CPSOR||Global::g_algNumber==ALG_CDER){
				if(atoi(rPar[13])==-1) setsubPopSize();
				else  Global::g_subSize=atoi(rPar[13]);
				if(atoi(rPar[14])==-1) setOverlapDegree();
                else  Global::g_overlapDegree=atof(rPar[14]);
                if(atoi(rPar[15])==-1) setDiversityDegree();
                else  Global::g_diversityDegree=atof(rPar[15]);
            }

            PerformSingleObj::getPerformSingleObj()->setFileName(ss);
			if(Global::g_algNumber==ALG_CPSOR||Global::g_algNumber==ALG_CPSO||Global::g_algNumber==ALG_CDER)       PopulationInforDOP::getPopInfor()->setFileName(ss);

        }

            break;

        case RotationDBG_DOP: {
            if(atoi(rPar[9])<0||atoi(rPar[9])>=CompositionDBG::msc_NumChangeTypies){
                Throw(Invalid_argument("error: no such change type in CompositionDBG_DOP"));
                 return false;
            }
             if((ChangeType)(atoi(rPar[9]))==RotationDBG::msc_NumChangeTypies-2)       RotationDBG::initialize(atoi(rPar[6]),atoi(rPar[7]),(ChangeType)(atoi(rPar[9])),atof(rPar[8]),true,false);
             else if((ChangeType)(atoi(rPar[9]))==RotationDBG::msc_NumChangeTypies-1)       RotationDBG::initialize(atoi(rPar[6]),atoi(rPar[7]),(ChangeType)(atoi(rPar[9])),atof(rPar[8]),false,true);
             else RotationDBG::initialize(atoi(rPar[6]),atoi(rPar[7]),(ChangeType)(atoi(rPar[9])),atof(rPar[8]),false,false);
                Global::gp_problem= RotationDBG::getRotationDBG();
                Global::g_changeFre=atoi(rPar[10]);
                RotationDBG::getRotationDBG()->setChangeFre( Global::g_changeFre);
                RotationDBG::getRotationDBG()->setMaxChangeNumber(Global::g_tEvals/Global::g_changeFre);
                PerformSingleObj::initialize(true);

				if(Global::g_algNumber==ALG_CPSOR||Global::g_algNumber==ALG_CPSO||Global::g_algNumber==ALG_CDER)               PopulationInforDOP::initialize();

				stringstream ss;
				if(Global::g_algNumber==ALG_CPSOR||Global::g_algNumber==ALG_CDER)
				ss<<"Alg"<<rPar[1]<<"_Pro"<<rPar[2]<<"_Dim"<<rPar[6]<<"_Peaks"<<atoi(rPar[7])<<"_ChangeRatio"<<rPar[8]<<"_Type"<<atoi(rPar[9])<<"_gPopsize"<<rPar[11]<<"_subSize"<<rPar[12]<<"_overlapDgr"<<rPar[13]<<"_diverDgr"<<atof(rPar[14]);
				else if(Global::g_algNumber==ALG_CPSO)
				ss<<"Alg"<<rPar[1]<<"_Pro"<<rPar[2]<<"_Dim"<<rPar[6]<<"_Peaks"<<atoi(rPar[7])<<"_ChangeRatio"<<rPar[8]<<"_Type"<<atoi(rPar[9])<<"_gPopsize"<<rPar[11]<<"_subSize"<<rPar[12]<<"_overlapDgr"<<rPar[13];
				else if(Global::g_algNumber==ALG_SPSO_Parrott||Global::g_algNumber==ALG_rSPSO)
					ss<<"Alg"<<rPar[1]<<"_Pro"<<rPar[2]<<"_Dim"<<rPar[6]<<"_Peaks"<<atoi(rPar[7])<<"_ChangeRatio"<<rPar[8]<<"_Type"<<atoi(rPar[9])<<"_gPopsize"<<rPar[11]<<"_pMax"<<rPar[12]<<"_radius"<<rPar[13];
                else if(Global::g_algNumber==ALG_mCPSO||Global::g_algNumber==ALG_mQSO||Global::g_algNumber==ALG_PSO_CP||Global::g_algNumber==ALG_ESCA)
                ss<<"Alg"<<rPar[1]<<"_Pro"<<rPar[2]<<"_Dim"<<rPar[6]<<"_Peaks"<<atoi(rPar[7])<<"_ChangeRatio"<<rPar[8]<<"_Type"<<atoi(rPar[9])<<"_gPopsize"<<rPar[11];
				else if(Global::g_algNumber==ALG_HmSO)
				ss<<"Alg"<<rPar[1]<<"_Pro"<<rPar[2]<<"_Dim"<<rPar[6]<<"_Peaks"<<atoi(rPar[7])<<"_ChangeRatio"<<rPar[8]<<"_Type"<<atoi(rPar[9])<<"_gPopsize"<<rPar[11]<<"_subSize"<<rPar[12];


                 Global::g_gPopsize=atoi(rPar[11]);
				 if(atoi(rPar[11])==-1)setGPopSize();
                else  Global::g_gPopsize=atoi(rPar[11]);

				if(Global::g_algNumber==ALG_CPSO){
					if(atoi(rPar[12])==-1) setsubPopSize();
					else  Global::g_subSize=atoi(rPar[12]);
					if(atoi(rPar[13])==-1) setOverlapDegree();
					else  Global::g_overlapDegree=atof(rPar[13]);

                }
				if(Global::g_algNumber==ALG_HmSO){
					if(atoi(rPar[12])==-1) setsubPopSize();
					else  Global::g_subSize=atoi(rPar[12]);
                }

				if(Global::g_algNumber==ALG_SPSO_Parrott||Global::g_algNumber==ALG_rSPSO){
					 Global::g_subSize=atoi(rPar[12]);
					 Global::g_overlapDegree=atof(rPar[13]); // overlapDegree denotes radius in SPSO_Parrott algorithm
				}


                if(Global::g_algNumber==ALG_CPSOR||Global::g_algNumber==ALG_CDER){
					if(atoi(rPar[12])==-1) setsubPopSize();
					else  Global::g_subSize=atoi(rPar[12]);
					if(atoi(rPar[13])==-1) setOverlapDegree();
					else  Global::g_overlapDegree=atof(rPar[13]);
                    if(atoi(rPar[14])==-1) setDiversityDegree();
                    else  Global::g_diversityDegree=atof(rPar[14]);
                }

				if(Global::g_algNumber==ALG_CPSOR||Global::g_algNumber==ALG_CPSO||Global::g_algNumber==ALG_CDER)PopulationInforDOP::getPopInfor()->setFileName(ss);
                PerformSingleObj::getPerformSingleObj()->setFileName(ss);
        }
            break;
        case MovingPeak_DOP: {
            MovingPeak::initialize(atoi(rPar[6]),atoi(rPar[7]),atof(rPar[8]));
            Global::gp_problem=MovingPeak::getMPs();
            Global::g_changeFre=atoi(rPar[10]);
            dynamic_cast< MovingPeak *>(Global::gp_problem)->setChangeType(CT_Random);
            dynamic_cast< MovingPeak *>(Global::gp_problem)->setChangeFre(Global::g_changeFre);
            dynamic_cast< MovingPeak *>(Global::gp_problem)->setMaxChangeNumber(Global::g_tEvals/Global::g_changeFre);
            dynamic_cast< MovingPeak *>(Global::gp_problem)->setVlength(atof(rPar[9]));

            PerformSingleObj::initialize(true);

			if(Global::g_algNumber==ALG_CPSOR||Global::g_algNumber==ALG_CPSO||Global::g_algNumber==ALG_CDER)         PopulationInforDOP::initialize();

            stringstream ss;
			if(Global::g_algNumber==ALG_CPSOR||Global::g_algNumber==ALG_CDER)
            ss<<"Alg"<<rPar[1]<<"_Pro"<<rPar[2]<<"_Dim"<<rPar[6]<<"_Peaks"<<atoi(rPar[7])<<"_ChangeRatio"<<rPar[8]<<"_Vlength"<<rPar[9]<<"_gPopsize"<<rPar[11]<<"_subSize"<<rPar[12]<<"_overlapDgr"<<rPar[13]<<"_diverDgr"<<atof(rPar[14]);
			else if(Global::g_algNumber==ALG_CPSO)
			ss<<"Alg"<<rPar[1]<<"_Pro"<<rPar[2]<<"_Dim"<<rPar[6]<<"_Peaks"<<atoi(rPar[7])<<"_ChangeRatio"<<rPar[8]<<"_Vlength"<<rPar[9]<<"_gPopsize"<<rPar[11]<<"_subSize"<<rPar[12]<<"_overlapDgr"<<rPar[13];
			else if(Global::g_algNumber==ALG_SPSO_Parrott||Global::g_algNumber==ALG_rSPSO)
					ss<<"Alg"<<rPar[1]<<"_Pro"<<rPar[2]<<"_Dim"<<rPar[6]<<"_Peaks"<<atoi(rPar[7])<<"_ChangeRatio"<<rPar[8]<<"_Vlength"<<rPar[9]<<"_gPopsize"<<rPar[11]<<"_pMax"<<rPar[12]<<"_radius"<<rPar[13];
            else if(Global::g_algNumber==ALG_mCPSO||Global::g_algNumber==ALG_mQSO||Global::g_algNumber==ALG_PSO_CP||Global::g_algNumber==ALG_ESCA)
                ss<<"Alg"<<rPar[1]<<"_Pro"<<rPar[2]<<"_Dim"<<rPar[6]<<"_Peaks"<<atoi(rPar[7])<<"_ChangeRatio"<<rPar[8]<<"_Vlength"<<rPar[9]<<"_gPopsize"<<rPar[11];
			else if(Global::g_algNumber==ALG_HmSO)
				ss<<"Alg"<<rPar[1]<<"_Pro"<<rPar[2]<<"_Dim"<<rPar[6]<<"_Peaks"<<atoi(rPar[7])<<"_ChangeRatio"<<rPar[8]<<"_Vlength"<<rPar[9]<<"_gPopsize"<<rPar[11]<<"_subSize"<<rPar[12];
			PerformSingleObj::getPerformSingleObj()->setFileName(ss);

			if(atoi(rPar[11])==-1) setGPopSize();
            else  Global::g_gPopsize=atoi(rPar[11]);

			if(Global::g_algNumber==ALG_CPSO){

				if(atoi(rPar[12])==-1) setsubPopSize();
				else  Global::g_subSize=atoi(rPar[12]);

				if(atoi(rPar[13])==-1) setOverlapDegree();
				else  Global::g_overlapDegree=atof(rPar[13]);
            }
			if(Global::g_algNumber==ALG_SPSO_Parrott||Global::g_algNumber==ALG_rSPSO){
					Global::g_subSize=atoi(rPar[12]);
					Global::g_overlapDegree=atof(rPar[13]); // overlapDegree denotes radius in SPSO_Parrott algorithm
			}

            if(Global::g_algNumber==ALG_CPSOR||Global::g_algNumber==ALG_CDER){
				if(atoi(rPar[12])==-1) setsubPopSize();
				else  Global::g_subSize=atoi(rPar[12]);

				if(atoi(rPar[13])==-1) setOverlapDegree();
				else  Global::g_overlapDegree=atof(rPar[13]);
                if(atoi(rPar[14])==-1) setDiversityDegree();
                else  Global::g_diversityDegree=atof(rPar[14]);
            }
			if(Global::g_algNumber==ALG_HmSO){
				if(atoi(rPar[12])==-1) setsubPopSize();
				else  Global::g_subSize=atoi(rPar[12]);
			}
			if(Global::g_algNumber==ALG_CPSOR||Global::g_algNumber==ALG_CPSO||Global::g_algNumber==ALG_CDER)PopulationInforDOP::getPopInfor()->setFileName(ss);
        }
            break;
        case DF1_DOP:
            break;
        case Binary_DOP:
            break;
    }
    return true;
}
