#ifndef TEST_H_INCLUDED
#define TEST_H_INCLUDED

/*************************************************************************
* Project: Library of Evolutionary Algoriths
*************************************************************************
* Author: Changhe Li & Ming Yang
* Email: changhe.lw@google.com Or yangming0702@gmail.com
* Language: C++
*************************************************************************
*  This file is part of EAlib. This library is free software;
*  you can redistribute it and/or modify it under the terms of the
*  GNU General Public License as published by the Free Software
*  Foundation; either version 2, or (at your option) any later version.
*************************************************************************/
// Created: 21 September 2011
// Last modified:

///NOTE: ONLY FOR TEST PURPOSE



#include <iostream>

#include "../Problems/DOPs/MovingPeak.h"
#include "../Problems/DOPs/DF1.h"
#include "../Problems/DOPs/CompositionDBG.h"
#include "../Problems/DOPs/RotationDBG.h"
#include "../Problems/DOPs/BinaryDOP.h"

#include "../Problems/FunctionOpt/Sphere.h"
#include "../Problems/FunctionOpt/FAckley.h"
#include "../Problems/FunctionOpt/FGriewank.h"
#include "../Problems/FunctionOpt/FRastrigin.h"
#include "../Problems/FunctionOpt/FWeierstrass.h"
#include "../Problems/FunctionOpt/HybridComp.h"
#include "../Problems/FunctionOpt/FRosenbrock.h"
#include "../Problems/FunctionOpt/FElliptic.h"
#include "../Problems/FunctionOpt/FMAX_global1.h"
#include "../Problems/FunctionOpt/FMAX_global2.h"
#include "../Problems/FunctionOpt/FMAX_global3.h"
#include "../Problems/FunctionOpt/FMAX_global4.h"
#include "../Problems/FunctionOpt/FMAX_global5.h"
#include "../Problems/FunctionOpt/FNoncont_Rastrigin.h"
#include "../Problems/FunctionOpt/FPenalized_1.h"
#include "../Problems/FunctionOpt/FPenalized_2.h"
#include "../Problems/FunctionOpt/FQuartic_Noisy.h"
#include "../Problems/FunctionOpt/FScaffer_F6.h"
#include "../Problems/FunctionOpt/FSchwefel.h"
#include "../Problems/FunctionOpt/FSchwefel_1_2.h"
#include "../Problems/FunctionOpt/FSchwefel_2_22.h"
#include "../Problems/FunctionOpt/FStep.h"
#include "../Problems/FunctionOpt/Schwefel_2_21.h"
#include "../Problems/RealWorld/FGear_Train.h"
#include "../Problems/RealWorld/FParEst_FMSoundWaves.h"

#include "../Algorithms/Chromosome.h"

#include <map>


#include "../PerformanceMeasure/PerformSingleObj.h"

bool detectChange(double *x, double obj){
	if(obj!=Global::gp_problem->evaluate(x,false)) return true;
	else return false;
}
void initializeSolution(double *x, double &obj){

	int dim=Global::gp_problem->getDimNumber();

    double  lb,ub;
    for(int i=0;i<dim;i++) {
        Global::gp_problem->getSearchRange(lb,ub,i);
        x[i]=lb+(ub-lb)*Global::gp_uniformAlg->Next();
    }
	obj=Global::gp_problem->evaluate(x);
}

void testMovingPeaks(){

    double *x=new double [5];

    for(int i=0;i<5;i++) x[i]=0;
    Global::g_proNumber=MovingPeak_DOP;
    MovingPeak::initialize(5,10,1.0);
    MovingPeak::getMPs()->setChangeType(CT_Random);
    MovingPeak::getMPs()->setChangeFre(5000);
    MovingPeak::getMPs()->setMaxChangeNumber(100);

    for(int i=0; i< MovingPeak::getMPs()->getMaxChangeNumber(); i++) {
        int maxPeaks=MovingPeak::getMPs()->getNumberofGlobalOptPeak();
        int peaks=MovingPeak::getMPs()->getNumberofPeak();
        cout<<"the number of global optima: "<<maxPeaks<<endl;
        for(int j=0; j<peaks; j++) {
            if(MovingPeak::getMPs()->getGlobalOptimaIdx()[j]) MovingPeak::getMPs()->printPeak(j);
        }
        cout<<"the max height of the "<<i<<"th change: "<<MovingPeak::getMPs()->getGlobalMax()<<endl;

         cout<<"the objective value of x is : "<< MovingPeak::getMPs()->evaluate(x)<<endl;

        MovingPeak::getMPs()->change();
    }
    MovingPeak::deleteMPs();
    delete []x;
}

void testDF1(){
    Global::g_proNumber=DF1_DOP;
    DF1::initialize(5,10);
    DF1::getDF1()->setChangeType(CT_Random);
    DF1::getDF1()->setChangeFre(5000);
    DF1::getDF1()->setMaxChangeNumber(100);

    for(int i=0;i< DF1::getDF1()->getMaxChangeNumber();i++){
        int maxPeaks=DF1::getDF1()->getNumberofGlobalOptPeak();
        int peaks=DF1::getDF1()->getNumberofPeak();
        cout<<"the number of global optima: "<<maxPeaks<<endl;
        for(int j=0;j<peaks;j++){
            if(DF1::getDF1()->getGlobalOptimaIdx()[j])     DF1::getDF1()->printPeak(j);
        }
        cout<<"the max height of the "<<i<<"th change: "<<DF1::getDF1()->getGlobalMax()<<endl;
        DF1::getDF1()->change();
    }
    DF1::deleteDF1();

}

void testCompositionDBG(){


    Global::g_proNumber=CompositionDBG_DOP;
	Global::g_tEvals=10000;
    for(int k=0;k<CompositionDBG::msc_numFuns;k++){
        for(int t=0;t<CompositionDBG::msc_NumChangeTypies;t++){
            if((ChangeType)t==CompositionDBG::msc_NumChangeTypies-2)    CompositionDBG::initialize(5,10,(ChangeType)t,(ComDBGFuncID)k,1.0,true,false);
            else if((ChangeType)t==CompositionDBG::msc_NumChangeTypies-1)   CompositionDBG::initialize(5,10,(ChangeType)t,(ComDBGFuncID)k,1.0,false,true);
            else CompositionDBG::initialize(5,10,(ChangeType)t,(ComDBGFuncID)k,1.0,false,false);

            CompositionDBG::getCompositionDBG()->setChangeFre(10);
			Global::gp_problem=CompositionDBG::getCompositionDBG();
           double obj;
			double *x=new double[Global::gp_problem->getDimNumber()];
			while(!gIsTerminate()){
				initializeSolution(x,obj);
				if(dynamic_cast<DynamicProblem *>(Global::gp_problem)->getFlagDimensionChange()&&Global::gp_problem->getEvaluations()%dynamic_cast<DynamicProblem *>(Global::gp_problem)->getChangeFre()==0){
					delete []x;
					x=0;
					x=new double[Global::gp_problem->getDimNumber()];
				}
				Global::gp_problem->evaluate(x);
				if(dynamic_cast<DynamicProblem *>(Global::gp_problem)->getFlagDimensionChange()&&Global::gp_problem->getEvaluations()%dynamic_cast<DynamicProblem *>(Global::gp_problem)->getChangeFre()==0){
					delete []x;
					x=0;
					x=new double[Global::gp_problem->getDimNumber()];
				}

			}
			delete []x;
			cout<<k<<" "<<t<<endl;
            CompositionDBG::deleteCompositionDBG();

        }
    }


}

void testRotationDBG(){

    Global::g_proNumber=RotationDBG_DOP;
	Global::g_tEvals=10000;
    for(int t=0;t<RotationDBG::msc_NumChangeTypies;t++){

         if((ChangeType)t==RotationDBG::msc_NumChangeTypies-2)       RotationDBG::initialize(5,10,(ChangeType)t,1.0,true,false);
         else if((ChangeType)t==RotationDBG::msc_NumChangeTypies-1)       RotationDBG::initialize(5,10,(ChangeType)t,0.5,false,true);
         else RotationDBG::initialize(5,10,(ChangeType)t,0.5,false,false);

        RotationDBG::getRotationDBG()->setChangeFre(10);
		Global::gp_problem=RotationDBG::getRotationDBG();
		double obj;
		int suc=0;
		double *x=new double[Global::gp_problem->getDimNumber()];
		while(!gIsTerminate()){

			initializeSolution(x,obj);
			if(dynamic_cast<DynamicProblem *>(Global::gp_problem)->getFlagDimensionChange()&&Global::gp_problem->getEvaluations()%dynamic_cast<DynamicProblem *>(Global::gp_problem)->getChangeFre()==0){
				delete []x;
				x=0;
				x=new double[Global::gp_problem->getDimNumber()];
			}
			if(detectChange(x,obj)) suc++;
			Global::gp_problem->evaluate(x);
			if(dynamic_cast<DynamicProblem *>(Global::gp_problem)->getFlagDimensionChange()&&Global::gp_problem->getEvaluations()%dynamic_cast<DynamicProblem *>(Global::gp_problem)->getChangeFre()==0){
				delete []x;
				x=0;
				x=new double[Global::gp_problem->getDimNumber()];
			}
			if(detectChange(x,obj)) suc++;
		}
		cout<<suc/(double)dynamic_cast<DynamicProblem *>(Global::gp_problem)->getChangeCounter()<<endl;
		delete []x;

        RotationDBG::deleteRotationDBG();
    }

}

void testBinaryDOP(){
    Global::g_proNumber=Binary_DOP;
    for(int t=0;t<BinaryDOP::msc_NumChangeTypies;t++){
            BinaryDOP::initialize(10,20,(ChangeType)t);
             BinaryDOP::getBinaryDOP()->setChangeFre(5000);
             BinaryDOP::getBinaryDOP()->setMaxChangeNumber(30);

            for(int i=0;i<  BinaryDOP::getBinaryDOP()->getMaxChangeNumber();i++){
                int maxPeaks=BinaryDOP::getBinaryDOP()->getNumberofGlobalOptPeak();
                int peaks=BinaryDOP::getBinaryDOP()->getNumberofPeak();
                cout<<"the number of global optima: "<<maxPeaks<<endl;
                for(int j=0;j<peaks;j++){
                    if(BinaryDOP::getBinaryDOP()->getGlobalOptimaIdx()[j])     BinaryDOP::getBinaryDOP()->printPeak(j);
                }
                cout<<"the max height of the "<<i<<"th change: "<< BinaryDOP::getBinaryDOP()->getGlobalMax()<<endl<<endl;
                BinaryDOP::getBinaryDOP()->change();
            }
            BinaryDOP::deleteBinaryDOP();
              //     getchar();
        }
}



void evaluateSolution(/*BenchmarkFunction *Global::gp_problem */){
    int dim=Global::gp_problem->getDimNumber();
    double *x=new double[dim];

    double  lb,ub;
    for(int i=0;i<dim;i++) {
        Global::gp_problem->getSearchRange(lb,ub,i);
        x[i]=lb+(ub-lb)*Global::gp_uniformAlg->Next();
    }
    cout<<"objective value of location x in function "<<gProName[Global::gp_problem->getId()]<<" is: "<<Global::gp_problem->evaluate(x)<<endl;
    delete [] x;

}
void testFunctions(){


    Global::g_proNumber=RS_Sphere;
    Global::gp_problem=new FSphere(RS_Sphere,10,(char *)"Rotated Shifted Sphere");
    evaluateSolution();
    delete Global::gp_problem;
    getchar();

    Global::g_proNumber=RH_Com_Bound_CEC05;
    Global::gp_problem=new HybridComp(RH_Com_Bound_CEC05, 10, (char *) gProName[RH_Com_Bound_CEC05].c_str());
    evaluateSolution();
    delete Global::gp_problem;
    getchar();


    Global::g_proNumber=Com;
    Global::gp_problem=new HybridComp(Com, 10, (char *) gProName[Com].c_str());
    evaluateSolution();
    delete Global::gp_problem;
    getchar();

    Global::g_proNumber=R_Com;
    Global::gp_problem=new HybridComp(R_Com, 10, (char *) gProName[R_Com].c_str());
    evaluateSolution();
    delete Global::gp_problem;
    getchar();

    Global::g_proNumber=Com_CEC05;
    Global::gp_problem=new HybridComp(Com_CEC05, 10, (char *) gProName[Com_CEC05].c_str());
    evaluateSolution();
    delete Global::gp_problem;
    getchar();

    Global::g_proNumber=H_Com_CEC05;
    Global::gp_problem=new HybridComp(H_Com_CEC05, 10, (char *) gProName[H_Com_CEC05].c_str());
    evaluateSolution();
    delete Global::gp_problem;
     getchar();

    Global::g_proNumber=H_Com_Noisy_CEC05;
    Global::gp_problem=new HybridComp(H_Com_Noisy_CEC05, 10, (char *) gProName[H_Com_Noisy_CEC05].c_str());
    evaluateSolution();
    delete Global::gp_problem;
    getchar();

    Global::g_proNumber=RH_Com_CEC05;
    Global::gp_problem=new HybridComp(RH_Com_CEC05, 10, (char *) gProName[RH_Com_CEC05].c_str());
    evaluateSolution();
    delete Global::gp_problem;
    getchar();

    Global::g_proNumber=RH_Com_NarrowBasin_CEC05;
    Global::gp_problem=new HybridComp(RH_Com_NarrowBasin_CEC05, 10, (char *) gProName[RH_Com_NarrowBasin_CEC05].c_str());
    evaluateSolution();
    delete Global::gp_problem;
    getchar();

    Global::g_proNumber=S_Rosenbrock;
    Global::gp_problem=new FRosenbrock(S_Rosenbrock, 10, (char *) gProName[S_Rosenbrock].c_str());
    evaluateSolution();
    delete Global::gp_problem;
    getchar();

    Global::g_proNumber=RS_Elliptic_CEC05;
    Global::gp_problem=new FElliptic(RS_Elliptic_CEC05, 10, (char *) gProName[RS_Elliptic_CEC05].c_str());
    evaluateSolution();
    delete Global::gp_problem;
    getchar();

    Global::g_proNumber=RS_Griewank;
    Global::gp_problem=new FGriewank(RS_Griewank, 10, (char *) gProName[RS_Griewank].c_str());
    evaluateSolution();
    delete Global::gp_problem;
    getchar();


    Global::g_proNumber=M_global1;
    Global::gp_problem=new FMAX_global1(M_global1, 0,(char *) gProName[M_global1].c_str());
    evaluateSolution();
    delete Global::gp_problem;
    getchar();

    Global::g_proNumber=M_global5;
    Global::gp_problem=new FMAX_global5(M_global5, 0,(char *) gProName[M_global5].c_str());
    evaluateSolution();
    delete Global::gp_problem;
    getchar();

    Global::g_proNumber=Noncont_Rastrigin;
    Global::gp_problem=new FNoncont_Rastrigin(Noncont_Rastrigin, 0,(char *) gProName[Noncont_Rastrigin].c_str());
    evaluateSolution();
    delete Global::gp_problem;
    getchar();

    Global::g_proNumber=Penalized_1;
    Global::gp_problem=new FPenalized_1(Penalized_1, 10, (char *) gProName[Penalized_1].c_str());
    evaluateSolution();
    delete Global::gp_problem;
    getchar();


    Global::g_proNumber=Quartic_Noisy;
    Global::gp_problem=new FQuartic_Noisy(Quartic_Noisy, 10, (char *) gProName[Quartic_Noisy].c_str());
    evaluateSolution();
    delete Global::gp_problem;
    getchar();

    Global::g_proNumber=Scaffer_F6;
    Global::gp_problem=new FScaffer_F6(Scaffer_F6,  0,(char *) gProName[Scaffer_F6].c_str());
    evaluateSolution();
    delete Global::gp_problem;
    getchar();

    Global::g_proNumber=RS_Schwefel;
    Global::gp_problem=new FSchwefel(RS_Schwefel, 10, (char *) gProName[RS_Schwefel].c_str());
    evaluateSolution();
    delete Global::gp_problem;
    getchar();

    Global::g_proNumber=RS_Schwefel_1_2;
    Global::gp_problem=new FSchwefel_1_2(RS_Schwefel_1_2, 10, (char *) gProName[RS_Schwefel_1_2].c_str());
    evaluateSolution();
    delete Global::gp_problem;
    getchar();

    Global::g_proNumber=RW_Gear_Train;
    Global::gp_problem=new FGear_Train(RW_Gear_Train, 0, (char *) gProName[RW_Gear_Train].c_str());
    evaluateSolution();
    delete Global::gp_problem;
    getchar();

    Global::g_proNumber=RW_ParEst_FMSoundWaves;
    Global::gp_problem=new FParEst_FMSoundWaves(RW_ParEst_FMSoundWaves,  0,(char *) gProName[RW_ParEst_FMSoundWaves].c_str());
    evaluateSolution();
    delete Global::gp_problem;
    getchar();


}

void testMovingPeaksPerfor(){
    Global::g_numRuns=100;
    Global::g_changeFre=5000;
    Global::g_tEvals=500000;
    Global::g_sampleFre=100;
    Global::g_runIdx=0;

    Global::g_proNumber=MovingPeak_DOP;
    MovingPeak::initialize(5,10,1.0);
    Global::gp_problem=MovingPeak::getMPs();

    PerformSingleObj::initialize(true);
    stringstream ss;
    ss.str("MovingPeak");
    PerformSingleObj::getPerformSingleObj()->setFileName(ss);

    dynamic_cast< MovingPeak *>(Global::gp_problem)->setChangeType(CT_Random);
    dynamic_cast< MovingPeak *>(Global::gp_problem)->setChangeFre(Global::g_changeFre);
    dynamic_cast< MovingPeak *>(Global::gp_problem)->setMaxChangeNumber(Global::g_tEvals/Global::g_changeFre);

    for( Global::g_runIdx=0;Global::g_runIdx<Global::g_numRuns;Global::g_runIdx++) {
        double gOpt;

        if(dynamic_cast< MovingPeak *>(Global::gp_problem)->getKnownFlagGOpt()) {
            dynamic_cast< MovingPeak *>(Global::gp_problem)->getObjGlobalOpt(&gOpt);
            PerformSingleObj::getPerformSingleObj()->addGOpt(gOpt);
        }

        Chromosome x;
        double lb,ub;

        while(!gIsTerminate()){
            for(int i=0;i<dynamic_cast< MovingPeak *>(Global::gp_problem)->getDimNumber();i++) {
                dynamic_cast< MovingPeak *>(Global::gp_problem)->getSearchRange<double>(lb,ub,i);
                x.getGene<double>(i)=gRandFloat(lb,ub);
            }
            x.evaluate();
        }

        dynamic_cast< MovingPeak *>(Global::gp_problem)->reset();
        PerformSingleObj::getPerformSingleObj()->resetGOptIndx();
        Global::gp_problem->resetEvaluations();
        cout<<Global::g_runIdx<<endl;
    }

    PerformSingleObj::getPerformSingleObj()->calculatePerformance();
    PerformSingleObj::getPerformSingleObj()->outputResult();

    PerformSingleObj::deletePerformSingleObj();
     delete Global::gp_problem;
}

void testGDBG(){


    Global::g_numRuns=2;
    Global::g_changeFre=500;
    Global::g_tEvals=30000;
    Global::g_sampleFre=100;
    Global::g_runIdx=0;

    Global::g_proNumber=CompositionDBG_DOP;
    for(int k=0;k<CompositionDBG::msc_numFuns;k++){
        for(int t=0;t<CompositionDBG::msc_NumChangeTypies;t++){
            if((ChangeType)t==CompositionDBG::msc_NumChangeTypies-2)    CompositionDBG::initialize(5,10,(ChangeType)t,(ComDBGFuncID)k,1.0,true,false);
            else if((ChangeType)t==CompositionDBG::msc_NumChangeTypies-1)   CompositionDBG::initialize(5,10,(ChangeType)t,(ComDBGFuncID)k,1.0,false,true);
            else CompositionDBG::initialize(5,10,(ChangeType)t,(ComDBGFuncID)k,1.0,false,false);

            Global::gp_problem=CompositionDBG::getCompositionDBG();

            CompositionDBG::getCompositionDBG()->setChangeFre( Global::g_changeFre);
            CompositionDBG::getCompositionDBG()->setMaxChangeNumber(Global::g_tEvals/Global::g_changeFre);

            PerformSingleObj::initialize(true);
            stringstream ss;
            ss<<"CompositionDBG_P"<<k+1<<"T"<<t+1;
            PerformSingleObj::getPerformSingleObj()->setFileName(ss);

            for( Global::g_runIdx=0;Global::g_runIdx<Global::g_numRuns;Global::g_runIdx++) {
                double gOpt;

                if(dynamic_cast< CompositionDBG *>(Global::gp_problem)->getKnownFlagGOpt()) {
                   Global::gp_problem->getObjGlobalOpt(&gOpt);
                   PerformSingleObj::getPerformSingleObj()->addGOpt(gOpt);
                }

                Chromosome x;

                while(!gIsTerminate()){
					if(x.mc_length<Global::g_dimNumber){
						x.increaseDimension();
					}else if(x.mc_length>Global::g_dimNumber){
						x.decreaseDimension();
					}
                    for(int i=0;i<Global::gp_problem->getDimNumber();i++) {
                        double lb,ub;
                        Global::gp_problem->getSearchRange<double>(lb,ub,i);
                        x.getGene<double>(i)=gRandFloat(lb,ub);
                        //cout<<x.getObj()<<" ";
                    }
                    x.evaluate();

                }

                PerformSingleObj::getPerformSingleObj()->resetGOptIndx();
                Global::gp_problem->resetEvaluations();
                cout<<"P"<<k+1<<"T"<<t+1<<Global::g_runIdx<<endl;
            }


            PerformSingleObj::getPerformSingleObj()->calculatePerformance();
            PerformSingleObj::getPerformSingleObj()->outputResult();

            PerformSingleObj::deletePerformSingleObj();

            delete Global::gp_problem;
            //CompositionDBG::deleteCompositionDBG();
        }
    }


    Global::g_proNumber=RotationDBG_DOP;
    for(int t=0;t<RotationDBG::msc_NumChangeTypies;t++){
         if((ChangeType)t==RotationDBG::msc_NumChangeTypies-2)       RotationDBG::initialize(5,10,(ChangeType)t,1.0,true,false);
         else if((ChangeType)t==RotationDBG::msc_NumChangeTypies-1)       RotationDBG::initialize(5,10,(ChangeType)t,1.0,false,true);
         else RotationDBG::initialize(5,10,(ChangeType)t,1.0,false,false);

            Global::gp_problem= RotationDBG::getRotationDBG();

            RotationDBG::getRotationDBG()->setChangeFre( Global::g_changeFre);
            RotationDBG::getRotationDBG()->setMaxChangeNumber(Global::g_tEvals/Global::g_changeFre);

            PerformSingleObj::initialize(true);
            stringstream ss;
            ss<<"RotationDBG_T"<<t+1;
            PerformSingleObj::getPerformSingleObj()->setFileName(ss);

            for( Global::g_runIdx=0;Global::g_runIdx<Global::g_numRuns;Global::g_runIdx++) {
                double gOpt;

                if(dynamic_cast< RotationDBG *>(Global::gp_problem)->getKnownFlagGOpt()) {
                    dynamic_cast< RotationDBG *>(Global::gp_problem)->getObjGlobalOpt(&gOpt);
                   PerformSingleObj::getPerformSingleObj()->addGOpt(gOpt);
                }

                Chromosome x;
                double lb,ub;

                while(!gIsTerminate()){
					if(x.mc_length<Global::g_dimNumber){
						x.increaseDimension();
					}else if(x.mc_length>Global::g_dimNumber){
						x.decreaseDimension();
					}
                    for(int i=0;i<Global::gp_problem->getDimNumber();i++) {
                        Global::gp_problem->getSearchRange<double>(lb,ub,i);
                        x.getGene<double>(i)=gRandFloat(lb,ub);
                    }
                    x.evaluate();

                }

                PerformSingleObj::getPerformSingleObj()->resetGOptIndx();
                Global::gp_problem->resetEvaluations();
                cout<<"T"<<t<<Global::g_runIdx<<endl;

            }


            PerformSingleObj::getPerformSingleObj()->calculatePerformance();
            PerformSingleObj::getPerformSingleObj()->outputResult();

            PerformSingleObj::deletePerformSingleObj();
            delete Global::gp_problem;
        }

}


void testPerformanceMetric(){
Global::g_numRuns=30;
Global::g_tEvals=10000;
Global::g_changeFre=10000;
Global::g_sampleFre=100;
Global::g_runIdx=0;

Global::g_proNumber=Sphere;
Global::gp_problem=new FSphere(Sphere,2,(char *)"Sphere");


double gOpt;

PerformSingleObj::initialize(dynamic_cast< BenchmarkFunction *>(Global::gp_problem)->getObjGlobalOpt(&gOpt));
stringstream ss;
ss<<"Sphere";
PerformSingleObj::getPerformSingleObj()->setFileName(ss);

for( Global::g_runIdx=0;Global::g_runIdx<Global::g_numRuns;Global::g_runIdx++) {

   if(dynamic_cast< BenchmarkFunction *>(Global::gp_problem)->getKnownFlagGOpt()) {
        dynamic_cast< BenchmarkFunction *>(Global::gp_problem)->getObjGlobalOpt(&gOpt);
       PerformSingleObj::getPerformSingleObj()->addGOpt(gOpt);
    }

    Chromosome x;

    x.getGene<double>(0)=100-Global::g_runIdx;
    x.getGene<double>(1)=100-Global::g_runIdx;
    x.evaluate();

    int i=1;
    while(Global::gp_problem->getEvaluations()<Global::g_tEvals){
        x.getGene<double>(0)=100-(100.* (Global::gp_problem->getEvaluations()+1.))/Global::g_tEvals;
        x.getGene<double>(1)=100-(100.* (Global::gp_problem->getEvaluations()+1.))/Global::g_tEvals;
        x.evaluate();
        i++;
    }
    PerformSingleObj::getPerformSingleObj()->resetGOptIndx();
    Global::gp_problem->resetEvaluations();
}

PerformSingleObj::getPerformSingleObj()->calculatePerformance();
PerformSingleObj::getPerformSingleObj()->outputResult();

delete Global::gp_problem;

PerformSingleObj::deletePerformSingleObj();

}


#endif // TEST_H_INCLUDED
