// Matrix.h
#pragma once
#ifndef Matrix_H
#define Matrix_H
#ifdef use_namespace
namespace namespace_Matrix{
#endif

#include <fstream>
#include "MyVector.h"
using namespace std;

class Matrix{								// *****************Orthogonal rotation matrix***********************
public:
	int col,row;										// matrix size
	MyVector *vec;									// value of each element
public:
	Matrix();
	Matrix(const int c,const int r);
	~Matrix();
	void operator *(const Matrix & m);
	void operator *(const double x);
	Matrix & operator=(const Matrix & m);
	bool Identity();
	bool isIdentity();
	void Set_Rotation(const int &r,const int &c,const double &angle);
	void GenerateRotationMatrix(const double CondiNum,bool rMode);
	void Randomize(bool rMode);
	void Orthonormalization();
	void InitialToZero();
	const MyVector *Get_Data()const {
		return const_cast<const MyVector *>(vec);
	}
	double getData(const int r, const int c);
	void setDataRow(const double *d, const int c,const int r=1);
	void setDataCol(const double *d, const int r,const int c=1);
	void setData(const double * const * d);
	void Diagonal(const double CondiNum );
	void Transpose();
	void inverse();

	void Read_Data(ifstream &in){
		for(int i=0;i<row;i++){
			for(int j=0;j<col;j++)
				in>>vec[i].data[j];
		}
	};
	// used for debug
	void Print(ofstream & out){
		for(int i=0;i<row;i++){
			for(int j=0;j<col;j++)
				out<<vec[i].data[j]<<" ";
			out<<endl;
		}
		//out<<endl;
	};
	protected:
        void freeMemory();
        void allocateMemory(const int r, const int c);
};
#ifdef use_namespace
}
#endif

#endif
