#include "MyVector.h"

MyVector::MyVector(){
	data=0;
	size=0;
	/*if(Global::num_dim<1) Throw(Logic_error("size of vector must be greater than 0"));
		size=Global::num_dim;
		data=new double[size];*/
}
MyVector::MyVector(const int s){
	if(s<1) Throw(Logic_error("size of vector must be greater than 0"));
	size=s;
	data=new double[size];
}

void  MyVector::freeMemory(){
    delete []data;
    data=0;
}
void  MyVector::allocateMemory(const int s){
    if(s<1) Throw(Logic_error("size of vector must be greater than 0"));
	size=s;
	data=new double[size];

}

MyVector::~MyVector(){
	freeMemory();
}
MyVector &MyVector::operator =(const MyVector & v){
		if(this==&v) return *this;
		for(int i=0;i<size;i++) data[i]=v.data[i];
		return *this;
	}
void MyVector::operator +(const MyVector & v){
	if(size!=v.size) Throw(Logic_error("the size of two vectors must be same by + operation"));

	for(int i=0;i<size;i++) data[i]=data[i]+v.data[i];

}
 void MyVector::operator -(const MyVector & v){
	if(size!=v.size) Throw(Logic_error("the size of two vectors must be same by - operation"));

	for(int i=0;i<size;i++) data[i]=data[i]-v.data[i];

}
 double MyVector::operator *(const MyVector & v){
	if(size!=v.size) Throw(Logic_error("the size of two vectors must be same by * operation"));
	double sum=0;
	for(int i=0;i<size;i++) sum+=data[i]*v.data[i];

	return sum;
}
 void MyVector::ProjectionToV(MyVector &v){

	double sv=0,vv=0;
	for(int i=0;i<size;i++){
		sv+=data[i]*v.data[i];
		vv+=v.data[i]*v.data[i];
	}
	for(int i=0;i<size;i++){
		data[i]=sv*v.data[i]/vv;
	}
}

 void MyVector::Normalization(){
	double sum=0;
	for(int i=0;i<size;i++) sum+=data[i]*data[i];
	sum=sqrt(sum);
	for(int i=0;i<size;i++) data[i]=data[i]/sum;
 }




