//Smart_Pointer.h

#ifndef Smart_Pointer_H
#define Smart_Pointer_H

template <class T>
class SmartPtr
{
public:
	explicit SmartPtr(T* p=0): pointee(p){}
	template<class U>
	SmartPtr(SmartPtr<U> & rhs):pointee(rhs.release()){}

	template<class U>
	SmartPtr<T> & operator=(const SmartPtr<U> & rhs){
	  if(this!=&rhs) reset(rhs.release());
	  return *this;
	}
	~SmartPtr(){
	   delete pointee;
	};
	T& operator*() const{  return *pointee;	}
	T* operator->() const{  return pointee;	}
	T* get() const {return pointee; }
	T* release(){
		T *oldP=pointee;
		pointee=0;
		return oldP;
	}
	void reset(T *p=0){
		if(pointee!=p){
			delete pointee;
			pointee=p;
		}

	}
private:
	T* pointee;

	//friend class SmartPtr<T>;
};

#endif
