/* Memory allocation and deallocation routines */

# include <stdio.h>
# include <stdlib.h>
# include <math.h>

# include "Global.h"
# include "Random.h"

/* Function to allocate memory to a population */
void allocate_memory_pop (population *pop, int size)
{
    int i;
    pop->ind = (individual *)malloc(size*sizeof(individual));
    for (i=0; i<size; i++)
    {
        allocate_memory_ind (&(pop->ind[i]));
    }
    return;
}

/* Function to allocate memory to an individual */
void allocate_memory_ind (individual *ind)
{
    ind->xreal = (double *)malloc(nreal*sizeof(double));
    ind->obj = (double *)malloc(nobj*sizeof(double));

	ind->grid_coord = (int *)malloc(nobj*sizeof(int));
	ind->dominate_ind = (list *)malloc(sizeof(list));

	ind->dominate_ind->index = -1;
	ind->dominate_ind->parent = NULL;
	ind->dominate_ind->child = NULL;
	
    if (ncon != 0)
    {
        ind->constr = (double *)malloc(ncon*sizeof(double));
    }
    return;
}


/* Function to deallocate memory to a population */
void deallocate_memory_pop (population *pop, int size)
{
    int i;
    for (i=0; i<size; i++)
    {
        deallocate_memory_ind (&(pop->ind[i]));
    }
    free (pop->ind);
    return;
}

/* Function to deallocate memory to an individual */
void deallocate_memory_ind (individual *ind)
{
	list *temp;

	free(ind->xreal);
    free(ind->obj);
	free(ind->grid_coord);

	while (ind->dominate_ind!=NULL)
    {
        temp = ind->dominate_ind;
        ind->dominate_ind = ind->dominate_ind->child;
        free (temp);
    }

    if (ncon != 0)
    {
        free(ind->constr);
    }
    return;
}

