/* Dominance relation checking routines */

# include <stdio.h>
# include <stdlib.h>
# include <math.h>

# include "Global.h"
# include "Random.h"

// Compare Pareto dominance relation between individuals a and b
// it will return the following values
// 1 if a dominates b
// -1 if b dominates a
// 0 if both a and b are non-dominated 

int check_dominance (individual *a, individual *b)
{
    int i;
    int flag1;
    int flag2;
    flag1 = 0;
    flag2 = 0;
	
	for (i=0; i<nobj; i++)
	{
		if (a->obj[i] < b->obj[i])
		{
			flag1 = 1;
		}
		else
		{
			if (a->obj[i] > b->obj[i])
			{
				flag2 = 1;
			}
		}
	}
	if (flag1==1 && flag2==0)
	{
		return (1);
	}
	else
	{
		if (flag1==0 && flag2==1)
		{
			return (-1);
		}
		else
		{
			return (0);
		}
	}     
}

// Compare grid dominance relation between individuals a and b
// it will return the following values
// 1 if a grid_dominates b
// -1 if b grid_dominates a
// 0 if both a and b are non-grid_dominated 

int check_dominance_grid (individual *a, individual *b)
{
	int i;
	int flag1, flag2;
	flag1 = 0;
	flag2 = 0;

	for (i=0; i<nobj; i++)
	{
		if (a->grid_coord[i] < b->grid_coord[i])
		{
			flag1 = 1;			
		}
		else
		{
			if (a->grid_coord[i] > b->grid_coord[i])
			{
				flag2 = 1;
			}
		}
	}
	if (flag1==1 && flag2==0)
	{
		return (1);
	}
	else
	{
		if (flag1==0 && flag2==1)
		{
			return (-1);
		}
		else
		{
			return (0);
		}
	}
}
