/* Environmental selection in GrEA */

# include <stdio.h>
# include <stdlib.h>
# include <math.h>
# include <time.h>

# include "Global.h"
# include "Random.h"

/* Routine to perform environmental selection */
void environmental_selection (population *mixed_pop, population *new_pop)
{
	
	int flag, sum;
    int i, j, k;
    int end;
    int front_size;
    int archieve_size;
    list *pool;
    list *currentFront;
    list *temp1, *temp2, *temp3;
		
    pool = (list *)malloc(sizeof(list));
    currentFront = (list *)malloc(sizeof(list));

    front_size = 0;
    archieve_size=0;
    pool->index = -1;
    pool->parent = NULL;
    pool->child = NULL;
    currentFront->index = -1;
    currentFront->parent = NULL;
    currentFront->child = NULL;
    temp1 = pool;
    for (i=0; i<2*popsize; i++)
    {
        insert (temp1,i);
        temp1 = temp1->child;
    }
    i=0;
    do
    {
		// Partition mixed_pop into different fronts by using the Pareto nondominated sorting approach and find the critical front
		temp1 = pool->child;
        insert (currentFront, temp1->index);
        front_size = 1;
        temp2 = currentFront->child;
        temp1 = del (temp1);
        temp1 = temp1->child;
        do
        {
            temp2 = currentFront->child;
            if (temp1==NULL)
            {
                break;
            }
            do
            {
                end = 0;
                flag = check_dominance (&(mixed_pop->ind[temp1->index]), &(mixed_pop->ind[temp2->index]));
                if (flag == 1)
                {
                    insert (pool, temp2->index);
                    temp2 = del (temp2);
                    front_size--;
                    temp2 = temp2->child;
                }
                if (flag == 0)
                {
                    temp2 = temp2->child;
                }
                if (flag == -1 || flag == 2)
                {
                    end = 1;
                }
            }
            while (end!=1 && temp2!=NULL);
            if (flag == 0 || flag == 1)
            {
                insert (currentFront, temp1->index);
                front_size++;
                temp1 = del (temp1);
            }
            temp1 = temp1->child;
        }
        while (temp1 != NULL);
        temp2 = currentFront->child;
        j=i;

		// put the front before the critical front into the archive
        if ( (archieve_size+front_size) <= popsize)
        {
            do
            {
                copy_ind (&mixed_pop->ind[temp2->index], &new_pop->ind[i]);
                archieve_size+=1;
                temp2 = temp2->child;
                i+=1;
            }
            while (temp2 != NULL);
        }

        // select (N-i) individuals of the critical front into the archive; now the current front is the critical front
		else
        {
			construct_grid_list (mixed_pop, currentFront, front_size);					// construct grid environment
			assign_GR_GCPD_list (mixed_pop, currentFront, front_size);					// assign GR and GCPD for individuals in the critical front
			
			// assign 0 to GCD for individuals in the critical front
			temp2 = currentFront->child;
			while (temp2!=NULL)
			{
				mixed_pop->ind[temp2->index].crowd_dist = 0;
				temp2 = temp2->child;
			}

			// record the individuals that each individual grid-dominates in the critical front for the fitness adjustment procedure 
			calculate_dominate_ind_list (mixed_pop, currentFront, front_size);
	
			for (j=i; j<popsize; j++)
			{
				/*-------find the best individual in the current critical front------start---------*/	
				flag = currentFront->child->index;
				temp2 = currentFront->child->child;				
				while (temp2!=NULL)
				{
					if (mixed_pop->ind[temp2->index].rank < mixed_pop->ind[flag].rank)
					{
						flag = temp2->index;
					}
					else
					{
						if (mixed_pop->ind[temp2->index].rank == mixed_pop->ind[flag].rank && mixed_pop->ind[temp2->index].crowd_dist < mixed_pop->ind[flag].crowd_dist)
					        flag = temp2->index;
						else
						{
							if (mixed_pop->ind[temp2->index].rank == mixed_pop->ind[flag].rank && mixed_pop->ind[temp2->index].crowd_dist == mixed_pop->ind[flag].crowd_dist && mixed_pop->ind[temp2->index].distance < mixed_pop->ind[flag].distance)
								flag = temp2->index;
						}
					}
					temp2 = temp2->child;
				}
				/*-------find the best individual in the current critical front------end---------*/

				copy_ind(&mixed_pop->ind[flag], &new_pop->ind[j]);				// put the best individual into the archive
				temp2 = del(findnode(currentFront->child, flag));				// delete this individual in the current critical front 
				
				/*-------now perform GR adjustment and GCD calculation------start---------*/
				temp2 = currentFront->child;
				while (temp2 != NULL)
				{
					mixed_pop->ind[temp2->index].max_punishment = 0;
					temp2 = temp2->child;
				}

				// for the GR adjustment of individuals that are grid-domianted by the picked individual
				temp2 = mixed_pop->ind[flag].dominate_ind->child;
				while (temp2 != NULL)
				{					
					mixed_pop->ind[temp2->index].max_punishment = nobj;
					temp2 = temp2->child;
				}
				
				// for the GR and GCD adjustment of individuals that are the neighbor of the picked individual and their corresponding grid-dominated individuals
				temp2 = currentFront->child;
				while (temp2 != NULL)
				{
					sum = 0;
					for (k=0; k<nobj; k++)
					{
						sum += abs(mixed_pop->ind[temp2->index].grid_coord[k] - mixed_pop->ind[flag].grid_coord[k]);
					}					
					if (sum < nobj)         // if the tested individual is a neighbor of the picked individual
					{
						mixed_pop->ind[temp2->index].crowd_dist += nobj - sum;				// GCD adjustment 
						if (check_dominance_grid(&mixed_pop->ind[flag], &mixed_pop->ind[temp2->index]) != 1)	// if the tested individual is not grid-dominated by the picked individual 
						{
							if (sum == 0)	// for the GR adjustment of the individual whose is located in the same hyperbox as the picked individual
							{
								mixed_pop->ind[temp2->index].max_punishment = (nobj + 2);								
							}
							else			// for the GR adjustment of the individual is a neighbor of the picked individual but not in the same hyperbox as and also not grid-dominated by the picked one
							{
								// NOTE: the punishment degree of this individual can be larger than (nobj - sum) if it is grid-domianted by the individual who is a closer neighbor of the picked individual
								if (mixed_pop->ind[temp2->index].max_punishment < (nobj - sum))
								{
									mixed_pop->ind[temp2->index].max_punishment = (nobj - sum);	// for the GR adjustment of this individual
									// for the GR adjustment of the individuals that are grid-dominated by this individual
									temp3 = mixed_pop->ind[temp2->index].dominate_ind->child;
									while (temp3 != NULL)
									{
										if (mixed_pop->ind[temp3->index].max_punishment < (nobj - sum))
											mixed_pop->ind[temp3->index].max_punishment = (nobj - sum);
										temp3 = temp3->child;
									}
								}								
							}
						}						
					}
					temp2 = temp2->child;
				}
				// GR adjustment for individuals in the current critical front 
				temp2 = currentFront->child;
				while (temp2!=NULL)
				{
					mixed_pop->ind[temp2->index].rank += mixed_pop->ind[temp2->index].max_punishment;		
					temp2 = temp2->child;
				}
				/*-------now perform GR adjustment and GCD calculation------end---------*/
				
			}
            archieve_size = popsize;
        }
        temp2 = currentFront->child;
        do
        {
            temp2 = del (temp2);
            temp2 = temp2->child;
        }
        while (currentFront->child !=NULL);
    }
    while (archieve_size < popsize);
    while (pool!=NULL)
    {
        temp1 = pool;
        pool = pool->child;
        free (temp1);
    }
    while (currentFront!=NULL)
    {
        temp1 = currentFront;
        currentFront = currentFront->child;
        free (temp1);
    }
    return;
}

/* Routine to record the individuals that each individual grid-dominates in the critical front */
void calculate_dominate_ind_list (population *pop, list *currentFront, int front_size)
{
	int flag;
	list *temp1, *temp2;

	// clear up
	temp1 = currentFront->child;
	while (temp1!=NULL) 
	{
		temp2 = pop->ind[temp1->index].dominate_ind->child;
		while (temp2!=NULL)
		{
			temp2 = del(temp2);
			temp2 = temp2->child;
		}
		temp1 = temp1->child;
	}

	// record the individuals that an individual grid-dominates
	temp1 = currentFront->child;
	while (temp1!=NULL)
	{
		temp2 = temp1->child;
		while (temp2!=NULL)
		{
			flag = check_dominance_grid(&pop->ind[temp1->index], &pop->ind[temp2->index]);
			if (flag == 1)
				insert(pop->ind[temp1->index].dominate_ind, temp2->index);			
			if (flag == -1)
				insert(pop->ind[temp2->index].dominate_ind, temp1->index);
			temp2 = temp2->child;
		}
		temp1 = temp1->child;
	}
	return;
}
