/* Fitness assignment routine */

# include <stdio.h>
# include <stdlib.h>
# include <math.h>

# include "Global.h"
# include "Random.h"

// Both functions assign_GR_GCPD() and assign_GR_GCPD_list() are for the assignment of grid ranking(GR) and grid coordinate point distance(GCPD); 
// only difference of the two functions is the data structure which is used in different parts of the algorithm. 
void assign_GR_GCPD (population *pop)
{
	int i, j; 
	int flag;
	double value;

	for (i=0; i<popsize; i++)
	{
		flag = 0;
		value = 0;
		for (j=0; j<nobj; j++)
		{
			pop->ind[i].grid_coord[j] = (int)floor((pop->ind[i].obj[j]-grid_min[j])/grid_distance[j]);
			flag += pop->ind[i].grid_coord[j];
			value += pow((pop->ind[i].obj[j]-(grid_min[j]+pop->ind[i].grid_coord[j]*grid_distance[j]))/grid_distance[j], 2.0);
		}
		pop->ind[i].rank = flag;					
		pop->ind[i].distance = sqrt(value);			
	}
	return;
}

void assign_GR_GCPD_list (population *pop, list *currentFront, int front_size)
{
	int j;
	list *temp;
	int flag;
	double value;

	temp = currentFront->child;
	while (temp!=NULL)
	{
		flag = 0;
		value = 0;
		for (j=0; j<nobj; j++)
		{
			pop->ind[temp->index].grid_coord[j] = (int)floor ((pop->ind[temp->index].obj[j]-grid_min[j])/grid_distance[j]);
			flag += pop->ind[temp->index].grid_coord[j];

			value += pow((pop->ind[temp->index].obj[j]-(grid_min[j]+pop->ind[temp->index].grid_coord[j]*grid_distance[j]))/grid_distance[j], 2.0);
		}
		pop->ind[temp->index].rank = flag;					
		pop->ind[temp->index].distance = sqrt(value);		
		temp = temp->child;
	}
	return;
}


// Both functions assign_GCD() and assign_GCD_list() are for the assignment of grid crowding distance(GCD); 
// only difference of the two functions is the data structure which is used in different parts of the algorithm. 
void assign_GCD (population *pop)
{
	int i, j, k;
	int flag;

	for (i=0; i<popsize; i++)
	{
		pop->ind[i].crowd_dist = 0;
	}
	
	for (i=0; i<popsize; i++)
	{
		for (j=i+1; j<popsize; j++)
		{
			flag = 0;
			for (k=0; k<nobj; k++)
			{
				flag += abs(pop->ind[i].grid_coord[k]-pop->ind[j].grid_coord[k]);
			}
			if (flag < nobj)
			{			
				pop->ind[i].crowd_dist += (nobj-flag);
				pop->ind[j].crowd_dist += (nobj-flag);
			}				
		}
	}
	return;
}

void assign_GCD_list (population *pop, list *currentFront, int front_size)
{
	int k;
	int flag;
	list *temp1, *temp2;

	temp1 = currentFront->child;
	while (temp1!=NULL) 
	{
		pop->ind[temp1->index].crowd_dist = 0;
		temp1 = temp1->child;
	}
	
    temp1 = currentFront->child;
	while (temp1!=NULL)
	{
		temp2 = temp1->child;
		while (temp2!=NULL)
		{
			flag = 0;
			for (k=0; k<nobj; k++)
			{
				flag += abs(pop->ind[temp1->index].grid_coord[k]-pop->ind[temp2->index].grid_coord[k]);
			}
			if (flag<nobj)
			{	
				pop->ind[temp1->index].crowd_dist += (nobj-flag);	
				pop->ind[temp2->index].crowd_dist += (nobj-flag);
			}
			temp2 = temp2->child;
		}
		temp1 = temp1->child;
	}
	return;
}



