/* This file contains the variable and function declarations */

# define INF 1.0e14
# define EPS 1.0e-14
# define E  2.71828182845905
# define PI 3.14159265358979


/*-------global variables------start---------*/
typedef struct lists
{
    int index;
    struct lists *parent;
    struct lists *child;
} list;

typedef struct
{
    double *xreal;               // individual's variable value 
    double *obj;				 // individual's objective value 
    double *constr;				 // individual's constraint
	double constr_violation;	 // individual's constraint violation degree
    
	int *grid_coord;			 // individual's grid coordinate
	int rank;					 // individual's grid ranking(GR)
	int crowd_dist;				 // individual's grid crowding distance(GCD)
	double distance;             // individual's grid coordinate point distance(GCPD)
	
	list *dominate_ind;			 // record the individuals that the considered individual grid-dominates for the GR adjustment in enviromental selection
	int max_punishment;		     // record the maximum punishment degree of the considered individual for the GR adjustment in enviromental selection
} individual;

typedef struct
{
    individual *ind;
} population;

extern int nreal;
extern int nobj;
extern int ncon;
extern int popsize;
extern double pcross_real;
extern double pmut_real;
extern double eta_c;
extern double eta_m;
extern int nrun;
extern int currenteval;
extern int neval;

extern double *min_realvar;
extern double *max_realvar;

extern double *grid_distance;     // width of a hyperbox
extern double *grid_max;		  // upper boundary of the grid
extern double *grid_min;		  // lower boundary of the grid
extern int grid_div;			  // number of grid divisions

extern int I_number;			  // for test problem DTLZ5(I,M)
/*-------global variables------end---------*/

/*-------global function declarations------start---------*/
void allocate_memory_pop (population *pop, int size);
void allocate_memory_ind (individual *ind);
void deallocate_memory_pop (population *pop, int size);
void deallocate_memory_ind (individual *ind);

void initialize_pop (population *pop);
void initialize_ind (individual *ind);

void insert (list *node, int x);
list* del (list *node);
list* findnode(list *node, int x);

void evaluate_pop (population *pop);
void evaluate_ind (individual *ind);
void test_problem (double *xreal, double *obj, double *constr);

void construct_grid (population *pop);
void construct_grid_list (population *pop, list *currentFront, int front_size);

void assign_GR_GCPD (population *pop);
void assign_GR_GCPD_list (population *pop, list *currentFront, int front_size);
void assign_GCD(population *pop);
void assign_GCD_list (population *pop, list *currentFront, int front_size);

void selection (population *old_pop, population *new_pop);
individual* tournament (individual *ind1, individual *ind2);

void environmental_selection (population *mixed_pop, population *new_pop);
void calculate_dominate_ind_list (population *pop, list *currentFront, int front_size);

void crossover (individual *parent1, individual *parent2, individual *child1, individual *child2);
void SBX_cross (individual *parent1, individual *parent2, individual *child1, individual *child2);

void mutation_pop (population *pop);
void real_mutate_ind (individual *ind);

int check_dominance (individual *a, individual *b);
int check_dominance_grid (individual *a, individual *b);

void merge(population *pop1, population *pop2, population *pop3);
void copy_ind (individual *ind1, individual *ind2);

void report_objective(population *pop, FILE *fpt);
void report_variable (population *pop, FILE *fpt);
/*-------global function declarations------end---------*/

