/* Grid construction routine */

# include <stdio.h>
# include <stdlib.h>
# include <math.h>

# include "Global.h"
# include "Random.h"

// Both functions construct_grid() and construct_grid_list() are for grid construction; 
// only difference of the two functions is the data structure which is used in different parts of the algorithm.    
void construct_grid (population *pop)
{
	int i, j;
	double *ind_max, *ind_min;
	ind_max = (double *)malloc(nobj*sizeof(double));				// record the maximum value in each objective
	ind_min = (double *)malloc(nobj*sizeof(double));				// record the minimun value in each objective

	for (j=0; j<nobj; j++)
	{
		ind_min[j]=INF;
		ind_max[j]=-1*INF;
        for (i=0; i<popsize; i++)
		{
			if (pop->ind[i].obj[j]<ind_min[j])
			{
				ind_min[j] = pop->ind[i].obj[j];
			}
			if (pop->ind[i].obj[j]>ind_max[j])
			{
                ind_max[j] = pop->ind[i].obj[j];
			}				
		}
		grid_distance[j] = (ind_max[j]-ind_min[j])*(grid_div+1)/(grid_div*grid_div);               // hyperbox width in each objective
		grid_min[j] = ind_min[j]-(grid_distance[j]*grid_div-(ind_max[j]-ind_min[j]))/2;            // grid lower boundary in each objective
        grid_max[j] = ind_max[j]+(grid_distance[j]*grid_div-(ind_max[j]-ind_min[j]))/2;			   // grid upper boundary in each objective
	}

	free(ind_max);
	free(ind_min);
	return;
	
}

void construct_grid_list (population *pop, list *currentFront, int front_size)
{
	int j;
	list *temp;
	double *ind_max, *ind_min;
	ind_max = (double *)malloc(nobj*sizeof(double));				// record the maximum value in each objective
	ind_min = (double *)malloc(nobj*sizeof(double));				// record the minimun value in each objective
  
	for (j=0; j<nobj; j++)
	{
		ind_min[j]=INF;
		ind_max[j]=-1*INF;
		temp = currentFront->child;
		while (temp!=NULL)
		{
			if (pop->ind[temp->index].obj[j]<ind_min[j])
			{
				ind_min[j] = pop->ind[temp->index].obj[j];
			}
			if (pop->ind[temp->index].obj[j]>ind_max[j])
			{
				ind_max[j] = pop->ind[temp->index].obj[j];
			}
			temp = temp->child;
		}
		grid_distance[j]=(ind_max[j]-ind_min[j])*(grid_div+1)/(grid_div*grid_div);					// hyperbox width in each objective
		grid_min[j] = ind_min[j]-(grid_distance[j]*grid_div-(ind_max[j]-ind_min[j]))/2;				// grid lower boundary in each objective
        grid_max[j] = ind_max[j]+(grid_distance[j]*grid_div-(ind_max[j]-ind_min[j]))/2;				// grid upper boundary in each objective  
	}

	free(ind_max);
	free(ind_min);
	return;
}




