/* Routine for mergeing two populations */

# include <stdio.h>
# include <stdlib.h>
# include <math.h>

# include "Global.h"
# include "Random.h"

/* Routine to merge two populations into one */
void merge(population *pop1, population *pop2, population *pop3)
{
    int i, j;
    for (i=0; i<popsize; i++)
    {
        copy_ind (&(pop1->ind[i]), &(pop3->ind[i]));
    }
    for (i=0, j=popsize; i<popsize; i++, j++)
    {
        copy_ind (&(pop2->ind[i]), &(pop3->ind[j]));
    }
    return;
}

/* Routine to copy an individual 'ind1' into another individual 'ind2' */
void copy_ind (individual *ind1, individual *ind2)
{
    int i;

	ind2->constr_violation = ind1->constr_violation;
	for (i=0; i<nreal; i++)
		ind2->xreal[i] = ind1->xreal[i];
	
    for (i=0; i<nobj; i++)
		ind2->obj[i] = ind1->obj[i];
  
    if (ncon != 0)
    {
        for (i=0; i<ncon; i++)
			ind2->constr[i] = ind1->constr[i];
    }
    return;
}
