/* Test problem definitions */

# include <stdio.h>
# include <stdlib.h>
# include <math.h>
#include <string.h>

# include "Global.h"
# include "Random.h"

//	# define dtlz1  
	# define dtlz2    
//	# define dtlz3  
//	# define dtlz4 
//	# define dtlz5
//	# define dtlz6
//	# define dtlz7
//	# define dtlz5_I_M


/*  Test problem DTLZ1
	number of objectives = any
    number of real variables = nobj + 4
    number of constraints = 0
	variable range [0, 1] 
*/
#ifdef dtlz1
void test_problem (double *xreal, double *obj, double *constr)
{
	double sum=0;
	double gx;
	int i, j;

	for (i=nobj-1; i<nreal; i++)
	{
		sum += pow ((xreal[i]-0.5), 2.0) - cos(20*PI*(xreal[i]-0.5));
	}
	gx = 100 * (sum+nreal-nobj+1) + 1.0;
	sum = gx;
	for (j=0; j<nobj-1; j++)
	{
		sum = sum * xreal[j];
	}
	obj[0] = 0.5 * sum;

	for (i=1; i<nobj; i++)
	{
		sum = gx;
		for (j=0; j<nobj-1-i; j++)
		{
			sum = sum * xreal[j];
		}
		sum = sum * (1.0-xreal[nobj-1-i]);
		obj[i] = 0.5 * sum;
	}
	return;
}
#endif

/*  Test problem DTLZ2
	number of objectives = any
    number of real variables = nobj + 9
    number of constraints = 0
	variable range [0, 1] 
*/
#ifdef dtlz2 
void test_problem (double *xreal, double *obj, double *constr)
{
	double sum=0;
	double gx;
	int i, j;

	for (i=nobj-1; i<nreal; i++)
	{
		sum += pow ((xreal[i]-0.5), 2.0);
	}
	gx = 1.0 + sum;
	sum = gx;
	for (j=0; j<nobj-1; j++)
	{
		sum = sum * cos(xreal[j]*PI/2.0);
	}
	obj[0] = sum;

	for (i=1; i<nobj; i++)
	{
		sum = gx;
		for (j=0; j<nobj-1-i; j++)
		{
			sum = sum * cos(xreal[j]*PI/2.0);
		}
		sum = sum * sin(xreal[nobj-1-i]*PI/2.0);
		obj[i] = sum;
	}
	return;
}
#endif

/*  Test problem DTLZ3
	number of objectives = any
    number of real variables = nobj + 9
    number of constraints = 0
	variable range [0, 1] 
*/
#ifdef dtlz3
void test_problem (double *xreal, double *obj, double *constr)
{
	double sum=0;
	double gx;
	int i, j;

	for (i=nobj-1; i<nreal; i++)
	{
		sum += pow ((xreal[i]-0.5), 2.0) - cos(20*PI*(xreal[i]-0.5));
	}
	gx = 100 * (sum+nreal-nobj+1) + 1.0;
	sum = gx;
	for (j=0; j<nobj-1; j++)
	{
		sum = sum * cos(xreal[j]*PI/2.0);
	}
	obj[0] = sum;

	for (i=1; i<nobj; i++)
	{
		sum = gx;
		for (j=0; j<nobj-1-i; j++)
		{
			sum = sum * cos(xreal[j]*PI/2.0);
		}
		sum = sum * sin(xreal[nobj-1-i]*PI/2.0);
		obj[i] = sum;
	}
	return;

}
#endif


/*  Test problem DTLZ4
	number of objectives = any
    number of real variables = nobj + 9
    number of constraints = 0
	variable range [0, 1] 
*/
#ifdef dtlz4
void test_problem (double *_xreal, double *obj, double *constr)
{
	double sum=0;
	double gx;
	int i, j;
	double *xreal;
	xreal = (double *)malloc(nreal * sizeof(double));
	memcpy(xreal, _xreal, nreal * sizeof(double));

	for (i=nobj-1; i<nreal; i++)
	{
		sum += pow ((xreal[i]-0.5), 2.0);
	}
	for (i=0; i<nobj-1; i++)
	{
		xreal[i]=pow((float)xreal[i],(float)100);
	}
	gx = 1.0 + sum;
	sum = gx;
	for (j=0; j<nobj-1; j++)
	{
		sum = sum * cos(xreal[j]*PI/2.0);
	}
	obj[0] = sum;

	for (i=1; i<nobj; i++)
	{
		sum = gx;
		for (j=0; j<nobj-1-i; j++)
		{
			sum = sum * cos(xreal[j]*PI/2.0);
		}
		sum = sum * sin(xreal[nobj-1-i]*PI/2.0);
		obj[i] = sum;
	}
	free(xreal);
	return;
}
#endif

/*  Test problem DTLZ5
	number of objectives = any
    number of real variables = nobj + 9
    number of constraints = 0
	variable range [0, 1] 
*/
#ifdef dtlz5 
void test_problem (double *xreal, double *obj, double *constr)
{

	double sum=0;
	double gx;
	int i, j;
	double *x;
	x=(double*)malloc((nobj-1)*sizeof(double));

	for (i=nobj-1; i<nreal; i++)
	{
		sum += pow ((xreal[i]-0.5), 2.0);
	}
    for (i=1; i<nobj-1; i++)
	{
		x[i] = PI/(4*(1+sum))*(1+2*sum*xreal[i]);
	}
	gx = 1.0 + sum;
	sum = gx;
	for (j=1; j<nobj-1; j++)
	{
		sum = sum * cos(x[j]);
	}
	sum = sum * cos(xreal[0]*PI/2.0);
	obj[0] = sum;

	for (i=1; i<nobj; i++)
	{
		sum = gx;
		for (j=1; j<nobj-1-i; j++)
		{
			sum = sum * cos(x[j]);
		}
		if (i == nobj-1)
		{
			sum = sum * sin(xreal[0]*PI/2.0);
		}
		else 
		{
			sum = sum * sin(x[nobj-1-i]);
			sum = sum * cos(xreal[0]*PI/2.0);
		}		
		obj[i] = sum;
	}
	free (x);
	return;
}
#endif

/*  Test problem DTLZ6
	number of objectives = any
    number of real variables = nobj + 9
    number of constraints = 0
	variable range [0, 1] 
*/
#ifdef dtlz6 
void test_problem (double *xreal, double *obj, double *constr)
{
	
	double sum=0;
	double gx;
	int i, j;
	double *x;
	x=(double*)malloc((nobj-1)*sizeof(double));

	for (i=nobj-1; i<nreal; i++)
	{
		sum += pow ((xreal[i]), 0.1);
	}
    for (i=1; i<nobj-1; i++)
	{
		x[i] = PI/(4*(1+sum))*(1+2*sum*xreal[i]);
	}
	gx = 1.0 + sum;
	sum = gx;
	for (j=1; j<nobj-1; j++)
	{
		sum = sum * cos(x[j]);
	}
	sum = sum * cos(xreal[0]*PI/2.0);
	obj[0] = sum;

	for (i=1; i<nobj; i++)
	{
		sum = gx;
		for (j=1; j<nobj-1-i; j++)
		{
			sum = sum * cos(x[j]);
		}
		if (i == nobj-1)
		{
			sum = sum * sin(xreal[0]*PI/2.0);
		}
		else 
		{
			sum = sum * sin(x[nobj-1-i]);
			sum = sum * cos(xreal[0]*PI/2.0);
		}		
		obj[i] = sum;
	}
	free (x);
	return;
}
#endif

/*  Test problem DTLZ7
	number of objectives = any
    number of real variables = nobj + 19
    number of constraints = 0
	variable range [0, 1] 
*/
#ifdef dtlz7 
void test_problem (double *xreal, double *obj, double *constr)
{
	double sum=0, temp=0;
	double gx;
	int i, j;

	for (i=nobj-1; i<nreal; i++)
	{
		sum += xreal[i];
	}
	gx = 1.0 + 9.0*sum/(nreal-nobj+1.0);
	sum = gx;
    for (i=0; i<nobj-1; i++)
	{
		obj[i] = xreal[i];
	}
	for (i=0; i<nobj-1; i++)
	{
		temp += (obj[i]/(sum+1))*(1+sin(3*PI*obj[i]));
	}
	temp = nobj-temp;
	obj[nobj-1] = (sum+1)*temp;
	return;
}
#endif

/*  Test problem DTLZ5(I,M)
	number of objectives = any
    number of real variables = nobj + 9
    number of constraints = 0
	variable range [0, 1] 
*/
#ifdef dtlz5_I_M 
void test_problem (double *xreal, double *obj, double *constr)
{
	
	double sum=0;
	double gx;
	int i, j;
	double *x;
	x=(double*)malloc((nobj-1)*sizeof(double));

	for (i=nobj-1; i<nreal; i++)
	{
		sum += pow ((xreal[i]-0.5), 2.0);
	}
	
	for (i=0; i<I_number-1; i++)
	{
		x[i] = xreal[i]*PI/2.0;
	}
    for (i=I_number-1; i<nobj-1; i++)
	{
		x[i] = PI/(4*(1+sum))*(1+2*sum*xreal[i]);
	}
	gx = 1.0 + 100 * sum;
	
	sum = gx;
	for (j=0; j<nobj-1; j++)
	{
		sum = sum * cos(x[j]);
	}
	obj[0] = sum;

	for (i=1; i<nobj; i++)
	{
		sum = gx;
		for (j=0; j<nobj-1-i; j++)
		{
			sum = sum * cos(x[j]);
		}
		sum = sum * sin(x[nobj-1-i]);
		obj[i] = sum;
	}
	free (x);
	return;
}
#endif
