////==================================================================================================================
//  Implementation of MOEA/D Based on Two-phase (TP) and Niching (N) strategies for Continuous Multiobjective
//  Optimization Problems with Complicated Pareto Fronts (Debug version, oct. 2015)
//
//  See the details of MOEA/D-TPN and test problems in the following paper
//  Shouyong Jiang and Shengxiang Yang, "An improved  multiobjective optimization evolutionary algorithm based 
//	on decomposition for complex Pareto fronts," IEEE Transactions on Cybernetics, vol. 46, no. 2, pp.421-437, 2015.
//
//  The component functions of each test instance can be found in "objective.h".
//
//  The source code of MOEA/D-TPN was implemented by Shouyong Jiang, on the basis of the orignal MOEA/D-DE.
//
//  If you have any questions about the codes, please contact
//  math4neu@gmail.com and syang@dmu.ac.uk
////=================================================================================================================


#include "..\common\global.h"
#include "dmoeafunc.h"
#include <direct.h>
#include <time.h>

void execute();

void main()
{
	// The settings of test instances F1-F9
	char *ins[] = { "F1", "F2", "F3", "F4", "F5", "F6", "UF4", "CDTLZ2", "POL", "mF4" };
	int var[] = { 30, 30, 30, 30, 30, 30, 10, 10, 2, 30 };       // dimensionality of search space
	int obj[] = { 2, 2, 2, 3, 3, 3, 2, 3, 2, 3 };       // number of objective functions 

	// The settings of algorithms
	int pop[] = { 200, 200, 200, 300, 300, 300, 200, 300, 200, 300 };     // population size
	//int gen[] = { 500, 500, 500, 500, 500, 500, 500, 500, 500 };     // number of generations 



	// the parameter setting of test instance

	for (int i = 0; i < 10; i++){
		nvar = var[i];
		nobj = obj[i];
		pops = pop[i];
		for (int k = 0; k < nvar; k++)
		{
			lowBound[k] = lb, uppBound[k] = ub;
		}

		strcpy_s(strTestInstance, ins[i]);
		execute();
	}
}

void execute()
{
	std::fstream fout;
	char filename[1024];

	// set path for output
	string path = "data";
	_mkdir(path.c_str());

	char parName1[100];
	sprintf_s(parName1, path.append("\\%s").c_str(), strTestInstance);
	if (_mkdir(parName1))
		cout << "this file has already existed.";
	char timefile[100];

	clock_t start, finish;
	double duration;
	for (int run = 1; run <= max_run; run++)
	{
		sprintf_s(parName, "%s\\run_%d", parName1, run);
		if (_mkdir(parName))
			cout << "this file has already existed.";

		start = clock();
		CMOEAD  MOEAD;
		MOEAD.execute(run, "_TCHE1", "_DE");

		finish = clock();
		duration = (double)(finish - start) / CLOCKS_PER_SEC;
		sprintf_s(timefile, "%s\\time.txt", parName);
		std::fstream fout1;
		fout1.open(timefile, std::ios::out);
		fout1 << duration << endl;
		fout1.close();


	}
}