#ifndef __COMMON_H_
#define __COMMON_H_

#include "global.h"
#include "mylib.h"

template <class T>
int dominance(T &y_obj1,T &y_obj2)
{// returns 0: nondominate; 1: domiante; -1: dominated 
	int dm=0,dl=0,de=0;
	for (int i=0; i<nobj;i++)
	{
		if (y_obj1[i]>y_obj2[i])
			dm+=1;
		else
			if (y_obj1[i]<y_obj2[i])
				dl+=1;
			else
				de+=1;
		if (dm>0 && dl>0)
			break;
	}
	if (dm==nobj)
		return -1;
	else if (dl == nobj)
		return 1;
	else 
		return 0;

}

template <class T>
double fitnessfunction(vector <double> &y_obj, vector <double> &namda, T* ind_arr)
{
    // Chebycheff Scalarizing Function
	double fitness = 0;
	
	if(!strcmp(strFunctionType,"_TCHE1"))
	{
		double max_fun = -1.0e+30;
		double min_fun = 1.0e+30;

		double feval = 1, diff;
		for(int n=0; n<nobj; n++)
		{
			
			//worstpoint[n] = 1; // if the nardirpoint is known ahead.

			if (otype)
			{

				diff = (worstpoint[n] - y_obj[n]) / (worstpoint[n] - idealpoint[n]);
			}
			else
			{
				diff = fabs(y_obj[n] - idealpoint[n]) / (worstpoint[n] - idealpoint[n]);
			}

			if (namda[n] ==0)
				feval = diff / EPS;
			else
				feval = diff / namda[n];

			if (otype)
			{
				if(feval<min_fun) min_fun = feval;

			}
			else
			{
				if(feval>max_fun) max_fun = feval;
				
			}


		}
		if (otype)
			fitness = min_fun;
		else
			fitness = max_fun;

	}

	if(!strcmp(strFunctionType,"_TCHE2"))
	{
		// reference point in the CHIM
		double max_fun = -1.0e+30;
		for(int n=0; n<nobj; n++)
		{
			double diff = (y_obj[n] - idealpoint[n])/scale[n];
			double feval;
			if(namda[n]==0) 
				feval = 0.0001*diff;
			else
			    feval = diff*namda[n];
			if(feval>max_fun) max_fun = feval;

		}
		fitness = max_fun;
	}



	// CHIM + Tchebycheff
	// CHIM is not available in 3 objectives
	if(!strcmp(strFunctionType,"_NBI1")){

		// quasi normal direction
		vector <double> norm;
		for(int i=0; i<nobj; i++)
		{
		   norm.push_back(0.0);
		   for(int j=0; j<nobj; j++){
			   norm[i]+= -ind_arr[j].y_obj[i];
		   }
		}

		// normalization
		double nd = norm_vector(norm);
		for(int i=0; i<nobj; i++)
			norm[i] = norm[i]/nd;


		// reference point in the CHIM
		vector <double> base;
		for(int i=0; i<nobj; i++)
		{
			double tp2 = 0;
			for(int j=0; j<nobj; j++)
				tp2+= ind_arr[j].y_obj[i]*namda[j];
			base.push_back(tp2);
		}

		// Tchebycheff function
		double max_fun = -1.0e+30;
		for(int n=0; n<nobj; n++)
		{
			double diff  = y_obj[n] - base[n];
			double feval = -diff*norm[n];
			if(feval>max_fun) max_fun = feval;

		}	
		fitness = max_fun;
	}

	//* Boundary intersection approach
	//* reference point is chosen as the ideal point
	//* the direction is independent of CHIM
	if(!strcmp(strFunctionType,"_NBI2"))
	{

		double nd = norm_vector(namda);
		for(int i=0; i<nobj; i++)
			namda[i] = namda[i]/nd;

	    // penalty method 
	    // temporary vectors NBI method
		vector <double> realA(nobj);
		vector <double> realB(nobj);

		// difference beween current point and reference point
		for(int n=0; n<nobj; n++)
			realA[n] = (y_obj[n] - idealpoint[n]);

		// distance along the search direction norm
		double d1 = fabs(prod_vector(realA,namda));
		//double d1 = prod_vector(realA,norm);

		// distance to the search direction norm
		for(int n=0; n<nobj; n++)
			realB[n] = (y_obj[n] - (idealpoint[n] + d1*namda[n]));
		double d2 = norm_vector(realB);

		fitness =  (d1 + 5*d2);

		//t2 = clock();
	    //total_sec+=(t2 - t1);
	}

	// NBI method
	if(!strcmp(strFunctionType,"_NBI3")){

		// quasi normal direction
		vector <double> norm;
		for(int i=0; i<nobj; i++)
		{
		   norm.push_back(0.0);
		   for(int j=0; j<nobj; j++){
			   norm[i]+= -ind_arr[j].y_obj[i];
		   }
		}

		// normalization
		double nd = norm_vector(norm);
		for(int i=0; i<nobj; i++){
			norm[i] = norm[i]/nd;
		}


		// reference point in the CHIM
		vector <double> base;
		for(int i=0; i<nobj; i++)
		{
			double tp2 = 0;
			for(int j=0; j<nobj; j++)
				tp2+= ind_arr[j].y_obj[i]*namda[j];
			base.push_back(tp2);
		}

	    // penalty method 
	    // temporary vectors NBI method
		vector <double> realA;
		vector <double> realB;

		// difference beween current point and reference point
		for(int n=0; n<nobj; n++)
			realA.push_back(y_obj[n] - base[n]);

		// distance along the search direction norm
		double d1 = prod_vector(realA,norm);

		// distance to the search direction norm
		for(int n=0; n<nobj; n++)
			realB.push_back(y_obj[n] - (base[n] + d1*norm[n]));
		double d2 = norm_vector(realB);

		fitness =  -d1 + 2*d2;
	}


	return fitness;
}

void random_permutation(int *perm, int size)
{
	int *index = new int[size];
	bool *flag = new bool[size];
    for(int n=0; n<size; n++)  {
		index[n] = n;
		flag[n]  = true;
	}

	int num = 0;
	while(num<size){
	    int start = int(size*rnd_uni(&rnd_uni_init));
		while(1){
			if(flag[start]){
				perm[num] = index[start];
				flag[start] = false;
				num++;
				break;
			}
			if(start==(size-1))
				start = 0;
			else
			    start++;
		}
	}

	delete [] index;
	delete [] flag;

}

#endif