#ifndef __OBJECTIVE_H_
#define __OBJECTIVE_H_

#include "global.h"

// control the PF shape
void objective(vector<double> &x_var, vector<double> &y_obj)
{

	if(!strcmp(strTestInstance,"F1"))
	{
		double g = 0, t;
		for (int n = 1; n<nvar; n++)
		{
			t = x_var[n] - sin(0.5*pi*x_var[n]);
			g += 1 + t*t - cos(2 * pi*t);
		}
		g = 1 + 2 * sin(0.5*pi*x_var[0])*g;
		y_obj[0] = g* x_var[0];
		y_obj[1] = g*pow(1 - pow(x_var[0], 0.5), 5);
		return;
	}


	if(!strcmp(strTestInstance,"F2"))
	{
		double g = 0,t;
		for(int n=1;n<nvar;n++)
		{
			t=x_var[n]-sin(0.5*pi*x_var[n]);
			g+=1+t*t-cos(2*pi*t);
		}
		g=1+2*sin(pi*x_var[0])*g;
		y_obj[0] = g*(1-x_var[0]);
		y_obj[1] = 0.5*g*(x_var[0]+pow(x_var[0],0.5)*pow(cos(4*pi*x_var[0]),2));
	}

	if (!strcmp(strTestInstance, "F3"))
	{
		double g = 0, t;
		for (int n = 1; n<nvar; n++)
		{
			t = x_var[n] - sin(0.5*pi*x_var[n]);
			g += 1 + t*t - cos(2 * pi*t);

		}
		g = 1 + 2 * sin(pi*x_var[0])*g;
		y_obj[0] = g*(x_var[0]);
		y_obj[1] = 0.5*g*(1-pow(x_var[0],0.1)+pow(1-pow(x_var[0],0.5),2)*pow(cos(3*pi*x_var[0]),2));
	}

	if (!strcmp(strTestInstance, "F4"))
	{
		double g = 0, t, x1, x2, x3;
		for (int n = 3; n < nvar; n++)
		{
			t = 3 * x_var[n] + 1;

			g += (t-2)*(t-2);
		}
		g += 1;
		x1 = 3 * x_var[0] + 1;
		x2 = 3 * x_var[1] + 1;
		x3 = 3 * x_var[2] + 1;
		y_obj[0] = g*x1 / pow(x2*x3, 0.5);
		y_obj[1] = g*x2 / pow(x1*x3, 0.5);
		y_obj[2] = g*x3 / pow(x1*x2, 0.5);
	}

	if (!strcmp(strTestInstance, "F5"))
	{
		double g = 0;
		for (int n = 2; n < nvar; n++)
		{
			g += pow(x_var[n] - 0.5, 2.0);
		}
		g += 1;

		y_obj[0] = g*(1-x_var[0])*x_var[1];
		y_obj[1] = g*x_var[0]*(1-x_var[1]);
		y_obj[2] = g*pow(1-x_var[0]-x_var[1]+2*x_var[0]*x_var[1],6.0);
	}


	if (!strcmp(strTestInstance, "F6"))
	{
		double g = 0;
		for (int n = 2; n<nvar; n++)
		{
			g += 1 + pow(x_var[n], 2.0) - cos(2 * pi*x_var[n]);
		}
		g =g/nvar; // this the correct one (there was a typo error in the corresponding paper about the mathematical description of this test problem)
		y_obj[0] = cos(x_var[0] * pi / 2)*cos(x_var[1] * pi / 2);
		y_obj[1] = cos(x_var[0] * pi / 2)*sin(x_var[1] * pi / 2);

		y_obj[0] = pow(y_obj[0], 4.0);
		y_obj[1] = pow(y_obj[1], 4.0);
		y_obj[2] = pow((1+g)/(1+pow(cos(0.5*pi*x_var[0]),2.0)), 1.0/(1+g));
	}

	if (!strcmp(strTestInstance, "UF4"))
	{
		unsigned int j, count1, count2;
		double sum1, sum2, yj, hj;

		sum1 = sum2 = 0.0;
		count1 = count2 = 0;
		for (j = 1; j <nvar; j++)
		{
			double x = 4 * x_var[j] - 2.0;
			yj = x - sin(6.0*pi*x_var[0] + j*pi / (nvar - 1));
			hj = fabs(yj) / (1.0 + exp(2.0*fabs(yj)));
			if (j % 2 == 1)
			{
				sum2 += hj;
				count2++;
			}
			else
			{
				sum1 += hj;
				count1++;
			}
		}
		y_obj[0] = x_var[0] + 2.0*sum1 / (double)count1;
		y_obj[1] = 1.0 - x_var[0] * x_var[0] + 2.0*sum2 / (double)count2;
	}

	if (!strcmp(strTestInstance, "CDTLZ2"))
	{
		double g = 0, t;
		for (int n = 2; n<nvar; n++)
		{
			double x = x_var[n] - 0.5;

			g = g + x*x;

		}
		y_obj[0] = cos(x_var[0] * pi / 2)*cos(x_var[1] * pi / 2);
		y_obj[1] = cos(x_var[0] * pi / 2)*sin(x_var[1] * pi / 2);
		y_obj[2] = sin(x_var[0] * pi / 2);

		y_obj[0] = (1 + g)*pow(y_obj[0], 4.0);
		y_obj[1] = (1 + g)*pow(y_obj[1], 4.0);
		y_obj[2] = (1 + g)*pow(y_obj[2], 2.0);
	}


	if (!strcmp(strTestInstance, "mF4"))
	{
		double g = 0, t, x1, x2, x3;
		for (int n = 3; n < nvar; n++)
		{
			t =9 * x_var[n] + 1;

			g += (t - 2)*(t - 2);
		}
		g += 1;
		x1 = 9 * x_var[0] + 1;
		x2 = 9 * x_var[1] + 1;
		x3 = 9 * x_var[2] + 1;
		y_obj[0] = g*x1 / pow(x2*x3, 0.5);
		y_obj[1] = g*x2 / pow(x1*x3, 0.5);
		y_obj[2] = g*x3 / pow(x1*x2, 0.5);
	}

	if (!strcmp(strTestInstance, "POL"))
	{
		double x1, x2, A1, A2, B1, B2;
		x1 = pi*(2 * x_var[0] - 1.0);
		x2 = pi*(2 * x_var[1] - 1.0);

		A1 = 0.5*sin(1.0) - 2.0*cos(1.0) + sin(2.0) - 1.5*cos(2.0);
		A2 = 1.5*sin(1.0) - cos(1.0) + 2.0*sin(2.0) - 0.5*cos(2.0);
		B1 = 0.5*sin(x1) - 2 * cos(x1) + sin(x2) - 1.5*cos(x2);
		B2 = 1.5*sin(x1) - cos(x1) + 2 * sin(x2) - 0.5*cos(x2);

		y_obj[0] = 1.0 + pow(A1 - B1, 2.0) + pow(A2 - B2, 2.0);
		y_obj[1] = pow(x1 + 3.0, 2.0) + pow(x2 + 1.0, 2.0);
	}


	if(!strcmp(strTestInstance,"ZDT3"))
	{
		double g = 0;
		for(int n=1;n<nvar;n++)
			g+= x_var[n];
		g = 1 + 9*g/(nvar-1);

		y_obj[0] = x_var[0];
		y_obj[1] = g*(1 - sqrt(x_var[0]/g) - x_var[0]*sin(10*pi*x_var[0])/g);
	}


	if(!strcmp(strTestInstance,"ZDT4"))
	{
		double g = 0;
		for(int n=1;n<nvar;n++)
		{
			double x = 10*(x_var[n] - 0.5);
			g+= x*x - 10*cos(4*pi*x);
		}
		g = 1 + 10*(nvar-1) + g;
		y_obj[0] = x_var[0];
		y_obj[1] = g*(1- sqrt(y_obj[0]/g));
	}

	if(!strcmp(strTestInstance,"ZDT6"))
	{
		double g = 0;
		for(int n=1;n<nvar;n++)
			g+= x_var[n]/(nvar - 1);
		g = 1 + 9*pow(g,0.25) ;

		y_obj[0] = 1 - exp(-4*x_var[0])*pow(sin(6*pi*x_var[0]),6);
		y_obj[1] = g*(1- pow(y_obj[0]/g,2));
	}

	if(!strcmp(strTestInstance,"UF3"))
	{
		double g1 = 0, g2=0;
		double prod1=1,prod2=1;
		double x;
		int n1=0, n2=0;
		for(int n=1;n<nvar;n++)
		{
			x=x_var[n]-pow(x_var[0],0.5*(1.0+3.0*(n-1)/(nvar-2)));
			if (n%2==1)
			{
				g1+=4*x*x;
				prod1*=cos(20.0*pi*x/pow(n,0.5));
				n1++;
			}
			else
			{
				g2+=4*x*x;
				prod2*=cos(20.0*pi*x/pow(n,0.5));
				n2++;
			}
		}
		g1=2.0*(g1-2*prod1+2)/n1;
		g2=2.0*(g2-2*prod2+2)/n2;

		y_obj[0] =x_var[0]+g1;
		y_obj[1] = 1-pow(x_var[0],0.5)+g2;
	}
	

	if(!strcmp(strTestInstance,"UF10"))
	{
		unsigned int j, count1, count2, count3;
		double sum1, sum2, sum3, yj, hj;
		
		sum1   = sum2   = sum3   = 0.0;
		count1 = count2 = count3 = 0;
		for(j = 2; j < nvar; j++) 
		{
			yj = x_var[j] - 2.0*x_var[1]*sin(2.0*pi*x_var[0]+j*pi/(nvar-1));
			hj = 4.0*yj*yj - cos(8.0*pi*yj) + 1.0;
			if(j % 3 == 2) 
			{
				sum1  += hj;
				count1++;
			} 
			else if(j % 3 == 0) 
			{
				sum2  += hj;
				count2++;
			}
			else
			{
				sum3  += hj;
				count3++;
			}
		}
		y_obj[0] = cos(0.5*pi*x_var[0])*cos(0.5*pi*x_var[1]) + 2.0*sum1 / (double)count1;
		y_obj[1] = cos(0.5*pi*x_var[0])*sin(0.5*pi*x_var[1]) + 2.0*sum2 / (double)count2;
		y_obj[2] = sin(0.5*pi*x_var[0])                  + 2.0*sum3 / (double)count3;
	}
	// OKA 1
	if(!strcmp(strTestInstance,"OKA-1"))
	{
		double x1 = 2*pi*(x_var[0] - 0.5);
		double x2 = (x_var[1] - 0.5)*10;
		y_obj[0] = x1;
		y_obj[1] = pi - x1 + fabs(x2 - 5*cos(x1));
	}

	if(!strcmp(strTestInstance,"OKA-2"))
	{
		double x1 = 2*pow(pi,3)*(x_var[0] - 0.5);
		double x2 = (x_var[1] - 0.5)*10;
		double eta;
		if(x1>=0) eta = pow(x1,1.0/3);
		else      eta = -pow(-x1,1.0/3);

		y_obj[0] = eta;
		y_obj[1] = pi - eta + fabs(x2 - 5*cos(x1));
	}

}

#endif