#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "Global.h"
#include "Random.h"

/* Function to associate population members with reference directions */
void assoc_Reference(population *pop, int size, reference *refset) {
    int i, j;
    double **theta;
    int *idt;
    int q;

    theta = (double**) malloc(size * sizeof (double));
    idt = (int*) malloc(nref * sizeof (int));

    for (i = 0; i < size; i++)
        theta[i] = (double*) malloc(nref * sizeof (double));

    for (i = 0; i < nref; i++)
        refset->poin[i].rdno = 0;


    for (i = 0; i < size; i++) {

        for (j = 0; j < nref; j++) {
            theta[i][j] = angle(pop->ind[i].obj, refset->poin[j].obj);
            idt[j] = j;
        }
        minfastsort(theta[i], idt, nref, 1);
        pop->ind[i].rin = idt[0];
        q = refset->poin[idt[0]].rdno;
        refset->poin[idt[0]].rdarr[q] = i;
        refset->poin[idt[0]].rdno += 1;
        pop->ind[i].ang = theta[i][0];
    }


    for (i = 0; i < size; i++)
        free(theta[i]);
    free(theta);
    free(idt);

    return;
}