/* distance and angle calculation routines */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "Global.h"
#include "Random.h"

/* Function to calculate Euclidean distance between two individuals */
double Euclidean_Distance(individual *ind1, individual *ind2) {
    int i;
    double d = 0.0;

    for (i = 0; i < nobj; i++) {
        d += (ind2->obj[i] - ind1->obj[i]) * (ind2->obj[i] - ind1->obj[i]);
    }
    return (sqrt(d));
}

/* Function to calculate Euclidean distance between two vectors */
double dist_vector(double *vec1, double *vec2, int dim) {
    double sum = 0;
    int n;
    for (n = 0; n < dim; n++)
        sum += (vec1[n] - vec2[n])*(vec1[n] - vec2[n]);
    return sqrt(sum);
}

/* Function to calculate the norm of a vector */
double norm_vector(double *vec, int dim) {
    double sum = 0;
    int i;
    for (i = 0; i < dim; i++)
        sum = sum + vec[i] * vec[i]; //normalization
    return sqrt(sum);
}

/* Function to calculate the acute angle between a objective vector and a reference direction */
double angle(double *vect1, double *vect2) {
    double prod = 0;
    double norm_v1, norm_v2;
    double theta;
    int i;
    double v1[100]; // speeup optimization instead of pointer array.
    //v1=(double*)malloc(nobj*sizeof(double));
    for (i = 0; i < nobj; i++) {
        v1[i] = (vect1[i] - idealpoint[i]) / (intercept[i] - idealpoint[i]); //normalization
        prod += v1[i] * vect2[i];
    }

    norm_v1 = norm_vector(v1, nobj);
    norm_v2 = norm_vector(vect2, nobj);

    theta = prod / (norm_v1 * norm_v2);
    if (fabs(theta) >= 1.0)
        theta = 0;
    else
        theta = acosf(prod / (norm_v1 * norm_v2));

    //free(v1);
    return theta > 0 ? theta : fabs(theta);

}

/* Function to calculate the acute angle between two vectors */
double comangle(double *vect1, double *vect2) {
    double prod = 0;
    double norm_v1, norm_v2;
    double theta;
    int i;

    for (i = 0; i < nobj; i++) {
        prod += vect1[i] * vect2[i];
    }

    norm_v1 = norm_vector(vect1, nobj);
    norm_v2 = norm_vector(vect2, nobj);
    theta = prod / (norm_v1 * norm_v2);
    if (fabs(theta) >= 1.0)
        theta = 0;
    else
        theta = acosf(prod / (norm_v1 * norm_v2));
    return theta > 0 ? theta : fabs(theta);
}
