/* environmental selection routines */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "Global.h"
#include "Random.h"

/* Routine to perform environmental selection */
void environmental_selection(population *mixed_set, population *archive_set, reference *refset) {
    int i, j, t, id, psize, tmpsize, rand;
    int *record, *tmpmember;
    double min;
    int mark, temp;

    tmpmember = (int*) malloc((popsize + archsize) * sizeof (int));
    record = (int *) malloc((popsize + archsize) * sizeof (int));
    for (i = 0; i < popsize + archsize; i++) record[i] = 1;

    // allocate an individual to each reference direction
    psize = 0;
    tmpsize = 0;
    while (psize < archsize) {
        tmpsize = 0;
        for (j = 0; j < nref; j++) {
            min = 1.0e10;
            id = -1;
            for (i = 0; i < refset->poin[j].rdno; i++) {
                t = refset->poin[j].rdarr[i];
                if (record[t]) {
                    if (min > mixed_set->ind[t].fitness) {
                        min = mixed_set->ind[t].fitness;
                        id = t;
                    }
                }
            }
            if (id >= 0) {
                tmpmember[tmpsize++] = id;
            }
        }

        //diversity first convergence second
        if (psize + tmpsize <= archsize) {
            for (i = 0; i < tmpsize; i++) {
                if (gen < ngen || (mixed_set->ind[ tmpmember[i] ].fitness < 1.0 && (gen == ngen))) {
                    copy_ind(&(mixed_set->ind[ tmpmember[i] ]), &(archive_set->ind[psize++]));
                    record[ tmpmember[i] ] = 0;
                }
            }
            if (psize == archsize) break;
        } else {
            for (i = 0; i < tmpsize; i++) {

                min = mixed_set->ind[tmpmember[i]].fitness;
                mark = i;
                for (j = i + 1; j < tmpsize; j++) {
                    if (min > mixed_set->ind[tmpmember[j]].fitness) {
                        mark = j;
                        min = mixed_set->ind[tmpmember[j]].fitness;
                    }
                }
                temp = tmpmember[i];
                tmpmember[i] = tmpmember[mark];
                tmpmember[mark] = temp;

                copy_ind(&(mixed_set->ind[tmpmember[i]]), &(archive_set->ind[psize++]));
                if (psize == archsize) break;
            }
        }
    }

    free(tmpmember);
    free(record);

    return;
}

