/* Routine for evaluating population members  */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "Global.h"
#include "Random.h"
#include "Problem.h"

/* Routine to evaluate objective function values and constraints for a population */
void evaluate_pop(population *pop, int size) {
    int i;
    for (i = 0; i < size; i++) {
        evaluate_ind(&(pop->ind[i]));
    }
    return;
}

/* Routine to evaluate objective function values and constraints for an individual */
void evaluate_ind(individual *ind) {
    int j;

    test_problem(ind->xreal, ind->obj, ind->constr);

    /*----- Update idealpoint------start----------*/
    for (j = 0; j < nobj; j++)
        if (idealpoint[j] > ind->obj[j])
            idealpoint[j] = ind->obj[j];
    /*----- Update idealpoint------start----------*/


    if (ncon == 0) {
        ind->constr_violation = 0.0;
    } else {
        ind->constr_violation = 0.0;
        for (j = 0; j < ncon; j++) {
            if (ind->constr[j] < 0.0) {
                ind->constr_violation += ind->constr[j];
            }
        }
    }
    currenteval++;
    return;
}
