/* fitness assignment routine */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "Global.h"
#include "Random.h"

/* Function to assign fitness to a population */
void assign_fitness(population *pop, int size, reference *refset) {
    int i, j, k, jd = 0, kd = 0;
    int *strength, *rawfitness, *gstrength, *grawfitness;
    double **distance;
    double *D;
    double max, w, temp;
    int Kmin;
    int *rm;

    strength = (int*) malloc(size * sizeof (int));
    rawfitness = (int*) malloc(size * sizeof (int));

    gstrength = (int*) malloc(size * sizeof (int));
    grawfitness = (int*) malloc(size * sizeof (int));

    D = (double*) malloc(size * sizeof (double));
    distance = (double**) malloc(size * sizeof (double));


    rm = (int *) malloc(nref * sizeof (int)); //individuals closest to a certain reference direction. 

    for (i = 0; i < nref; i++)
        rm[i] = 0;

    for (i = 0; i < size; i++) {
        distance[i] = (double*) malloc(size * sizeof (double));
    }

    for (i = 0; i < size; i++) {
        strength[i] = 0;
        rawfitness[i] = 0;
        gstrength[i] = 0;
        grawfitness[i] = 0;
    }


    /*-------calculate the strength value------start---------*/

    for (i = 0; i < size; i++) {
        for (j = 0; j < size; j++) {
            if (check_dominance(&(pop->ind[i]), &(pop->ind[j])) == 1)
                gstrength[i] += 1;
        }
    }
    /*-------calculate the strength value------end---------*/

    /*-------calculate the global raw fitness------start---------*/

    for (i = 0; i < size; i++) {
        for (j = 0; j < size; j++) {
            if (check_dominance(&(pop->ind[i]), &(pop->ind[j])) == -1)
                grawfitness[i] += gstrength[j];
        }
    }

    /*-------calculate the global raw fitness------end---------*/

    /*----------calculate intercepts-------end----------------*/
    for (i = 0; i < nobj; i++)
        intercept[i] = -1.0e10;

    for (i = 0; i < size; i++) {
        if (grawfitness[i] < 1) {
            for (k = 0; k < nobj; k++)
                if (intercept[k] < pop->ind[i].obj[k])
                    intercept[k] = pop->ind[i].obj[k];
        }
    }
    /*----------calculate intercepts-------end----------------*/


    assoc_Reference(pop, size, refset); //member association

    /*--------calculate local fitness-------start-------------*/

    for (i = 0; i < nref; i++) {
        for (j = 0; j < refset->poin[i].rdno; j++) {
            for (k = 0; k < refset->poin[i].rdno; k++) {
                jd = refset->poin[i].rdarr[j];
                kd = refset->poin[i].rdarr[k];

                if (check_dominance(&(pop->ind[jd]), &(pop->ind[kd])) == 1)
                    strength[jd] += 1;
            }
        }
        for (j = 0; j < refset->poin[i].rdno; j++) {
            for (k = 0; k < refset->poin[i].rdno; k++) {
                jd = refset->poin[i].rdarr[j];
                kd = refset->poin[i].rdarr[k];

                if (check_dominance(&(pop->ind[jd]), &(pop->ind[kd])) == -1)
                    rawfitness[jd] += strength[kd];
            }
        }
    }
    /*--------calculate local fitness-------end---------------*/

    /*----------individual fitness assignment----start-------*/
    for (i = 0; i < size; i++) {
        D[i] = pop->ind[i].ang / (delta + pop->ind[i].ang);
        k = pop->ind[i].rin;

        if ((refset->poin[k].rdno == 1)&&(gen < ngen))
            pop->ind[i].fitness = 1.0 * rawfitness[i] + D[i];
        else
            pop->ind[i].fitness = 1.0 * grawfitness[i] + 1.0 * rawfitness[i] + D[i];
    }
    /*----------individual fitness assignment----end-------*/


    free(strength);
    free(rawfitness);
    free(gstrength);
    free(grawfitness);
    free(D);
    for (i = 0; i < size; i++)
        free(distance[i]);
    free(distance);

    free(rm);
    return;
}

