#pragma once
//#ifdef _GLOBAL_H
//#define _GLOBAL_H
/* This file contains the variable and function declarations */

# define INF 1.0e14
# define EPS 1.0e-14
# define E  2.71828182845905
# define PI 3.141592653589793238462643383279502884197169399375105

#define maxpop 500; // popsize & archsize <maxpop.

/*-------global variables------start---------*/
typedef struct
{
    double *xreal;              // individual's variable value 
    double *obj;				// individual's objective value 
    double *constr;				// individual's constraint
	double constr_violation;	// individual's constraint violation degree
	
	double fitness;				// individual's fitness
	int    rin;                 //individual's reference direction
	double ang;
} individual;

typedef struct
{
    individual *ind;
} population;

typedef struct
{
	double *obj;
	int    *table;
	int    *rdarr;  /*record of array of individual numbers at a particular reference direction */        
	int    rdno;   /*record of no. of individuals at a particular reference direction*/
} point;
typedef struct
{
	point * poin;
} reference;
extern char strTestInstance[256];

extern int nummerge;		// number of individuals after merging	
extern int nreal;			// number of decision variables
extern int nobj;			// number of objectives
extern int ncon;			// number of constraints		
extern int popsize;			// population size		
extern int archsize;		// archive size		
extern double pcross_real;	// crossover probability	
extern double pmut_real;	// mutation probability				
extern double eta_c;		// crossover distribution index		
extern double eta_m;		// mutation distribution index			
extern int nrun;			// number of independent runs		
extern int neval;			// maximum number of function evaluations	
extern int currenteval;		// current number of function evaluations			
extern int ngen;			// maximum number of generations			
extern int gen;				// current number of generations			
                            
extern double *min_realvar;	// lower bounds of decision vector	
extern double *max_realvar;	// upper bounds of decision vector	
extern double *intercept; 	// for normalization of objectives		
extern double *idealpoint;	// ideal point approximating utopia point		

extern int refMode;         // method to generate a reference set
                            // refMode=0: k-layer; 
                            // refMode=1: standard simplex-lattice-design; 
                            // refMode=2: 2-layered design;

extern int repMode;     // method to reproduce population
                        // repMode=0: SBX + PM
                        // repMode=1: LLX+LLM (Liu and Li's method)

extern int klayer;
extern int nref;
extern int niche;
extern double delta;

extern int vk, vl; //number of position-variables and distance-varaibles for WFG.
/*-------global variables------end---------*/



/*-------global function declarations------start---------*/
void allocate_memory_pop(population *pop, int size);
void allocate_memory_ind(individual *ind);
void allocate_memory_ref(reference *ref, int size);
void allocate_memory_poin(point *poin);

void deallocate_memory_pop (population *pop, int size);
void deallocate_memory_ind (individual *ind);
void deallocate_memory_ref(reference *ref, int size);
void deallocate_memory_poin(point *poin);

void evaluate_pop (population *pop, int size);
void evaluate_ind (individual *ind);
void test_problem (double *xreal, double *obj, double *constr);

void initialize_pop (population *pop, int size);
void initialize_ind (individual *ind);
void initialize_nref();

// SBX crossover
void crossover (individual *parent1, individual *parent2, individual *child1, individual *child2);


// Liu and Li's genetic operators in "The multiobjective evolutionary algorithm based on determined weight and sub regional search"
void LLcrossover (individual *parent1, individual *parent2, individual *child); 
void LLmutation  (individual *child);

void mutation_pop (population *pop);
void real_mutate_ind (individual *ind);

int check_dominance (individual *a, individual *b);
int check_repeat (individual *a, individual *b);
void merge(population *pop1, population *pop2, population *pop3, int size1, int size2);

void assign_fitness(population *pop,int size, reference *refset);
void environmental_selection (population *mixed_set, population *archive_set, reference *refset);

void mating_selection (population *archive_set, population *pop_set);
void copy_ind (individual *ind1, individual *ind2);

double findKmin (double *a, int Kmin, int size);
int tournamentK (int id, population *pop, int K);

double Euclidean_Distance(individual *ind1,individual *ind2);
double dist_vector(double *vec1, double *vec2, int dim);
double norm_vector(double *vec, int dim);

void q_sort_distance (double *a, int left, int right);
void q_sort_distance_index (double *a, int *b, int left, int right);
void minfastsort(double *x, int *idx, int n, int m);

void alloc_ReferDirect(reference *ref); // assign search directions.
void generate_referpoint(int *p, int unit, int *more);
void alloc_ReferNeighbor(reference *ref); // assign neighborhood for each direction.
void assoc_Reference(population *pop,int size, reference *refset);
double angle(double *vect1,double *vect2);
double comangle(double *vect1,double *vect2);

void KLD(reference *ref, int unit);			
int SSLD(reference *ref, int unit, int k);			
void TSLD(reference *ref, int unit1, int unit2);		
int nchoosek(int n, int k);
int refsizeK();

void report_objective(population *pop, int size, FILE *fpt);
void report_variable (population *pop, int size, FILE *fpt);
/*-------global function declarations------end---------*/
//#endif