/* individual relation checking routines */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "Global.h"
#include "Random.h"

// Compare Pareto dominance relation between individuals a and b
// it will return the following values
// 1 if a dominates b
// -1 if b dominates a
// 0 if both a and b are non-dominated 

int check_dominance(individual *a, individual *b) {
    int i;
    int flag1;
    int flag2;
    flag1 = 0;
    flag2 = 0;

    for (i = 0; i < nobj; i++) {
        if (a->obj[i] < b->obj[i] - 1.0e-10) // filter poor boundary points.
        {
            flag1 = 1;
        } else {
            if (a->obj[i] > b->obj[i] + 1.0e-10) {
                flag2 = 1;
            }
        }
		if (flag1 && flag2) return (0);
    }
    if (flag1 == 1 && flag2 == 0) {
        return (1);
    } else {
        if (flag1 == 0 && flag2 == 1) {
            return (-1);
        } else {
            return (0);
        }
    }
}

// Check if two individuals are repeating in the objective space
// it will return the following values
// 1 if a and b are distinct
// 0 if a is the same as b

int check_repeat(individual *a, individual *b) {
    int i;
    for (i = 0; i < nobj; i++) {
        if (a->obj[i] != b->obj[i])
            return (1);
    }
    return (0);
}