/* Data initializtion routines */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "Global.h"
#include "Random.h"

/* Function to initialize a population randomly */
void initialize_pop(population *pop, int size) {
    int i;
    for (i = 0; i < size; i++) {
        initialize_ind(&(pop->ind[i]));
    }
    return;
}

/* Function to initialize an individual randomly */
void initialize_ind(individual *ind) {
    int j;
    for (j = 0; j < nreal; j++) {
        ind->xreal[j] = rndreal(min_realvar[j], max_realvar[j]);
    }
    return;
}

/* Function to initialize reference size based on popsize */
void initialize_nref() {
    int k = 0;

    if (nobj == 2){
        nref = popsize;
        klayer=nref-1;
    }
    else {
        switch (refMode) {
            case 0: refsizeK();
                break;
            case 1: while (nchoosek(++k+ nobj - 1, nobj - 1) <= popsize);
                klayer = k - 1;
                nref = nchoosek(nobj - 1 + klayer, nobj - 1);
                break;
            case 2: nref = popsize;
                break;
        }
    }
    return;
}

/* Function to calculate K parameter in K-layer method */
int refsizeK() {
    int k;
    for (k = 1; k < 2 * (int) sqrt(1.0 * popsize / nobj); k++) {
        if (nobj * k * (k + 3) / 2+1 <= popsize) {
            klayer = k;
        } else {
            break;
        }
    }
    nref = nobj * klayer * (klayer + 3) / 2 + 1;
    return nref;
}

/* Function to calculate  binomial coefficient */
int nchoosek(int n, int k) {
    if (k==0) return 1;
    return (n*nchoosek(n-1,k-1)/k);
}