/* Mating selection routines */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "Global.h"
#include "Random.h"

/* Routine for tournament selection and crossover, it creates new population from the archive set by performing tournament selection and the crossover */
void mating_selection(population *archive_set, population *pop_set) {
    int i;
    int rand1, rand2;

    individual *parent1, *parent2;
    for (i = 0; i < popsize; i++) {
        rand1 = i; //rnd(0, archsize - 1);
        parent1 = &archive_set->ind[rand1]; //tournament(&archive_set->ind[rand1], &archive_set->ind[rand2]);       
        rand2 = tournamentK(rand1, archive_set, niche);
        parent2 = &archive_set->ind[rand2];
        switch (repMode) {
            case 0: crossover(parent1, parent2, &pop_set->ind[i], &pop_set->ind[popsize - 1]); //SBX method
                break;
            case 1:
                LLcrossover(parent1, parent2, &pop_set->ind[i]); //Liu and Li's method, details can be found in the paper: "The multiobjective evolutionary algorithm based on determined weight and sub regional search"
                break;
        }
    }
    return;
}

int tournamentK(int id, population *pop, int k) {
    int i, temp, rand, tmpID, r1, r2;
    double min, d;
    int *a = (int *) malloc((archsize) * sizeof (int));

    r1 = pop->ind[id].rin;

    for (i = 0; i < archsize; i++)
        a[i] = i;
    for (i = 0; i < archsize; i++) {
        rand = rnd(i, archsize - 1);
        temp = a[rand];
        a[rand] = a[i];
        a[i] = temp;
    }

    min = 1.0e10;
    temp = 0;
    for (i = 0; i < archsize; i++) {
        r2 = pop->ind[a[i]].rin;
        if ((r2 == r1)) continue;
        if (a[i] != id) {
            temp++;
            d = Euclidean_Distance(&pop->ind[id], &pop->ind[a[i]]);
            if (d < min) {
                min = d;
                tmpID = a[i];
            }
        }
        if (temp >= k) break;
    }

    free(a);
    return tmpID;
}
