/* Mutation routines */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "Global.h"
#include "Random.h"

/* Function to perform mutation in a population */
void mutation_pop(population *pop) {
    int i;
    for (i = 0; i < popsize; i++) {
        switch (repMode) {
            case 0: real_mutate_ind(&(pop->ind[i])); // PM mutation
                break;
            case 1:LLmutation(&(pop->ind[i])); // Liu and Li's mutation
                break;
        }
    }
    return;
}

/* Routine for real polynomial mutation of an individual */
void real_mutate_ind(individual *ind) {
    int j;
    double rnd, delta1, delta2, mut_pow, deltaq;
    double y, yl, yu, val, xy;

    for (j = 0; j < nreal; j++) {
        rnd = randomperc();
        if (rnd <= pmut_real) {
            y = ind->xreal[j];
            yl = min_realvar[j];
            yu = max_realvar[j];
            delta1 = (y - yl) / (yu - yl);
            delta2 = (yu - y) / (yu - yl);
            rnd = randomperc();
            mut_pow = 1.0 / (eta_m + 1.0);
            if (rnd <= 0.5) {
                xy = 1.0 - delta1;
                val = 2.0 * rnd + (1.0 - 2.0 * rnd)*(pow(xy, (eta_m + 1.0)));
                deltaq = pow(val, mut_pow) - 1.0;
            } else {
                xy = 1.0 - delta2;
                val = 2.0 * (1.0 - rnd) + 2.0 * (rnd - 0.5)*(pow(xy, (eta_m + 1.0)));
                deltaq = 1.0 - (pow(val, mut_pow));
            }
            y = y + deltaq * (yu - yl);
            if (y < yl) {
                y = yl;
            }
            if (y > yu) {
                y = yu;
            }
            ind->xreal[j] = y;
        }
    }
    return;
}

// Liu and Li's crossover: "The multiobjective evolutionary algorithm based on determined weight and sub regional search"

void LLmutation(individual *child) {
    int i, mark = 1;
    double a = pow(1.0 - 1.0 * (gen-1)/ ngen, 0.7);
    double rm, y;
    for (i = 0; i < nreal; i++) {
        if (randomperc() <= pmut_real) {
            mark = 0; // at least one component of variable does mutation;
            rm = 0.05 * (randomperc() - 0.5)*(1 - pow(randomperc(), -a));
            y = child->xreal[i] + rm * (max_realvar[i] - min_realvar[i]);

            if (y < min_realvar[i])
                y = min_realvar[i] + 0.5 * randomperc()*(child->xreal[i] - min_realvar[i]);
            if (y > max_realvar[i])
                y = max_realvar[i] - 0.5 * randomperc()*(max_realvar[i] - child->xreal[i]);

            child->xreal[i] = y;
        }
    }
    if (mark) {
        i = rnd(0, nreal - 1);
        rm = 0.05 * (randomperc() - 0.5)*(1 - pow(randomperc(), -a));
        y = child->xreal[i] + rm * (max_realvar[i] - min_realvar[i]);

        if (y < min_realvar[i])
            y = min_realvar[i] + 0.5 * randomperc()*(child->xreal[i] - min_realvar[i]);
        if (y > max_realvar[i])
            y = max_realvar[i] - 0.5 * randomperc()*(max_realvar[i] - child->xreal[i]);

        child->xreal[i] = y;
    }

}