/* Routine for mergeing two populations */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "Global.h"
#include "Random.h"

/* Routine to merge two populations into one */
void merge(population *pop1, population *pop2, population *pop3, int size1, int size2) {
    int i, j, k, flag;
    nummerge = 0;
    for (i = 0; i < size1; i++) {
        flag = 1;
        for (j = 0; j < nummerge; j++) {
            flag = check_repeat(&pop1->ind[i], &pop3->ind[j]);
            if (!flag) break;
        }
        if (flag) {
            copy_ind(&(pop1->ind[i]), &(pop3->ind[nummerge++]));
        }
    }
    for (i = 0; i < size2; i++) {
        flag = 1;
        for (j = 0; j < nummerge; j++) {
            flag = check_repeat(&pop2->ind[i], &pop3->ind[j]);
            if (!flag) break;
        }
        if (flag) {
            copy_ind(&(pop2->ind[i]), &(pop3->ind[nummerge++]));
        }
    }
    return;
}

/* Routine to copy an individual 'ind1' into another individual 'ind2' */
void copy_ind(individual *ind1, individual *ind2) {
    int i;

    ind2->constr_violation = ind1->constr_violation;
    for (i = 0; i < nreal; i++)
        ind2->xreal[i] = ind1->xreal[i];

    for (i = 0; i < nobj; i++)
        ind2->obj[i] = ind1->obj[i];

    if (ncon != 0) {
        for (i = 0; i < ncon; i++)
            ind2->constr[i] = ind1->constr[i];
    }

    ind2->rin = ind1->rin;
    return;
}
