/* Test problem definitions */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#include "Global.h"
#include "Random.h"
#include "WFG.h"

/* Function to define test problems */
void test_problem(double *xreal, double *obj, double *constr) {
    /*  Test problem DTLZ1
    number of objectives = any
    number of real variables = nobj + 4
    number of constraints = 0
    variable range [0, 1] 
     */
    if (!strcmp(strTestInstance, "DTLZ1")) {
        double sum = 0;
        double gx;
        int i, j;

        for (i = nobj - 1; i < nreal; i++) {
            //sum += pow ((xreal[i]-0.5), 2.0);
            sum += pow((xreal[i] - 0.5), 2.0) - cos(20 * PI * (xreal[i] - 0.5));
        }
        //gx = 1.0 + sum;
        gx = 100 * (sum + nreal - nobj + 1) + 1.0;
        sum = gx;
        for (j = 0; j < nobj - 1; j++) {
            sum = sum * xreal[j];
        }
        obj[0] = 0.5 * sum;

        for (i = 1; i < nobj; i++) {
            sum = gx;
            for (j = 0; j < nobj - 1 - i; j++) {
                sum = sum * xreal[j];
            }
            sum = sum * (1.0 - xreal[nobj - 1 - i]);
            obj[i] = 0.5 * sum;
        }
        return;
    }


    /*  Test problem DTLZ2
    number of objectives = any
    number of real variables = nobj + 9
    number of constraints = 0
    variable range [0, 1] 
     */
    if (!strcmp(strTestInstance, "DTLZ2")) {
        double sum = 0;
        double gx;
        int i, j;

        for (i = nobj - 1; i < nreal; i++) {
            sum += pow((xreal[i] - 0.5), 2.0);
        }
        gx = 1.0 + sum;
        sum = gx;
        for (j = 0; j < nobj - 1; j++) {
            sum = sum * cos(xreal[j] * PI / 2.0);
        }
        obj[0] = sum;

        for (i = 1; i < nobj; i++) {
            sum = gx;
            for (j = 0; j < nobj - 1 - i; j++) {
                sum = sum * cos(xreal[j] * PI / 2.0);
            }
            sum = sum * sin(xreal[nobj - 1 - i] * PI / 2.0);
            obj[i] = sum;
        }
        //obj[nobj-1] = 1*obj[nobj-1];
        return;
    }


    /*  Test problem DTLZ3
    number of objectives = any
    number of real variables = nobj + 9
    number of constraints = 0
    variable range [0, 1] 
     */
    if (!strcmp(strTestInstance, "DTLZ3")) {
        double sum = 0;
        double gx;
        int i, j;

        for (i = nobj - 1; i < nreal; i++) {
            sum += pow((xreal[i] - 0.5), 2.0) - cos(20 * PI * (xreal[i] - 0.5));
        }
        gx = 100 * (sum + nreal - nobj + 1) + 1.0;
        sum = gx;
        for (j = 0; j < nobj - 1; j++) {
            sum = sum * cos(xreal[j] * PI / 2.0);
        }
        obj[0] = sum;

        for (i = 1; i < nobj; i++) {
            sum = gx;
            for (j = 0; j < nobj - 1 - i; j++) {
                sum = sum * cos(xreal[j] * PI / 2.0);
            }
            sum = sum * sin(xreal[nobj - 1 - i] * PI / 2.0);
            obj[i] = sum;
        }
        return;

    }


    /*  Test problem DTLZ4
    number of objectives = any
    number of real variables = nobj + 9
    number of constraints = 0
    variable range [0, 1] 
     */
    if (!strcmp(strTestInstance, "DTLZ4")) {
        double sum = 0;
        double gx;
        int i, j;
        double *_xreal;
        _xreal = (double *) malloc(nreal * sizeof (double));
        memcpy(_xreal, xreal, nreal * sizeof (double));

        for (i = nobj - 1; i < nreal; i++) {
            sum += pow((_xreal[i] - 0.5), 2.0);
        }
        for (i = 0; i < nobj - 1; i++) {
            _xreal[i] = pow((float) _xreal[i], (float) 100);
        }
        gx = 1.0 + sum;
        sum = gx;
        for (j = 0; j < nobj - 1; j++) {
            sum = sum * cos(_xreal[j] * PI / 2.0);
        }
        obj[0] = sum;

        for (i = 1; i < nobj; i++) {
            sum = gx;
            for (j = 0; j < nobj - 1 - i; j++) {
                sum = sum * cos(_xreal[j] * PI / 2.0);
            }
            sum = sum * sin(_xreal[nobj - 1 - i] * PI / 2.0);
            obj[i] = sum;
        }
        free(_xreal);
        return;
    }


    /*  Test problem DTLZ5
    number of objectives = any
    number of real variables = nobj + 9
    number of constraints = 0
    variable range [0, 1] 
     */
    if (!strcmp(strTestInstance, "DTLZ5")) {
        double sum = 0;
        double gx;
        int i, j;
        double *x;
        x = (double*) malloc((nobj - 1) * sizeof (double));

        for (i = nobj - 1; i < nreal; i++) {
            sum += pow((xreal[i] - 0.5), 2.0);
        }
        for (i = 1; i < nobj - 1; i++) {
            x[i] = PI / (4 * (1 + sum))*(1 + 2 * sum * xreal[i]);
        }
        gx = 1.0 + sum;
        sum = gx;
        for (j = 1; j < nobj - 1; j++) {
            sum = sum * cos(x[j]);
        }
        sum = sum * cos(xreal[0] * PI / 2.0);
        obj[0] = sum;

        for (i = 1; i < nobj; i++) {
            sum = gx;
            for (j = 1; j < nobj - 1 - i; j++) {
                sum = sum * cos(x[j]);
            }
            if (i == nobj - 1) {
                sum = sum * sin(xreal[0] * PI / 2.0);
            } else {
                sum = sum * sin(x[nobj - 1 - i]);
                sum = sum * cos(xreal[0] * PI / 2.0);
            }
            obj[i] = sum;
        }
        free(x);
        return;
    }


    /*  Test problem DTLZ6
    number of objectives = any
    number of real variables = nobj + 9
    number of constraints = 0
    variable range [0, 1] 
     */
    if (!strcmp(strTestInstance, "DTLZ6")) {
        double sum = 0;
        double gx;
        int i, j;
        double *x;
        x = (double*) malloc((nobj - 1) * sizeof (double));

        for (i = nobj - 1; i < nreal; i++) {
            sum += pow((xreal[i]), 0.1);
        }
        for (i = 1; i < nobj - 1; i++) {
            x[i] = PI / (4 * (1 + sum))*(1 + 2 * sum * xreal[i]);
        }
        gx = 1.0 + sum;
        sum = gx;
        for (j = 1; j < nobj - 1; j++) {
            sum = sum * cos(x[j]);
        }
        sum = sum * cos(xreal[0] * PI / 2.0);
        obj[0] = sum;

        for (i = 1; i < nobj; i++) {
            sum = gx;
            for (j = 1; j < nobj - 1 - i; j++) {
                sum = sum * cos(x[j]);
            }
            if (i == nobj - 1) {
                sum = sum * sin(xreal[0] * PI / 2.0);
            } else {
                sum = sum * sin(x[nobj - 1 - i]);
                sum = sum * cos(xreal[0] * PI / 2.0);
            }
            obj[i] = sum;
        }
        free(x);
        return;
    }

    /*  Test problem DTLZ7
    number of objectives = any
    number of real variables = nobj + 19
    number of constraints = 0
    variable range [0, 1] 
     */
    if (!strcmp(strTestInstance, "DTLZ7")) {
        double sum = 0, temp = 0;
        double gx;
        int i, j;

        for (i = nobj - 1; i < nreal; i++) {
            sum += xreal[i];
        }
        gx = 1.0 + 9.0 * sum / (nreal - nobj + 1.0);
        sum = gx;
        for (i = 0; i < nobj - 1; i++) {
            obj[i] = xreal[i];
        }
        for (i = 0; i < nobj - 1; i++) {
            temp += (obj[i] / (sum + 1))*(1 + sin(3 * PI * obj[i]));
        }
        temp = nobj - temp;
        obj[nobj - 1] = (sum + 1) * temp;
        return;
    }


    if (!strcmp(strTestInstance, "DTLZ8")) {
        double sum = 0;
        double gx;
        int i, j;

        for (i = nobj - 1; i < nreal; i++) {
            sum += pow((xreal[i] - 0.5), 2.0);
        }
        gx = 1.0 + sum;
        sum = gx;
        for (j = 0; j < nobj - 1; j++) {
            sum = sum * cos(xreal[j] * PI / 2.0);
        }
        obj[0] = sum;

        for (i = 1; i < nobj; i++) {
            sum = gx;
            for (j = 0; j < nobj - 1 - i; j++) {
                sum = sum * cos(xreal[j] * PI / 2.0);
            }
            sum = sum * sin(xreal[nobj - 1 - i] * PI / 2.0);
            obj[i] = sum;
        }

        for (i = 0; i < nobj - 1; i++)
            obj[i] = pow(obj[i], 4.0);
        obj[nobj - 1] = pow(obj[nobj - 1], 2.0);
        return;
    }


    /*  Test problem Pareto-Box
    number of objectives = 10
    number of real variables = 2
    number of constraints = 0
    variable range [-10000, 10000]
     */
    if (!strcmp(strTestInstance, "PBox")) {

        obj[0] = sqrt((xreal[0] - 50)*(xreal[0] - 50) + (xreal[1] - 88)*(xreal[1] - 88));
        obj[1] = sqrt((xreal[0] - 70)*(xreal[0] - 70) + (xreal[1] - 80)*(xreal[1] - 80));
        obj[2] = sqrt((xreal[0] - 83)*(xreal[0] - 80) + (xreal[1] - 62)*(xreal[1] - 62));
        obj[3] = sqrt((xreal[0] - 83)*(xreal[0] - 83) + (xreal[1] - 38)*(xreal[1] - 38));
        obj[4] = sqrt((xreal[0] - 70)*(xreal[0] - 70) + (xreal[1] - 20)*(xreal[1] - 20));
        obj[5] = sqrt((xreal[0] - 50)*(xreal[0] - 50) + (xreal[1] - 12)*(xreal[1] - 12));
        obj[6] = sqrt((xreal[0] - 30)*(xreal[0] - 30) + (xreal[1] - 20)*(xreal[1] - 20));
        obj[7] = sqrt((xreal[0] - 17)*(xreal[0] - 17) + (xreal[1] - 38)*(xreal[1] - 38));
        obj[8] = sqrt((xreal[0] - 17)*(xreal[0] - 17) + (xreal[1] - 62)*(xreal[1] - 62));
        obj[9] = sqrt((xreal[0] - 30)*(xreal[0] - 30) + (xreal[1] - 80)*(xreal[1] - 80));

        return;
    }



    /*  Test problem POL
    number of objectives = any
    number of real variables = 2
    number of constraints = 0
    variable range [-pi, pi] 
     */
    if (!strcmp(strTestInstance, "POL")) {
        double a1, a2, b1, b2;
        a1 = 0.5 * sin(1.0) - 2 * cos(1.0) + sin(2.0) - 1.5 * cos(2.0);
        a2 = 1.5 * sin(1.0) - cos(1.0) + 2 * sin(2.0) - 0.5 * cos(2.0);

        b1 = 0.5 * sin(xreal[0]) - 2 * cos(xreal[0]) + sin(xreal[1]) - 1.5 * cos(xreal[1]);
        b2 = 1.5 * sin(xreal[0]) - cos(xreal[0]) + 2 * sin(xreal[1]) - 0.5 * cos(xreal[1]);

        obj[0] = 1 + pow(a1 - b1, 2.0) + pow(a2 - b2, 2.0);
        obj[1] = pow(xreal[0] + 3, 2.0) + pow(xreal[1] + 1, 2.0);
        return;
    }


    /*  Test problem mF4
    number of objectives = any
    number of real variables = nobj + 9
    number of constraints = 0
    variable range [1, 10] 
     */
    if (!strcmp(strTestInstance, "mF4")) {
        double sum = 0;
        double gx;
        int i, j;

        for (i = nobj - 1; i < nreal; i++) {
            sum += pow((xreal[i] - 5), 2.0);
        }
        gx = 1.0 + sum;
        obj[0] = (1 + gx) * xreal[0] / sqrt(xreal[1] * xreal[2]);
        obj[1] = (1 + gx) * xreal[1] / sqrt(xreal[0] * xreal[2]);
        obj[2] = (1 + gx) * xreal[2] / sqrt(xreal[1] * xreal[0]);
        return;
    }



    /*  Test problem F5
    number of objectives = any
    number of real variables = nobj + 9
    number of constraints = 0
    variable range [0, 1] 
     */
    if (!strcmp(strTestInstance, "F5")) {
        double sum = 0;
        double gx;
        int i, j;

        for (i = nobj - 1; i < nreal; i++) {
            sum += pow((xreal[i] - 0.5), 2.0);
        }
        gx = 1.0 + sum;

        obj[0] = (1 + gx)*(1 - xreal[0]) * xreal[1];
        obj[1] = (1 + gx) * xreal[0]*(1 - xreal[1]);
        obj[2] = (1 + gx) * pow(1 - xreal[0] - xreal[1] + 2 * xreal[1] * xreal[0], 6.0);
        return;
    }


    /*  Test problem F6
    number of objectives = any
    number of real variables = nobj + 9
    number of constraints = 0
    variable range [0, 1] 
     */
    if (!strcmp(strTestInstance, "F6")) {
        double sum = 0;
        double gx;
        int i, j;

        for (i = nobj - 1; i < nreal; i++) {
            sum += 1 + pow((float) (xreal[i]), (float) 2) - cos(2 * PI * xreal[i]);
        }
        gx = 1.0 + sum / 10;
        sum = 1;
        for (j = 0; j < nobj - 1; j++) {
            sum = sum * cos(xreal[j] * PI / 2.0);
        }
        obj[0] = pow((float) sum, (float) 4);
        sum = cos(xreal[0] * PI / 2.0) * sin(xreal[1] * PI / 2.0);
        obj[1] = pow((float) sum, (float) 4);
        obj[2] = pow(gx / (1 + pow(cos(xreal[0] * PI / 2.0), 2.0)), 1.0 / gx);

        /*for (i=1; i<nobj; i++)
        {
        sum = 1;
        for (j=0; j<nobj-1-i; j++)
        {
        sum = sum * cos(xreal[j]*PI/2.0);
        }
        sum = sum * sin(xreal[nobj-1-i]*PI/2.0);
        if (i<nobj-1)
        obj[i] = pow(sum,4.0);
        else
        obj[i]==pow(gx/(1+pow(cos(xreal[0]*PI/2.0),2.0)),1.0/gx);
        }*/
        return;
    }


    // A static version of SJY6.
    if (!strcmp(strTestInstance, "F7")) {
        double sum = 0, g = 0;
        int i;
        for (i = nobj - 1; i < nreal; i++)
            g += xreal[i];
        for (i = 0; i < nobj - 1; i++) {
            obj[i] = (1.0 + g) * pow(cos(0.5 * PI * xreal[i]), 2.0);
            sum += pow(sin(0.5 * PI * xreal[i]), 2.0) + sin(0.5 * PI * xreal[i]) * pow(cos(3 * PI * xreal[i]), 2.0);
        }
        obj[nobj - 1] = sum;
    }

    //******************MOP Test Suite**********************//
    //MOP1-5 are biobjective, MOP6-7 triobjective, # variables=10//

    // MOP1
    if (!strcmp(strTestInstance, "MOP1")) {
        double sum = 0, g = 0, t;
        int i;
        for (i = 1; i < nreal; i++) {
            t = xreal[i] - sin(0.5 * PI * xreal[0]);
            sum += -0.9 * t * t + pow(fabs(t), 0.6);
        }
        g = 1 + 2 * sin(PI * xreal[0]) * sum;
        obj[0] = g * xreal[0];
        obj[1] = g * (1 - pow(xreal[0], 0.5));
    }

    // MOP2
    if (!strcmp(strTestInstance, "MOP2")) {
        double sum = 0, g = 0, t;
        int i;
        for (i = 1; i < nreal; i++) {
            t = xreal[i] - sin(0.5 * PI * xreal[0]);
            sum += fabs(t) / (1 + exp(5.0 * fabs(t)));
        }
        g = 1 + 10 * sin(PI * xreal[0]) * sum;
        obj[0] = g * xreal[0];
        obj[1] = g * (1 - pow(xreal[0], 2.0));
    }

    // MOP3
    if (!strcmp(strTestInstance, "MOP3")) {
        double sum = 0, g = 0, t;
        int i;
        for (i = 1; i < nreal; i++) {
            t = xreal[i] - sin(0.5 * PI * xreal[0]);
            sum += fabs(t) / (1 + exp(5.0 * fabs(t)));
        }
        g = 1 + 10 * sin(0.5 * PI * xreal[0]) * sum;
        obj[0] = g * cos(0.5 * PI * xreal[0]);
        obj[1] = g * sin(0.5 * PI * xreal[0]);
    }

    // MOP4
    if (!strcmp(strTestInstance, "MOP4")) {
        double sum = 0, g = 0, t;
        int i;
        for (i = 1; i < nreal; i++) {
            t = xreal[i] - sin(0.5 * PI * xreal[0]);
            sum += fabs(t) / (1 + exp(5.0 * fabs(t)));
        }
        g = 1 + 10 * sin(PI * xreal[0]) * sum;
        obj[0] = g * xreal[0];
        obj[1] = g * (1 - pow(xreal[0], 0.5) * pow(cos(2.0 * PI * xreal[0]), 2.0));
    }

    // MOP5
    if (!strcmp(strTestInstance, "MOP5")) {
        double sum = 0, g = 0, t;
        int i;
        for (i = 1; i < nreal; i++) {
            t = xreal[i] - sin(0.5 * PI * xreal[0]);
            sum += -0.9 * t * t + pow(fabs(t), 0.6);
        }
        g = 1 + 2 * fabs(cos(PI * xreal[0])) * sum;
        obj[0] = g * xreal[0];
        obj[1] = g * (1 - pow(xreal[0], 0.5));
    }

    // MOP6
    if (!strcmp(strTestInstance, "MOP6")) {
        double sum = 0, g = 0, t;
        int i;
        for (i = 2; i < nreal; i++) {
            t = xreal[i] - xreal[0] * xreal[1];
            sum += -0.9 * t * t + pow(fabs(t), 0.6);
        }
        g = 1 + 2 * sin(PI * xreal[0]) * sum;
        obj[0] = g * xreal[0] * xreal[1];
        obj[1] = g * xreal[0]*(1 - xreal[1]);
        obj[2] = g * (1 - xreal[0]);
    }

    // MOP7
    if (!strcmp(strTestInstance, "MOP7")) {
        double sum = 0, g = 0, t;
        int i;
        for (i = 2; i < nreal; i++) {
            t = xreal[i] - xreal[0] * xreal[1];
            sum += -0.9 * t * t + pow(fabs(t), 0.6);
        }
        g = 1 + 2 * sin(PI * xreal[0]) * sum;
        obj[0] = g * cos(0.5 * PI * xreal[0]) * cos(0.5 * PI * xreal[1]);
        obj[1] = g * cos(0.5 * PI * xreal[0]) * sin(0.5 * PI * xreal[1]);
        obj[2] = g * sin(0.5 * PI * xreal[0]);
    }



    //******************WFG Test Suite**********************//

    if (!strcmp(strTestInstance, "WFG1")) {
        double *y, *dst;
        y = (double *) malloc(nreal * sizeof (double));
        dst = (double *) malloc(nobj * sizeof (double));
        WFG_normalise_z(y, xreal, nreal);
        WFG1_t1(y, vk, nreal);
        WFG1_t2(y, vk, nreal);
        WFG1_t3(y, vk, nreal);
        WFG1_t4(dst, y, vk, nobj, nreal);

        WFG1_shape(obj, dst, nobj);
        free(y);
        free(dst);
    }


    if (!strcmp(strTestInstance, "WFG2")) {
        double *y, *dst;
        y = (double *) malloc(nreal * sizeof (double));
        dst = (double *) malloc(nobj * sizeof (double));
        WFG_normalise_z(y, xreal, nreal);
        WFG1_t1(y, vk, nreal);
        WFG2_t2(y, vk, nreal); //size(y)=vk+(nreal-vk)/2
        WFG2_t3(dst, y, vk, nobj, vk + (nreal - vk) / 2);

        WFG2_shape(obj, dst, nobj);
        free(y);
        free(dst);

    }


    if (!strcmp(strTestInstance, "WFG3")) {
        double *y, *dst;
        y = (double *) malloc(nreal * sizeof (double));
        dst = (double *) malloc(nobj * sizeof (double));
        WFG_normalise_z(y, xreal, nreal);
        WFG1_t1(y, vk, nreal);
        WFG2_t2(y, vk, nreal);
        WFG2_t3(dst, y, vk, nobj, vk + (nreal - vk) / 2);

        WFG3_shape(obj, dst, nobj);
        free(y);
        free(dst);
    }



    if (!strcmp(strTestInstance, "WFG4")) {
        double *y, *dst;
        y = (double *) malloc(nreal * sizeof (double));
        dst = (double *) malloc(nobj * sizeof (double));
        WFG_normalise_z(y, xreal, nreal);
        WFG4_t1(y, nreal);
        WFG2_t3(dst, y, vk, nobj, nreal);

        WFG4_shape(obj, dst, nobj);
        free(y);
        free(dst);
    }


    if (!strcmp(strTestInstance, "WFG5")) {
        double *y, *dst;
        y = (double *) malloc(nreal * sizeof (double));
        dst = (double *) malloc(nobj * sizeof (double));
        WFG_normalise_z(y, xreal, nreal);
        WFG5_t1(y, nreal);
        WFG2_t3(dst, y, vk, nobj, nreal);

        WFG4_shape(obj, dst, nobj);
        free(y);
        free(dst);
    }


    if (!strcmp(strTestInstance, "WFG6")) {
        double *y, *dst;
        y = (double *) malloc(nreal * sizeof (double));
        dst = (double *) malloc(nobj * sizeof (double));
        WFG_normalise_z(y, xreal, nreal);
        WFG1_t1(y, vk, nreal);
        WFG6_t2(dst, y, vk, nobj, nreal);

        WFG4_shape(obj, dst, nobj);
        free(y);
        free(dst);
    }


    if (!strcmp(strTestInstance, "WFG7")) {
        double *y, *dst;
        y = (double *) malloc(nreal * sizeof (double));
        dst = (double *) malloc(nobj * sizeof (double));
        WFG_normalise_z(y, xreal, nreal);
        WFG7_t1(y, vk, nreal);
        WFG1_t1(y, vk, nreal);
        WFG2_t3(dst, y, vk, nobj, nreal);

        WFG4_shape(obj, dst, nobj);
        free(y);
        free(dst);

    }


    if (!strcmp(strTestInstance, "WFG8")) {
        double *y, *dst;
        y = (double *) malloc(nreal * sizeof (double));
        dst = (double *) malloc(nobj * sizeof (double));
        WFG_normalise_z(y, xreal, nreal);
        WFG8_t1(y, vk, nreal);
        WFG1_t1(y, vk, nreal);
        WFG2_t3(dst, y, vk, nobj, nreal);

        WFG4_shape(obj, dst, nobj);
        free(y);
        free(dst);
    }
    if (!strcmp(strTestInstance, "WFG9")) {
        double *y, *dst;
        y = (double *) malloc(nreal * sizeof (double));
        dst = (double *) malloc(nobj * sizeof (double));
        WFG_normalise_z(y, xreal, nreal);
        WFG9_t1(y, nreal);
        WFG9_t2(y, vk, nreal);
        WFG6_t2(dst, y, vk, nobj, nreal);

        WFG4_shape(obj, dst, nobj);
        free(y);
        free(dst);
    }
    if (!strcmp(strTestInstance, "WFG10")) {
    }
}
