#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "Global.h"

void alloc_ReferDirect(reference *ref) {
    int i;
    if (nobj == 2) // simplex-lattice-design in 2-obj cases
    {
//        for (i = 0; i < nref; i++) {
//            ref->poin[i].obj[0] = 1.0 * i / (nref - 1);
//            ref->poin[i].obj[1] = 1.0 - ref->poin[i].obj[0];
//        }
        SSLD(ref, klayer, 0);
    } else {
        switch (refMode) {
            case 0: KLD(ref, klayer);
                break;
            case 1: SSLD(ref, klayer, 0);
                break;
            case 2: TSLD(ref, 5, 4);    // attaction: please carefully configure parameter list.
                break; 
        }
    }

    alloc_ReferNeighbor(ref);
}

/* function to generate reference set by K-layer design */
void KLD(reference *ref, int unit) {
    int i, j, t, m, k = 0;
    double centre = 1.0 / nobj, b = 0.0;
    double a1, b1;

    // points on the line that joins extreme and centre;
    for (i = 1; i <= nobj; i++) {
        for (j = 1; j <= unit; j++) {
            for (m = 0; m < nobj; m++) {
                if (i == (m + 1))
                    b = 1.0;
                else
                    b = 0;

                ref->poin[k].obj[m] = centre + j * (b - centre) / unit;

            }
            k++;
        }
    }
    for (i = 1; i <= nobj; i++) {
        for (j = 1; j <= unit; j++) {
            for (t = 1; t <= j; t++) {
                for (m = 0; m < nobj; m++) {
                    if (i == (m + 1))
                        b = 1.0;
                    else
                        b = 0;
                    a1 = centre + j * (b - centre) / unit;
                    if ((m == i) || ((i == nobj)&&(m == 0)))
                        b = 1.0;
                    else
                        b = 0;
                    b1 = centre + j * (b - centre) / unit;
                    ref->poin[k].obj[m] = a1 + t * (b1 - a1) / (j + 1);
                }
                k++;
            }

        }
    }
    for (m = 0; m < nobj; m++)
        ref->poin[k].obj[m] = centre;
    nref = k + 1;
}

/* function to generate reference set by standard simplex-lattice-design design */
int SSLD(reference *ref, int unit, int k) {
    int i = 1;
    if (k + nchoosek(unit + nobj - 1, nobj - 1) > popsize) {
        printf("\n Parameter configuration error: infeasible choice of unit and k in simplex-lattice-design\n");
        if (k >= popsize)
            printf("\n \t Solution: please choose k smaller than %i \n", popsize);
        else {
            printf("\n \t unit and k are now %i and %i, respectively || solution: reconfigure unit or k. \n", unit, k);

            while (nchoosek(++i + nobj - 1, nobj - 1) < popsize - k) {
            }
            printf("\t \t unit is recommended to be %i \n", i - 1);
        }
        exit(0);
        return 0;
    }

    int *p = (int *) malloc(nobj * sizeof (int));
    int more = 0;
    while (unit) {
        generate_referpoint(p, unit, &more);
        for (i = 0; i < nobj; i++) ref->poin[k].obj[i] = 1.0 * p[i] / unit;
        k++;
        if (!more) break;
    }
    free(p);

    return k;
}

/* function to generate reference set by 2-layered simplex-lattice-design design */
void TSLD(reference *ref, int unit1, int unit2) {
    // SSLD on outer layer 
    int size = SSLD(ref, unit1, 0);

    // SSLD on outer layer 
    nref = SSLD(ref, unit2, size);
}

/* assign neighbouring reference directions, return an value max(min(w_i, w_j)) 
// that is the maximal acute angle between any two nearest vectors */
void alloc_ReferNeighbor(reference *ref) {
    double *x;
    int *idx;
    int i, j, k;

    x = (double *) malloc(nref * sizeof (double));
    idx = (int *) malloc(nref * sizeof (int));

    delta = -1.0e10;
    for (i = 0; i < nref; i++) {
        // calculate the distances based on weight vectors
        for (j = 0; j < nref; j++) {
            x[j] = comangle(ref->poin[i].obj, ref->poin[j].obj);
            idx[j] = j;
        }

        // find 'niche' nearest neighboring subproblems
        //minfastsort(x,idx,nref,niche);
        //for(k=0; k<niche; k++)
        //{
        //	ref[i].poin->table[k]=idx[k];
        //}

        /******delta=max(min(w_i, w_j))******/
        minfastsort(x, idx, nref, 2);
        if (delta < x[1]) delta = x[1];
    }
    free(x);
    free(idx);
}

/* function to generate all possible vectors that satisfy w_1+...+w_m=1 */
void generate_referpoint(int *p, int unit, int *more) {
    int i, j;
    if (!*more) {
        *more = 1;
        j = 1;
        p[0] = unit;
        for (i = 1; i < nobj; i++)
            p[i] = 0;
    } else {
        j = nobj - 1;
        for (i = nobj - 2; i >= 0; i--) {
            if (p[i] > 0) {
                j = i;
                break;
            }
        }
        p[j] -= 1;
        p[j + 1] = unit;
        for (i = 0; i <= j; i++)
            p[j + 1] -= p[i];
        for (i = j + 2; i < nobj; i++)
            p[i] = 0;
        if (p[nobj - 1] == unit)
            *more = 0;
    }

}