/* Routines for putting population data into files */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "Global.h"
#include "Random.h"

/* Output of individuals in the objective space */
void report_objective(population *pop, int size, FILE *fpt) {
    int i, j;
    for (i = 0; i < size; i++) {
        for (j = 0; j < nobj; j++) {
            fprintf(fpt, "%e\t", pop->ind[i].obj[j]);
        }
        fprintf(fpt, "\n");
    }
    fprintf(fpt, "\n");
    return;
}

/* Output of individuals in the decision space */
void report_variable(population *pop, int size, FILE *fpt) {
    int i, j;
    for (i = 0; i < size; i++) {
        for (j = 0; j < nreal; j++) {
            fprintf(fpt, "%e\t", pop->ind[i].xreal[j]);
        }
        fprintf(fpt, "\n");
    }
    fprintf(fpt, "\n");
    return;
}
