#pragma once

#define min(a, b) (a)<(b)? (a):(b)
#define max(a, b) (a)>(b)? (a):(b)
#define PI 3.141592653589793238462643383279502884197169399375105


#include <math.h>


void WFG_normalise_z(double *dst, double *z, int size);

void subvector(double *v, double *subv, const int head, const int tail);

/***********trans******************/
double b_poly(double y, double alpha);
double s_linear(double y, double A);
double b_flat(double y, double A, double B, double C);

double b_param(double y, double u, double A, double B, double C);

double s_decept(double y, double A, double B, double C);

double s_multi(double y, double A, double B, double C);

double r_sum(double *y, double *w, int size);

double r_nonsep(double *y, int A, int size);

/*********shape***************/
double linear(double *y, int size, int m);

double convex(double *y, int size, int m);

double concave(double *y, int size, int m);

double mixed(double *y, int A, double alpha);

double disc(double *y, int A, double alpha, double beta);

/*******Framework functions**********/
void calculate_x(double *x, double *t_p, int size, double *A);

void calculate_f(double *y, double D, double x, double *h, int size, double *S);

/**********main shape****************/
void WFG_create_A(double *A, int M, int degenerate);

void WFG_calculate_f(double *y, double x, double *h, int size);


void WFG1_shape(double *y, double *t_p, int size);

void WFG2_shape(double *y, double *t_p, int size);

void WFG3_shape(double *y, double *t_p, int size);

void WFG4_shape(double *y, double *t_p, int size);

/********main transition******************/
void WFG1_t1(double *y, int k, int size);

void WFG1_t2(double *y, int k, int size);

void WFG1_t3(double *y, int k, int size);

void WFG1_t4(double *dst, double *y, int k, int M, int size);

void WFG2_t2(double *y, int k, int size);

void WFG2_t3(double *dst, double *y, int k, int M, int size);

void WFG4_t1(double *y, int size);

void WFG5_t1(double *y, int size);

void WFG6_t2(double *dst, double *y, int k, int M, int size);

void WFG7_t1(double *y, int k, int size);

void WFG8_t1(double *y, int k, int size);

void WFG9_t1(double *y, int size);

void WFG9_t2(double *y, int k, int size);