/*===========================================================================================================================
//  Implementation of SPEA/R
//  Last update 20, OCT, 2016
//
//  Please find details of the method in th following paper
//  Shouyong Jiang and Shengxiang Yang. "A strength Pareto evolutionary algorithm based on reference directions 
//  for multiobjective and many-objective optimization", IEEE Transactions on Evolutionary Computation, 2016, in press. 
//
//  The source code of the algorithm was implemented by Shouyong Jiang
//
//  The codes are free for reserach work.
//  If you have any problem with the source codes, please contact
//  Shouyong Jiang at math4neu@gmail.com or Shengxiang Yang at syang@dmu.ac.uk
============================================================================================================================*/

// NOTE: This code is for minimization optimiation problems; for maximization problems, some procedures need to be modified,
// such as Pareto dominance relation.

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <string.h>
#include <sys/stat.h>

#include "Global.h" 
#include "Random.h"
#include "WFG.h"

int main(int argc, char **argv) {
    int nextarg = 1;
    while ((argc > 1)&&(nextarg < argc)) {
        if (strcmp(argv[nextarg], "p") == 0) popsize = atoi(argv[++nextarg]);
        else if (strcmp(argv[nextarg], "o") == 0) nobj = atoi(argv[++nextarg]);
        else if (strcmp(argv[nextarg], "g") == 0) ngen = atoi(argv[++nextarg]);
        else if (strcmp(argv[nextarg], "n") == 0) niche = atoi(argv[++nextarg]);
        else {
            printf("Unrecognized parameters.\n");
            return 0;
        }

        nextarg++;
    }

    int i, j, it;
    int random;
    double runTime, startTime, endTime;

    FILE *fpop;

    FILE *ftime; //save time cost.

    population *pop_set;
    population *archive_set;
    population *mixed_set;

    reference *refdirect_set;

    char parName[100], parName1[100], parNamea[100], parNameb[100];

      char *instances[]  = {"DTLZ1","DTLZ2","DTLZ3","DTLZ4",
    	"WFG1", "WFG2","WFG3","WFG4","WFG5","WFG6","WFG7","WFG8","WFG9"};

//    char *instances[] = {"MOP1", "MOP2", "MOP3", "MOP4", "MOP5", "MOP6", "MOP7"};
//    int obj[] = {2, 2, 2, 2, 2, 3, 3};
//    int pop[] = {100, 100, 100, 100, 100, 300, 313};

    /*-------test problem setting------start---------*/
    nobj=12;                           // #objectives
    popsize = 244;		            // population size
    ngen = 2000; // maxmum #generations
    niche = 20; // mating range
    nrun = 10; // total number of runs

    refMode = 0;// method to generate a reference set
                // refMode=0: k-layer; 
                // refMode=1: standard simplex-lattice-design; 
                // refMode=2: 2-layered design;
    
    repMode = 0;// method to reproduce population
                // repMode=0: SBX + PM
                // repMode=1: LLX+LLM (Liu and Li's method)
    
    /*-------test problem setting------end---------*/

    for (it = 8; it < 9; it++) {
        //nobj=obj[it];
        //popsize = pop[it];
        srand((unsigned) time(NULL));
        random = rand() % 1000;
        seed = (float) random / 1000.0;

        if (seed <= 0.0 || seed >= 1.0) {
            printf("\n Entered seed value is wrong, seed value must be in (0,1) \n");
            exit(1);
        }

        strcpy(strTestInstance, instances[it]);
        //nreal = 10; // for MOP Test Suite

        // if (it==0)  nreal = nobj + 4;
        // else  
        // if (it<4)  nreal = nobj + 9;  
        // else 
        // {
         vk=2*(nobj-1);
         nreal = vk + 10;
        // }

        // set the range of the variables
        min_realvar = (double *) malloc(nreal * sizeof (double));
        max_realvar = (double *) malloc(nreal * sizeof (double));

        for (j = 0; j < nreal; j++) {
            min_realvar[j] = 0;
            max_realvar[j] = 2*j+2;
        }

        /*-------parameter setting in the algorithm------start---------*/
        //neval = 100000;					// maximal number of evaluations


        pcross_real = 1.0; // crossover probability
        pmut_real = 1.0 / nreal; // mutation probability
        eta_c = 20.0; // distribution index of simulated binary crossover (SBX)
        eta_m = 20.0; // distribution index of polynomial mutation
        klayer = 15; // number of layers in k-layer method
        nref = popsize; // number of reference directions		
        archsize = popsize; // archive size

        intercept = (double*) malloc(nobj * sizeof (double)); // for normalization of objectives
        idealpoint = (double*) malloc(nobj * sizeof (double));
        for (i = 0; i < nobj; i++) {
            intercept[i] = 1.0; // default for normalized MOPs
            idealpoint[i] = 1.0e20; // initialization
        }
        /*-------parameter setting in the algorithm------end---------*/
        initialize_nref();

        pop_set = (population *) malloc(sizeof (population));
        archive_set = (population *) malloc(sizeof (population));
        mixed_set = (population *) malloc(sizeof (population));
        refdirect_set = (reference *) malloc(sizeof (reference));

        allocate_memory_pop(pop_set, popsize);
        allocate_memory_pop(archive_set, archsize);
        allocate_memory_pop(mixed_set, popsize + archsize);
        allocate_memory_ref(refdirect_set, nref);

        alloc_ReferDirect(refdirect_set);
        randomize();
        printf("Parameter setting done, now start running \n");

        system("mkdir -p data");
        sprintf(parName, "data/%s_pop%i_ref%i_gen%i_obj%i", strTestInstance, popsize, nref, ngen, nobj);
        sprintf(parNamea, "mkdir -p %s", parName);

        if (system(parNamea))
            printf("This file has already existed \n");

        for (j = 1; j <= nrun; j++) {
            printf("This is the %i-th run of total %i runs.\n", j, nrun);
            
            char logtime[100];
            sprintf(parName1, "%s/run_%i", parName, j);
            sprintf(parNameb, "mkdir -p %s", parName1);

            if (system(parNameb))
                printf("This file has already existed\n");

            currenteval = 0;
            gen = 1;

            startTime = clock();
            initialize_pop(archive_set, archsize);
            evaluate_pop(archive_set, archsize);
            initialize_pop(pop_set, popsize);

            //while (currenteval < neval)
            while (gen <= ngen) {
                evaluate_pop(pop_set, popsize);                                 // objective evaluation of population
                merge(pop_set, archive_set, mixed_set, popsize, archsize);      // combination of parent and offspring
                assign_fitness(mixed_set, popsize + archsize, refdirect_set);   // fitness assignment of the mixed set for environmental selection
                environmental_selection(mixed_set, archive_set, refdirect_set); // environmental selection
                mating_selection(archive_set, pop_set);                         // mating selection and crossover			
                mutation_pop(pop_set);                                          // mutation		

                gen++;
            }
            char logfile[100];
            sprintf(logfile, "%s/lastpop.txt", parName1);
            fpop = fopen(logfile, "w");
            if (fpop == NULL) {
                printf("File could not be opened\n");
                return (0);
            }
            report_objective(archive_set, archsize, fpop);
            fclose(fpop);

            endTime = clock();
            runTime = (double) (endTime - startTime) / CLOCKS_PER_SEC;


            sprintf(logtime, "%s/time.txt", parName1);
            ftime = fopen(logtime, "w+");
            fprintf(ftime, "%e", runTime);
            fclose(ftime);
            fflush(stdout);
        }

        free(min_realvar);
        free(max_realvar);

        deallocate_memory_pop(pop_set, popsize);
        deallocate_memory_pop(archive_set, archsize);
        deallocate_memory_pop(mixed_set, popsize + archsize);
        free(pop_set);
        free(archive_set);
        free(mixed_set);
        free(intercept);
        free(idealpoint);
    }
    return (0);
}
