////////////////////////////////////////////////////////////////////
//////// Copy Right 2009 by H Cheng   //////////////////////////////
////////////////////////////////////////////////////////////////////
#include "mHIGA.h"

GA_Multicast :: GA_Multicast()
{

}
int GA_Multicast :: iRandom(int num)
{
	int temp = rand()%num;
	return temp;
}

double GA_Multicast :: dRandom()
{
	double temp = (double)rand()/(double)RAND_MAX;
	return temp;
}

void GA_Multicast ::Step_Init()
{
	int i,j;
    rateMutation = 0.05;
	rateCrossover = 0.95;
	ratio_eRI_mut = 0.8;
	for(i=0;i<Length;i++)
	{ 
	    for(j=0;j<Length;j++)
	        Connect[i][j] = Cost[i][j] = 0;
	}
	/*for(i=0;i<Node;i++)
	{
	    for(j=0;j<Node;j++)
	    {
	        fin >> Connect[i][j];
	        Connect_backup[i][j]=Connect[i][j];
        }
	}
	for(i=0;i<Node;i++)
	{
	    for(j=0;j<Node;j++)
	    {
	        fin >> Cost[i][j];
	        Cost_backup[i][j]=Cost[i][j];
        }
	}*/
}

void GA_Multicast ::Read_Topo()
{
    int i,j;
    for(i=0;i<Node;i++)
	{
	    for(j=0;j<Node;j++)
	        Connect[i][j]=Connect_backup[i][j];
	}
	for(i=0;i<Node;i++)
	{
	    for(j=0;j<Node;j++)
	        Cost[i][j]=Cost_backup[i][j];
	}
}

///////////////////// Initialization ///////////////////
void GA_Multicast ::Init()
{
	int i,j,r,temp,flag,toponum;
	int total_gen, Num_gen, num_RI, num_eRI;
	
    total_gen = Step*interval_change;
    Count = 0;
    num_RI = (int)Size*ratio_RI;
    num_eRI = (int)Size*ratio_eRI;
    
    for(r=0;r<total_gen;r++)
    {
        treecost[r] = 0.0;
        wholepop_ave[r] = 0.0;
        wholepop_var[r] = 0.0;
    }
    
    for(i=0;i<Repeat;i++)
        for(j=0;j<total_gen;j++)
            costarray[i][j]=0.0;
       
    for(i=0;i<Repeat;i++)
	    fin >> RandomSeed[i];
	    
    fin >> Source;
	//fin >> Destination;
	while(1)
	{
		fin >> temp;
		if(temp != -1)
			Destination.push_back(temp);
		else 
			break;
	}
    
 for(r=0;r<Repeat;r++)
 {
    srand(RandomSeed[r]);                  
    for(Num_gen =0; Num_gen<total_gen; Num_gen++)
	{
		//fout <<"Num_gen:" << Num_gen<<endl;
        if(Num_gen % interval_change == 0)
		{
          for(i=0;i<Length;i++)
		  { 
			  for(j=0;j<Length;j++)
				  Connect[i][j] = Cost[i][j] = 0;
		  }
		  for(i=0;i<Node;i++)
		  {
		      for(j=0;j<Node;j++)
			      fin >> Connect[i][j];
		  }
		  for(i=0;i<Node;i++)
		  {
		      for(j=0;j<Node;j++)
			      fin >> Cost[i][j];
		  }
		  
          if(Num_gen == 0)
          {
             for(i=0;i<Size;i++)
		         Population(i);
	         Fitness_Function();
		     Print(r,Num_gen);
             //Elitism_Select();
          }          
        }
                   
        if(Num_gen>0)
		{          
		   Fitness_Function();
           Print(r,Num_gen);
           
           if(Num_gen%interval_change == 0)
           {
              Repair_Population();              
           }
           else
           {
		      pre_elitism_indi=cur_elitism_indi;
              //Elitism_Select();
              Elitism_Replace();
              Hybrid_Immi(num_RI, num_eRI, ratio_eRI_mut);
           }                         
        }
        Elitism_Select();
        Tournament_Selection();
	    Crossover();
		Mutation();		      	
	}
	fin >> toponum;
    Routing_Init();
 }
 Print_Average(total_gen,1);        
}
//////////////////// Init Population ///////////////////
void GA_Multicast :: Routing_Init()
{
	int i,x,y;
    for(i=0;i<Size;i++)
	{
		Routing[i].PathLength.clear();
		Routing[i].checkedNode.clear();
		for(x=0; x<Node; x++)
			for(y=0; y<Node; y++)
				Routing[i].Temp_chromosome[x][y] = 0;		
	}    
    //for(int i=0;i<Node;i++)
	//	for(int j=0;j<Node;j++)
	//		Temp_Connect[i][j] = Connect[i][j];	
}

void GA_Multicast :: Population(int chromosome_number)
{
	int x,y,j;
    Routing[chromosome_number].PathLength.clear();
	Routing[chromosome_number].checkedNode.clear();
	for(x=0; x<Length; x++)
		for(y=0; y<Length; y++)
			Routing[chromosome_number].Temp_chromosome[x][y] = 0;
			
    for(j=0;j<Destination.size();j++)
		Encoding(chromosome_number,j);	
}

/*void GA_Multicast :: TTemp(int chromosome_number,int num_destination)
{
	for(int i=0;i<Node;i++)
	{
		Routing[chromosome_number].Temp_chromosome[chromosome_number][i] = 0;
		for(int j=0;j<Node;j++)
			Temp_Connect[i][j] = Connect[i][j];
	}
}*/

void GA_Multicast :: Encoding(int chromosome,int num_destination)
{
	int flag;
	int start,temp,locus;
	do
	{
	  //TTemp(chromosome,num_destination);
      start = Source;
	  Temp1.clear();
      Temp2.clear();
	  if(num_destination != 0)
	  {
		 int destination = iRandom(num_destination);
		 int where = iRandom(Routing[chromosome].PathLength[destination]);
		 start = Routing[chromosome].Temp_chromosome[destination][where];
		 for(int i=0;i<where;i++)
			 Temp1.push_back(Routing[chromosome].Temp_chromosome[destination][i]);
      }
	  locus = start;
	  Temp1.push_back(start);
      Temp2.push_back(start);
      Init_Encoding(chromosome,num_destination,start);
      //fout << "\nThe source is "<<start<<endl;
	  for(int i=0;i<Node;i++)
	  {
		  temp = nextLocation(locus);
		  if(temp != -1)
		  {
			 Temp1.push_back(temp);
			 Temp2.push_back(temp);
			 Delete_Path(locus);
			 locus=temp;
		  }
		  if(temp == Destination[num_destination])
		  {
			 //flag = checkDelay(Temp1);
			 //if(flag == 1)
			 //{
			 for(int j=0;j<Temp1.size();j++)
			     Routing[chromosome].Temp_chromosome[num_destination][j] = Temp1[j];
			 for(int j=0;j<Temp2.size();j++)
				 Routing[chromosome].checkedNode.push_back(Temp2[j]);
	         Routing[chromosome].PathLength.push_back(Temp1.size());
			 //}
			 break;
		  }
	  }
    }while(temp != Destination[num_destination]);//while(temp != Destination[num_destination] || flag == -1);
	//Encoding(chromosome,num_destination);
}

void GA_Multicast :: Init_Temp_Matrices()
{
	for(int i=0;i<Node;i++)
		for(int j=0;j<Node;j++)
		{
			Temp_Connect[i][j] = Connect[i][j];
			Temp_Cost[i][j] = Cost[i][j];	
        }
}
//// To remove the overlapping nodes
void GA_Multicast :: Init_Encoding(int chromosome,int num_destination,int start)
{
	Init_Temp_Matrices();
	for(int i=0;i<Destination.size();i++)
	{
		if(start == Destination[i])
			continue;
		if(i != num_destination)
			Delete_Path(Destination[i]);
	}
	for(int i=0;i<Routing[chromosome].checkedNode.size();i++)
	{
		if(start != Routing[chromosome].checkedNode[i])
			Delete_Path(Routing[chromosome].checkedNode[i]);
	}
}

void GA_Multicast :: Delete_Path(int destination)
{
	for(int i=0;i<Node;i++)
	  Temp_Connect[destination][i] = Temp_Connect[i][destination] = 0;
}

//// To find adjancent node 
int GA_Multicast :: nextLocation(int locus)
{
	int location = iRandom(Node);
	if(Temp_Connect[locus][location] == 1)// && Bandwidth[locus][location] >= bandwidthBound)
		return location;
	else
		return -1;
}

///////////////// Fitness_Function /////////////////////
void GA_Multicast :: Fitness_Function()
{	
	//int count;//ul
	double whole_cost, temp_path_cost, path_cost;// temp_delay_cost, delay_cost, maxdelay;
	
    for(int i=0;i<Size;i++)
	{
		Init_Temp_Matrices();
		Routing[i].fitness = path_cost = 0.0;
		//count=0;
		for(int d=0;d<Destination.size();d++)
		{
			//delay_count= 0;
			temp_path_cost= 0.0;
			for(int j=1;j<Routing[i].PathLength[d];j++)
			{
				//if(Temp_Connect[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]] == 1)
				//{
					//count++; 
					//// Cost
					temp_path_cost += Temp_Cost[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]];
					Temp_Cost[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]]=0;
					Temp_Cost[Routing[i].Temp_chromosome[d][j]][Routing[i].Temp_chromosome[d][j-1]]=0;
					//// Delay
					//temp_delay_cost += Temp_Delay[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]];
					//Temp_Delay[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]]=0.0;
					//Temp_Delay[Routing[i].Temp_chromosome[d][j]][Routing[i].Temp_chromosome[d][j-1]]=0.0;
				//}
				//temp_delay_cost += Temp_Delay[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]];
			}
			//if(temp_delay_cost>maxdelay)
			//   maxdelay=temp_delay_cost;
			path_cost += temp_path_cost;
			//delay_cost += temp_delay_cost;
		}
		Routing[i].fitness += 1/path_cost;		
	}	
}

//// Part of Selection (i.e., Tournament Selection)
void GA_Multicast :: Tournament_Selection()
{
	for(int i=0;i<Size;i++)
	{
		int temp = iRandom(Size);
		chromosomeExchange(i,temp);
	}
}

void GA_Multicast :: chromosomeExchange(int first,int second)
{
	if(Routing[first].fitness <= Routing[second].fitness)
	  Routing[first] = Routing[second];
	else
	  Routing[second] = Routing[first];
}

//// Before Crossover, Mixing Chromosomes
void GA_Multicast :: Shuffle()
{
	int first,second;
	for(int i=0;i<Size;i++)
	{
		first=iRandom(Size); 
        second=iRandom(Size);
		Mix(first,second);
	}
}
void GA_Multicast :: Mix(int first,int second)
{
	Routing[Size] = Routing[first];
	Routing[first] = Routing[second];
	Routing[second] = Routing[Size];
}

//// Part of Crossover 
void GA_Multicast :: Init_Crossover()
{
	Shuffle();
	for(int i=0;i<Size/2;i++)
	{
	  if(Check_Crossover() == 1)
		  Run_Crossover(i,Size/2+i);
    }
}
void GA_Multicast :: Run_Crossover(int first,int second)
{
	int gene;
    for(int dest=0; dest<Destination.size(); dest++)
	{
	    X.clear();
        Y.clear();
		for(int x=0;x<Routing[first].PathLength[dest]-1;x++)
		{
			for(int y=0;y<Routing[second].PathLength[dest]-1;y++)
			{
				if(Routing[first].Temp_chromosome[dest][x] == Routing[second].Temp_chromosome[dest][y])
				{
					X.push_back(x);
                    Y.push_back(y);
				}
			}
		}
		if(X.size()>0)
		{
		   gene = iRandom(X.size());
		   Exchange_subtree(first,second, X[gene], Y[gene],dest);
        }
	}
}
void GA_Multicast :: Exchange_subtree(int first,int second,int crosspoint1,int crosspoint2,int dest)
{
	int flag;
	Temp1.clear();
	Temp2.clear();
	//// Father 
	for(int i=0; i<=crosspoint1; i++)
		Temp1.push_back(Routing[first].Temp_chromosome[dest][i]);
	for(int i=crosspoint2+1; i<Routing[second].PathLength[dest]; i++)
		Temp1.push_back(Routing[second].Temp_chromosome[dest][i]);
	//// Mother
	for(int i=0; i<=crosspoint2; i++)
		Temp2.push_back(Routing[second].Temp_chromosome[dest][i]);
	for(int i=crosspoint1+1; i<Routing[first].PathLength[dest]; i++)
		Temp2.push_back(Routing[first].Temp_chromosome[dest][i]);
	//if(checkDelay(Temp1) == 1)
	//{
		for(int i=0;i<Temp1.size();i++)
			Routing[first].Temp_chromosome[dest][i] = Temp1[i];
		Routing[first].PathLength[dest]=Temp1.size();
	//}
	//if(checkDelay(Temp2) == 1)
	//{
		for(int i=0;i<Temp2.size();i++)
			Routing[second].Temp_chromosome[dest][i] = Temp2[i];
		Routing[second].PathLength[dest]=Temp2.size();
	//}
}
int GA_Multicast :: Check_Crossover()
{
	double rate = dRandom();
	if(rate <= rateCrossover)
		return 1;
	else
		return -1;
}

//// Part of Repair Function
//// To remove infeasible chromosome (loop) and Recombination of Chromosome
void GA_Multicast :: Repair_Function()
{
	Temp1.clear();
	int i,front,rear;
	int flag;
	for(i=0; i<Size; i++)
	{
		flag = 0;
		for(front=0; front<Routing[i].PathLength[0]; front++)
		{
			for(rear=Routing[i].PathLength[0]-1; rear>front; rear--)
			{
				if(Routing[i].Temp_chromosome[0][front] == Routing[i].Temp_chromosome[0][rear])
				{
					flag = 1;
					break;
				}
			}
			if(flag == 1)
			{
				for(int a=0; a<=front; a++)
					Temp1.push_back(Routing[i].Temp_chromosome[0][a]);
				for(int a=rear+1; a<Routing[i].PathLength[0]; a++)
					Temp1.push_back(Routing[i].Temp_chromosome[0][a]);
				for(int a=0;a<Temp1.size();a++)
					Routing[i].Temp_chromosome[0][a] = Temp1[a];
				Routing[i].PathLength[0] = Temp1.size();
				break;
			}
		}
		for(int dest=1; dest<Destination.size(); dest++)
			Check_Recombination(i,dest);
	  Check_Path(i);
	}
}

void GA_Multicast :: Crossover()
{
     Init_Crossover();
	 Repair_Function(); 
}

void GA_Multicast :: Check_Recombination(int chromosome, int num_destination)
{
	int i,first,second,flag;
	for(second=Routing[chromosome].PathLength[num_destination]-2; second >= 0 ; second--)
	{
		flag=0;
		for(i=0;i<num_destination;i++)
		{
			for(first=0; first <Routing[chromosome].PathLength[i]; first++)
			{
				if(Routing[chromosome].Temp_chromosome[i][first]==Routing[chromosome].Temp_chromosome[num_destination][second])
				{
					flag = -1;
					break;
				}
			}
			if(flag == -1)
				break;
		}
		if(flag == -1)
		{
			Run_Recombination(chromosome,i,num_destination,first,second);
			break;
		}
	}
}
void GA_Multicast :: Run_Recombination(int chromosome,int before,int next,int first,int second)
{
	Temp1.clear();
	for(int i=0; i<=first;i++)
		Temp1.push_back(Routing[chromosome].Temp_chromosome[before][i]);
	for(int i=second+1; i<Routing[chromosome].PathLength[next];i++)
		Temp1.push_back(Routing[chromosome].Temp_chromosome[next][i]);
	for(int i=0;i<Temp1.size();i++)
		Routing[chromosome].Temp_chromosome[next][i] = Temp1[i];
	Routing[chromosome].PathLength[next] = Temp1.size();
}
void GA_Multicast :: Check_Path(int chromosome)
{
	Init_Temp_Matrices();
	Temp1.clear();
	for(int i=0;i<Destination.size();i++)
	{
		for(int j=1;j<Routing[chromosome].PathLength[i];j++)
		{
			if(Temp_Connect[Routing[chromosome].Temp_chromosome[i][j-1]][Routing[chromosome].Temp_chromosome[i][j]]== 1)
			{
				Temp1.push_back(Routing[chromosome].Temp_chromosome[i][j-1]);
				Temp1.push_back(Routing[chromosome].Temp_chromosome[i][j]);
				Temp_Connect[Routing[chromosome].Temp_chromosome[i][j-1]][Routing[chromosome].Temp_chromosome[i][j]]= 0;
				Temp_Connect[Routing[chromosome].Temp_chromosome[i][j]][Routing[chromosome].Temp_chromosome[i][j-1]]= 0;
			}
		}
	}
	Routing[chromosome].checkedNode = Temp1;
}

//// Part of Mutation
void GA_Multicast :: Mutation()
{
	int mutation_destination,mutation_point;
	for(int i=0;i<Size;i++)
	{
		Init_Temp_Matrices();
		if(dRandom() <= rateMutation)
		{
			Count=0;
			mutation_destination = iRandom(Destination.size());
			mutation_point = iRandom(Routing[i].PathLength[mutation_destination]);
			Run_Mutation(i,mutation_destination,mutation_point);
		}
	}
}
void GA_Multicast :: Run_Mutation(int chromosome,int mutation_destination,int mutation_point)
{
	Temp1.clear();
	int flag=0;
	int temp, locus, start;
	for(int mutation=0; mutation<=mutation_point; mutation++)
		Temp1.push_back(Routing[chromosome].Temp_chromosome[mutation_destination][mutation]);
	locus = start = Routing[chromosome].Temp_chromosome[mutation_destination][mutation_point];
	Mutation_Encoding(chromosome,mutation_destination,locus);
	for(int i=0;i<Node/2;i++)
	{
		temp = nextLocation(locus);
		if(temp != -1)
		{
			Temp1.push_back(temp);
			Delete_Path(locus);
			locus=temp;
		}
		if(temp == Destination[mutation_destination])// && checkDelay(Temp1) == 1)
		{
			for(int j=0;j<Temp1.size();j++)
				Routing[chromosome].Temp_chromosome[mutation_destination][j] = Temp1[j];
			Routing[chromosome].PathLength[mutation_destination] = Temp1.size();
			flag = 1;
			break;
		}
	}
	if(Count != Node/10 && flag != 1)
	{
		Count++;
		Run_Mutation(chromosome,mutation_destination,mutation_point);
	}
}

void GA_Multicast :: Mutation_Encoding(int chromosome,int dest,int start)
{
    Init_Temp_Matrices();
	for(int i=0;i<Routing[chromosome].checkedNode.size();i++)
	{
		if(Destination[dest] != Routing[chromosome].checkedNode[i] && start != Routing[chromosome].checkedNode[i])
		  Delete_Path(Routing[chromosome].checkedNode[i]);
	}
}
////////////// Detect Convergence ///////////
int GA_Multicast ::Convergence()
{
	int flag=0;
	Fitness_Function();
	Tournament_Selection();
	for(int i=1;i<Size;i++)
	{
		if(Routing[0].fitness != Routing[i].fitness) 
		{
		   flag++;
		   break;
		}
	}
	if(flag != 0)
	{
		Crossover();
		//Recovery();
		Mutation();
	}
	return flag;
}
////////////// Print Shortest Path /////////////
/*void GA_Multicast :: Print(int num_gen)
{ 
	int i;
    double temp=0.0;
	Routing[MAX]=Routing[0];
	for(int i=1;i<Size;i++)
	{
		if(Routing[i].fitness > Routing[MAX].fitness) 
		   Routing[MAX]=Routing[i];
	}	
	temp+=1.0/Routing[MAX].fitness;
	//fout << temp <<" ";
	treecost[num_gen]+=temp;
}
//////////////// Print Average Value ////////////
void GA_Multicast :: Print_Average(int total_gen_num,int mode)
{
   double temp=0.0;
   int j=0;
   for(int i=0;i<total_gen_num;i++)
   {
       if(i % mode ==0)
       {
          temp=treecost[i]/Repeat;
          fout << temp <<" ";  
          j++; 
          if(j % 100 ==0)                  
             fout << endl;  
       }       
   }
}*/
////////////// Print Shortest Path /////////////
void GA_Multicast :: Print(int repe, int num_gen)
{ 
	int i;
    double temp=0.0,wholepop_cost[100], totalpop_cost=0.0, totalpop_variance_sum=0.0;//popsize: 100
	Routing[MAX]=Routing[0];
	for(i=1;i<Size;i++)
	{
		if(Routing[i].fitness > Routing[MAX].fitness) 
		   Routing[MAX]=Routing[i];
	}	
	temp+=1.0/Routing[MAX].fitness;
	//fout << temp <<" ";
	treecost[num_gen]+=temp;
	costarray[repe][num_gen]=temp;
	if(repe==0)
	{
	   for(i=0;i<Size;i++)
	   {
		   wholepop_cost[i]=1.0/Routing[i].fitness;
		   totalpop_cost+=wholepop_cost[i];
	   }
	   wholepop_ave[num_gen]=totalpop_cost/Size;
	   for(i=0;i<Size;i++)
	       totalpop_variance_sum+=(wholepop_cost[i]-wholepop_ave[num_gen])*(wholepop_cost[i]-wholepop_ave[num_gen]);
       wholepop_var[num_gen]=totalpop_variance_sum/Size;    
    }	
}
//////////////// Print Average Value ////////////
void GA_Multicast :: Print_Average(int total_gen_num, int mode)
{
   double temp=0.0,totalcost[10],meanvalue[10],variance[10],variance_sum[10];//Repeat=10
   int i,j=0,num_count;
   for(i=0;i<10;i++)
   {
       totalcost[i]=0.0;
       variance_sum[i]=0.0;  
   }
   for(i=0;i<total_gen_num;i++)
   {
       if(i % mode ==0)
       {
          temp=treecost[i]/Repeat;
          fout << temp <<" ";  
          j++; 
          if(j % 100 ==0)                  
             fout << endl;  
       }       
   }
   /*fout<<"tree cost array"<<endl;
   for(i=0;i<Repeat;i++)
   {
       for(j=0;j<total_gen_num;j++)
            fout << costarray[i][j] <<" "; 
       fout<<endl;
   }*/
   fout<<endl;
   //output the mean value and variance
   for(i=0;i<Repeat;i++)
   {
       num_count=0;
       for(j=0;j<total_gen_num;j++)
       {
          totalcost[i]+=costarray[i][j];     
          num_count++;      
          if(j>0&&j%interval_change==0)
          {
             totalcost[i]-=costarray[i][j]; 
             num_count--;
          }
       }
       meanvalue[i]=totalcost[i]/num_count;
       for(j=0;j<total_gen_num;j++)
       {
          variance_sum[i]+=(costarray[i][j]-meanvalue[i])*(costarray[i][j]-meanvalue[i]);
          if(j>0&&j%interval_change==0)
             variance_sum[i]-=(costarray[i][j]-meanvalue[i])*(costarray[i][j]-meanvalue[i]);                          
       }
       variance[i]=variance_sum[i]/num_count;
   }     
   fout<<"num_count: "<<num_count<<endl;
   fout<<"mean values:"<<endl;
   for(i=0;i<Repeat;i++)
       fout << meanvalue[i] <<" ";
   fout<<endl;
   fout<<"variance:"<<endl;
   for(i=0;i<Repeat;i++)
       fout << variance[i] <<" ";      
   fout<<endl;
   fout<<"whole pop average at the first time run"<<endl;
   for(i=0;i<total_gen_num;i++)
   {
       if(i % 100 ==0)                  
          fout << endl;
       fout<<wholepop_ave[i]<<" ";
   }
   fout<<endl;
   fout<<"whole pop variance at the first time run"<<endl;
   for(i=0;i<total_gen_num;i++)
   {
       if(i % 100 ==0)                  
          fout << endl;
       fout<<wholepop_var[i]<<" ";
   }
   fout<<endl;         
}
////////////Radnom Immigrants/////////////
/*void GA_Multicast :: Random_Immi(int numRI)
{
     int worst_id;
     double worst_chromo_fitness[2*MAX];
     for(int j=0;j<Size;j++)
         worst_chromo_fitness[j]=Routing[j].fitness;
     
     for(int i=0;i<numRI;i++)
     {      
         worst_chromo_fitness[MAX]=worst_chromo_fitness[0];
         worst_id=0;
         for(int j=1;j<Size;j++)
         {
             if(worst_chromo_fitness[j]<worst_chromo_fitness[MAX])
             {
                worst_chromo_fitness[MAX]=worst_chromo_fitness[j];
                worst_id=j;                                                       
             }
         }
         worst_chromo_fitness[worst_id]=100.0;
         Population(worst_id); //replace the worst one with a RI 
         //Routing[word_id]=Routing[Size];
         //fout << "worst_id is:" <<worst_id<<endl;
         Fitness_Individual(worst_id); 
         //fout <<"RI";               
     }
}*/
////////////Hybrid Immigrants/////////////
void GA_Multicast :: Hybrid_Immi(int numRI, int numeRI, double eri_mut_ratio)
{
     int worst_id;
     double worst_chromo_fitness[2*MAX];
     double rate=0.0;  //for elitism-based mutation
     int mutation_destination,mutation_point; //for elitism-based mutation
     
     for(int j=0;j<Size;j++)
         worst_chromo_fitness[j]=Routing[j].fitness;
     
     //elitism-based immigrants
     for(int i=0;i<numeRI;i++)
     {      
         worst_chromo_fitness[MAX]=worst_chromo_fitness[0];
         worst_id=0;
         for(int j=1;j<Size;j++)
         {
             if(worst_chromo_fitness[j]<worst_chromo_fitness[MAX])
             {
                worst_chromo_fitness[MAX]=worst_chromo_fitness[j];
                worst_id=j;                                                       
             }
         }
         worst_chromo_fitness[worst_id]=100.0;
         
         //generate the elitism-based random immigrant
         Routing[MAX]=pre_elitism_indi;	     
         rate = dRandom();
	     if(rate <= eri_mut_ratio)
	     {
			Check_Path(MAX);
            Mutation_Individual(MAX);					
		 }
		 Routing[worst_id]=Routing[MAX];
         Fitness_Individual(worst_id);
	 }
	 
     //random immigrants
	 for(int i=0;i<numRI;i++)
     {      
         worst_chromo_fitness[MAX]=worst_chromo_fitness[0];
         worst_id=0;
         for(int j=1;j<Size;j++)
         {
             if(worst_chromo_fitness[j]<worst_chromo_fitness[MAX])
             {
                worst_chromo_fitness[MAX]=worst_chromo_fitness[j];
                worst_id=j;                                                       
             }
         }
         worst_chromo_fitness[worst_id]=100.0;
         Population(worst_id); //replace the worst one with a RI 
         //Routing[word_id]=Routing[Size];
         //fout << "worst_id is:" <<worst_id<<endl;
         Fitness_Individual(worst_id); 
         //fout <<"RI";               
     }
}

////////////////////Repair Population by Random Immigrants////////
void GA_Multicast :: Repair_Population()
{
    int i;
    for(i=0;i<Size;i++)
    {
		if(BrokenLinkExist(i))
           Repair_InfeasibleIndividual(i);
    } 
}

bool GA_Multicast :: BrokenLinkExist(int chromosome)
{
    int i,j;
    for(i=0;i<Destination.size();i++)
	{
		for(j=1;j<Routing[chromosome].PathLength[i];j++)
		    if(Connect[Routing[chromosome].Temp_chromosome[i][j-1]][Routing[chromosome].Temp_chromosome[i][j]] == 0)
		       return true;
    }     
    return false;
}

void GA_Multicast :: Repair_InfeasibleIndividual(int chromosome)
{
    Population(chromosome);
    Fitness_Individual(chromosome); 
}

////////////////InChromosome/////
bool GA_Multicast :: InChromosome(int chromosome, int node, int *i1, int *j1)
{
    int i,j;
    for(i=0;i<Destination.size();i++)
	    for(j=0;j<Routing[chromosome].PathLength[i];j++)
	    {
	        if(Routing[chromosome].Temp_chromosome[i][j]==node)
	        {
	           *i1=i;
	           *j1=j;
               return true;
            }
        }
    return false;
}
//////////////////////////////////
void GA_Multicast :: Mutation_Individual(int chromosome)
{
    int mutation_destination,mutation_point;
	Init_Temp_Matrices();
	if(dRandom() <= rateMutation)
	{
		//Check_Path(chromosome);
        Count=0;
		mutation_destination = iRandom(Destination.size());
		mutation_point = iRandom(Routing[chromosome].PathLength[mutation_destination]);
		Run_Mutation(chromosome,mutation_destination,mutation_point);
	}	
}
/////////// Fitness_Individual //////
void GA_Multicast :: Fitness_Individual(int i)
{
	double path_cost;        
    Init_Temp_Matrices();
	Routing[i].fitness = path_cost = 0.0;
	
	for(int d=0;d<Destination.size();d++)
	{
		for(int j=1;j<Routing[i].PathLength[d];j++)
		{
			if(Temp_Connect[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]] == 1)
			{
			   path_cost += Temp_Cost[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]];
			   Temp_Cost[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]]=0;
			   Temp_Cost[Routing[i].Temp_chromosome[d][j]][Routing[i].Temp_chromosome[d][j-1]]=0;
			}
		}
    }
	Routing[i].fitness += 1/path_cost;
}
//////////// Elitism Select /////////////
void GA_Multicast :: Elitism_Select()
{
     int best_id;
     double best_chromo_fitness[2*MAX];
          
     for(int j=0;j<Size;j++)
         best_chromo_fitness[j]=Routing[j].fitness;
     
     //first find the elitism
     best_chromo_fitness[MAX]=best_chromo_fitness[0];
     best_id=0;
     for(int j=1;j<Size;j++)
     {
         if(best_chromo_fitness[j]>best_chromo_fitness[MAX])
         {
            best_chromo_fitness[MAX]=best_chromo_fitness[j];
            best_id=j;                                                       
         }
     }
     cur_elitism_indi=Routing[best_id];   //elitism
     //pre_elitism_indi=cur_elitism_indi;     
}
//////////// Elitism Replace /////////////
void GA_Multicast :: Elitism_Replace()
{
     int worst_id;
     double worst_chromo_fitness[2*MAX];
          
     for(int j=0;j<Size;j++)
         worst_chromo_fitness[j]=Routing[j].fitness;
     
     worst_chromo_fitness[MAX]=worst_chromo_fitness[0];
     worst_id=0;
     for(int j=1;j<Size;j++)
     {
         if(worst_chromo_fitness[j]<worst_chromo_fitness[MAX])
         {
            worst_chromo_fitness[MAX]=worst_chromo_fitness[j];
            worst_id=j;                                                       
         }
     }
     Routing[worst_id]=pre_elitism_indi;
     Fitness_Individual(worst_id);	 
}

void GA_Multicast :: GenNewTopo()
{
     int NodesChanged[MAX],DesNumVisited[MAX],i,j,num_destination,where,NodeSelected;
     int NextNode[MAX],nextnode_onpath;
     bool des_visited,node_visited;    
     //int MaxNodeNumPerChange=Destination.size();
     for(i=0;i<LinkNumPerChange;i++)
     {
         NodesChanged[i]=-1;
         DesNumVisited[i]=-1;                           
     }
     for(i=0;i<LinkNumPerChange;i++)
     {
         do
         {
           do
           {
              num_destination = iRandom(Destination.size());
              des_visited=false;
              for(j=0;j<i;j++)
              {
                  if(num_destination==DesNumVisited[j])
                  {
                     des_visited=true;
                     break;
                  }
              }
           }while(des_visited==true);
           DesNumVisited[i]=num_destination;
           //do
           //{
             where = iRandom(cur_elitism_indi.PathLength[num_destination]-1);
           //}while(where==0);
	       NodeSelected = cur_elitism_indi.Temp_chromosome[num_destination][where];
           nextnode_onpath = cur_elitism_indi.Temp_chromosome[num_destination][where+1];
	       node_visited=false;
	       for(j=0;j<i;j++)
	       {
               if(NodeSelected==NodesChanged[j])
               {
                  node_visited=true;
                  break;
               }
           }
         }while(node_visited==true);
         NodesChanged[i]=NodeSelected;
         NextNode[i]=nextnode_onpath;
     }
     for(i=0;i<LinkNumPerChange;i++)
	 {
         Connect[NodesChanged[i]][NextNode[i]]=0;
         Cost[NodesChanged[i]][NextNode[i]]=500;
         Connect[NextNode[i]][NodesChanged[i]]=0;
         Cost[NextNode[i]][NodesChanged[i]]=500;                            
     }         
}
//////////  Initial Step /////////////////
/*void GA_Multicast ::Routing_Init()
{
	for(int i=0;i<Size*2;i++)
	{
		Routing[i].size = 0;
		Routing[i].fitness = 0.0;
		for(int j=0;j<Length;j++)
			Routing[i].chromosome[j] = 0;
	}
}*/

/////// Main ////////
int main(int argc, char *argv[])
{
	int flag;
    int i,j;
	//srand(time(0));
	
	char *inputfile;
    char *outputfile = new char[60];
    
	WhichTopo = atoi(argv[1]);
    Size = atoi(argv[2]);
    Node = atoi(argv[3]);
    interval_change = atoi(argv[4]);
    Step = atoi(argv[5]);
    Repeat = atoi(argv[6]);
    ratio_RI = atof(argv[7]);
    ratio_eRI = atof(argv[8]);
    //LinkNumPerChange = atoi(argv[8]);
    
    /*if(WhichTopo == 0)
    { 
       inputfile="TopoWithChange0.in";
       sprintf(outputfile, "RIGA_CyNPC2_P%d_I%d_TN%d_RRI%4.2f.out", Size, interval_change, Step, ratio_RI);
    }    
    else
    {*/
       if(WhichTopo == 2)
          inputfile="TopoWithChange2.in";
       if(WhichTopo == 3)
          inputfile="TopoWithChange3.in";
       if(WhichTopo == 4)
          inputfile="TopoWithChange4.in";
       sprintf(outputfile, "mHIGA_NPC%d_P%d_I%d_TN%d.out", WhichTopo, Size, interval_change, Step);
    //}*/
    //inputfile="InitTopo.in";
    //sprintf(outputfile, "mHIGA_NPC%d_P%d_I%d_TN%d_RRI%4.2f__ReRI%4.2f.out", LinkNumPerChange, Size, interval_change, Step, ratio_RI, ratio_eRI);
    fin.open(inputfile);    
    fout.open(outputfile,ios::out); 
	
	GA_Multicast gam;  
	gam.Step_Init();
	gam.Init();
	
	fin.close();
    fout.close();
	return 0;
}
