#ifndef __COMMON_H_
#define __COMMON_H_
#include <algorithm>

double distanceArray(double vec1[], double vec2[], int dim)
{
    double sum = 0;
	for(int n=0; n<dim; n++)
	    sum+= (vec1[n] - vec2[n])*(vec1[n] - vec2[n]);
	return sqrt(sum);
}

double distanceVector(vector <double> &vec1, vector <double> &vec2)
{
    double sum = 0;
	for(int n=0; n<vec1.size(); n++)
	    sum+=(vec1[n] - vec2[n])*(vec1[n] - vec2[n]);
	return sqrt(sum);
}

double SafeAcos(double x)
{
	if (x < -1.0) x = -1.0;
	else if (x > 1.0) x = 1.0;
	return acos(x);
}

double norm_vector(vector <double> &x)
{
	double sum = 0;
	for(int i=0;i<x.size();i++)
        sum = sum + x[i]*x[i];
    return sqrt(sum);
}

double sum_vector(vector<double>&vec)
{
	double sum = 0;
	for(int i=0;i<vec.size();i++)
        sum = sum + vec[i];
    return sum;
}

double innerproduct(vector <double>&vec1, vector <double>&vec2)
{
    double sum = 0;
	for(int i=0; i<vec1.size(); i++)
		sum+= vec1[i]*vec2[i];
	return sum;
}

double angleVector(vector <double> &vec1, vector <double> &vec2)
{
	double above = innerproduct(vec1, vec2);
	double below = norm_vector(vec1)*norm_vector(vec2);
	double value = SafeAcos(above / below);
	return value;
}

void minfastsort(double x[], int idx[], int n, int m)
{
    for(int i=0; i<m; i++)
	{
	    for(int j=i+1; j<n; j++)
			if(x[i]>x[j])
			{
			    double temp = x[i];
				x[i]        = x[j];
				x[j]        = temp;
				int id      = idx[i];
				idx[i]      = idx[j];
				idx[j]      = id;
			}
	}
}

void random_permutation(int *perm, int size)
{
	int *index = new int[size];
	bool *flag = new bool[size];
	for (int n = 0; n<size; n++)  {
		index[n] = n;
		flag[n] = true;
	}

	int num = 0;
	while (num<size){
		int start = int(size*rnd_uni(&rnd_uni_init));
		while (1){
			if (flag[start]){
				perm[num] = index[start];
				flag[start] = false;
				num++;
				break;
			}
			if (start == (size - 1))
				start = 0;
			else
				start++;
		}
	}

	delete[] index;
	delete[] flag;

}
#endif