#ifndef __SCALARFUNC_H_
#define __SCALARFUNC_H_

#include "global.h"
#include "individual.h"


// scalarizing functions for decomposition methods
double scalar_func(vector <double> &y_obj, vector <double> &namda, TIndividual* nbi_node)
{

	double fvalue = 0;
    
	// Tchebycheff approach
	if(!strcmp(strFunctionType,"_TCH1"))
	{
		double max_fun = -1.0e+30;
		for(int n=0; n<numObjectives; n++)
		{
			double diff = fabs(y_obj[n] - idealpoint[n] );
			double feval;
			if(namda[n]==0) 
				feval = diff/1.0e-6;
			else
			    feval = diff/namda[n];
			if(feval>max_fun) max_fun = feval;

		}
		
		fvalue = max_fun;
	}

	// normalized Tchebycheff approach
	if(!strcmp(strFunctionType,"_TCH2"))
	{
		vector <double> scale;
		for(int i=0; i<numObjectives; i++)
		{
			double min = 1.0e+30, max = -1.0e+30;
			for(int j=0; j<numObjectives; j++)
			{
				double tp = nbi_node[j].y_obj[i];
				if(tp>max) max = tp;
				if(tp<min) min = tp;
			}
			scale.push_back(max-min);
			if(max-min==0) return 1.0e+30;
		}

		double max_fun = -1.0e+30;
		for(int n=0; n<numObjectives; n++)
		{
			double diff = (y_obj[n] - idealpoint[n])/scale[n];
			double feval;
			if(namda[n]==0) 
				feval = 0.0001*diff;
			else
			    feval = diff*namda[n];
			if(feval>max_fun) max_fun = feval;

		}
		fvalue = max_fun;
	}


	//* Boundary intersection approach
	if(!strcmp(strFunctionType,"_PBI"))
	{

		// normalize the weight vector (line segment)
		double nd = norm_vector(namda);
		for(int i=0; i<numObjectives; i++)
			namda[i] = namda[i]/nd;

		vector <double> realA(numObjectives);
		vector <double> realB(numObjectives);

		// difference beween current point and reference point
		for (int n = 0; n < numObjectives; n++)
			realA[n] = (y_obj[n] - idealpoint[n]);// (nadir[n] - idealpoint[n]);

		// distance along the line segment
		double d1 = fabs(innerproduct(realA,namda));

		double m1 = 1.0e+30, m2 = -1.0e+30;
		// distance to the line segment
		for (int n = 0; n<numObjectives; n++)
		{
			realB[n] = (realA[n] - d1*namda[n]);
			if (namda[n]<m1) m1 = namda[n];
			if (namda[n]>m2) m2 = namda[n];
		}
		double d2 = norm_vector(realB);
		double t = 5.0; 
		//exp(4 * (m2 - m1));
		//t=1.0+9.0*itt/max_gen;

		fvalue = d1 + t*d2;

	}

	return fvalue;
}

// scalarizing functions for decomposition methods
double scalar_func1(vector <double> &y_obj, vector <double> &namda, TIndividual* nbi_node)
{

	double fvalue = 0;

	// Tchebycheff approach
	if (!strcmp(strFunctionType, "_MTCH1"))
	{
		double eps = 1.0e-6;
		if (numObjectives > 2) eps = 1.0e-3;

		double max_fun = -1.0e+30;
		for (int n = 0; n<numObjectives; n++)
		{
			double diff = fabs(y_obj[n]);
			double feval;
			if (namda[n] == 0)
				feval = diff / 1.0e-6;
			else
				feval = diff / namda[n];
			if (feval>max_fun) max_fun = feval;

		}

		fvalue = max_fun;
	}

	// normalized Tchebycheff approach
	if (!strcmp(strFunctionType, "_TCH2"))
	{
		vector <double> scale;
		for (int i = 0; i<numObjectives; i++)
		{
			double min = 1.0e+30, max = -1.0e+30;
			for (int j = 0; j<numObjectives; j++)
			{
				double tp = nbi_node[j].y_obj[i];
				if (tp>max) max = tp;
				if (tp<min) min = tp;
			}
			scale.push_back(max - min);
			if (max - min == 0) return 1.0e+30;
		}

		double max_fun = -1.0e+30;
		for (int n = 0; n<numObjectives; n++)
		{
			double diff = (y_obj[n] - idealpoint[n]) / scale[n];
			double feval;
			if (namda[n] == 0)
				feval = 0.0001*diff;
			else
				feval = diff*namda[n];
			if (feval>max_fun) max_fun = feval;

		}
		fvalue = max_fun;
	}


	//* Boundary intersection approach
	if (!strcmp(strFunctionType, "_PBI"))
	{

		// normalize the weight vector (line segment)
		double nd = norm_vector(namda);
		for (int i = 0; i<numObjectives; i++)
			namda[i] = namda[i] / nd;

		vector <double> realA(numObjectives);
		vector <double> realB(numObjectives);

		// difference beween current point and reference point
		for (int n = 0; n < numObjectives; n++)
			realA[n] = (y_obj[n] - idealpoint[n]);// (nadir[n] - idealpoint[n]);

		// distance along the line segment
		double d1 = fabs(innerproduct(realA, namda));

		double m1 = 1.0e+30, m2 = -1.0e+30;
		// distance to the line segment
		for (int n = 0; n<numObjectives; n++)
		{
			realB[n] = (realA[n] - d1*namda[n]);
			if (namda[n]<m1) m1 = namda[n];
			if (namda[n]>m2) m2 = namda[n];
		}
		double d2 = norm_vector(realB);
		double t = 5.0;
		//exp(4 * (m2 - m1));
		//t=1.0+9.0*itt/max_gen;

		fvalue = d1 + t*d2;

	}

	return fvalue;
}


// scalarizing functions for decomposition methods
double scalar_func2(vector <double> &y_obj, vector <double> &namda, double penaty, TIndividual* nbi_node)
{

	double fvalue = 0;

	// Tchebycheff approach
	if (!strcmp(strFunctionType, "_MSF"))
	{
		double max_fun = -1.0e+30, min_fun=1.0e+30;
		double au = 1, wmax=-1.0e+30, wmin=1.0e+30;
		double eps = 1.0e-6;
		if (numObjectives > 2) eps = 1.0e-3;
		for (int n = 0; n<numObjectives; n++)
		{
			double diff = fabs(y_obj[n]);
			double feval;
			if (namda[n] == 0)
			{
				feval = (diff) / eps;
			}
			else
				feval = (diff) / namda[n];
			if (feval>max_fun) max_fun = feval;
			if (feval<min_fun) min_fun = feval;
			if (namda[n]>wmax) wmax = namda[n];
			if (namda[n] < wmin) wmin = namda[n];
		}
		au = numObjectives * wmin;

		penaty = (1.0 - 1.0*gen / max_gen);
		fvalue = pow(max_fun / min_fun, alpha*au*penaty)*max_fun;
	}

	// Tchebycheff approach
	if (!strcmp(strFunctionType, "_PSF"))
	{
		double max_fun = -1.0e+30, min_fun = 1.0e+30;
		double au = 1, wmax = -1.0e+30, wmin = 1.0e+30;
		double eps = 1.0e-6;
		//if (numObjectives > 2) eps = 1.0e-3;
		for (int n = 0; n<numObjectives; n++)
		{
			double diff = fabs(y_obj[n] - idealpoint[n]) ;
			double feval;
			if (namda[n] == 0)
			{
				feval = (diff ) / eps;
			}
			else
				feval = (diff) / namda[n];
			if (feval>max_fun) max_fun = feval;
			if (feval<min_fun) min_fun = feval;
			if (namda[n]>wmax) wmax = namda[n];
			if (namda[n] < wmin) wmin = namda[n];
		}

		// normalize the weight vector (line segment)
		double nd = norm_vector(namda);

		vector <double> realA(numObjectives);

		// difference beween current point and reference point
		for (int n = 0; n < numObjectives; n++)
			realA[n] = (y_obj[n] - idealpoint[n]);

		double A1 = norm_vector(realA);
		double AB = fabs(innerproduct(realA, namda));
		double d2 = pow(A1, 2.0) - pow(AB, 2.0) / pow(nd, 2.0);;
		d2 = pow(d2, 0.5);

		au = numObjectives * wmin;
		penaty = (1.0 - 1.0*gen / max_gen);
		fvalue =max_fun+10.0*au*penaty*d2;
	}
	
	// weighted sum approach
	if (!strcmp(strFunctionType, "_SUM"))
	{
		fvalue = 0;
		for (int n = 0; n<numObjectives; n++)
		{
			double diff = fabs(y_obj[n] - idealpoint[n]);
			double feval;
			if (namda[n] == 0)
			{
				feval = (diff + 1.0e-2) / 1.0e-2;
			}
			else
				feval = (diff + 1.0e-3) / namda[n];
			fvalue +=pow(feval,3.0);
		}
		fvalue = pow(fvalue, 1.0/3);
	}

	// normalized Tchebycheff approach
	if (!strcmp(strFunctionType, "_TCH2"))
	{
		vector <double> scale;
		for (int i = 0; i<numObjectives; i++)
		{
			double min = 1.0e+30, max = -1.0e+30;
			for (int j = 0; j<numObjectives; j++)
			{
				double tp = nbi_node[j].y_obj[i];
				if (tp>max) max = tp;
				if (tp<min) min = tp;
			}
			scale.push_back(max - min);
			if (max - min == 0) return 1.0e+30;
		}

		double max_fun = -1.0e+30;
		for (int n = 0; n<numObjectives; n++)
		{
			double diff = (y_obj[n] - idealpoint[n]) / scale[n];
			double feval;
			if (namda[n] == 0)
				feval = 0.0001*diff;
			else
				feval = diff*namda[n];
			if (feval>max_fun) max_fun = feval;

		}
		fvalue = max_fun;
	}


	//* Boundary intersection approach
	if (!strcmp(strFunctionType, "_PBI"))
	{

		// normalize the weight vector (line segment)
		double nd = norm_vector(namda);
		for (int i = 0; i<numObjectives; i++)
			namda[i] = namda[i] / nd;

		vector <double> realA(numObjectives);
		vector <double> realB(numObjectives);

		// difference beween current point and reference point
		for (int n = 0; n < numObjectives; n++)
			realA[n] = (y_obj[n] - idealpoint[n]);

		// distance along the line segment
		double d1 = fabs(innerproduct(realA, namda));

		// distance to the line segment
		for (int n = 0; n<numObjectives; n++)
		{
			realB[n] = (realA[n] - d1*namda[n]);
		}
		double d2 = norm_vector(realB);
		double t =  penaty;

		fvalue = d1 + 5*d2;

	}

	if (!strcmp(strFunctionType, "_TP"))
	{

		// normalize the weight vector (line segment)
		double nd = norm_vector(namda);
		for (int i = 0; i<numObjectives; i++)
			namda[i] = namda[i] / nd;

		vector <double> realA(numObjectives);
		vector <double> realB(numObjectives);

		// difference beween current point and reference point
		for (int n = 0; n < numObjectives; n++)
			realA[n] = (y_obj[n] - idealpoint[n]);// (nadir[n] - idealpoint[n]);

		// distance along the line segment
		double d1 = fabs(innerproduct(realA, namda));

		// distance to the line segment
		for (int n = 0; n<numObjectives; n++)
		{
			realB[n] = (realA[n] - d1*namda[n]);
		}
		double d2 = norm_vector(realB);


		double max_fun = -1.0e+30;
		double au = 0;
		for (int n = 0; n<numObjectives; n++)
		{
			double diff = fabs(y_obj[n] - idealpoint[n]);
			double feval;
			if (namda[n] == 0)
				feval = diff / 1.0e-4;
			else
				feval = diff / namda[n];
			if (feval>max_fun) max_fun = feval;
			au += feval;
		}

		fvalue = au + 1.0e+20*d2;
	

	}

	return fvalue;
}

#endif