////////////////////////////////////////////////////////////////////
//////// Copy Right 2008 by H. Cheng   ///////
//////////     hc118@le.ac.uk          /////////
////////////////////////////////////////////////////////////////////
#ifndef QoS_SAMulticast_H
#define QoS_SAMulticast_H

//// Total Nodes
#define Node 50
#define Link 201
#define Channel 3

#include <iostream>
using namespace std;
#include <fstream>
#include <cstdlib>
#include <ctime>
#include <cmath>
#include <vector>

//Parameters
//#define CoeDecreTempe            0.8
//#define MaxDecreTempeNum         30
//#define CoeContDecreTempe        0.3
//#define CoeConsTempeNoChange     0.3

//// Input file of Sample_Network
ifstream Sin("JointMuCA_SA.in");
ifstream fin("WMNTopo.in");
ofstream fout("JointMuCA_SA.out");

//// Starting Node
double CoeDecreTempe;
int MaxDecreTempeNum;
double CoeContDecreTempe;
double CoeConsTempeNoChange;

int Source;
//// Destination 
vector<int> Destination;
int Iteration;

//// Crossover Point
vector<int> X;
vector<int> Y;

//// Delay, Cost, LinkNo, ConflictGraph
double Delay[Node][Node];
double Cost[Node][Node];
int LinkNo[Node][Node];
int ConflictGraph[Link][Link];

//// Temp Delay, Cost, Conflict
double Temp_Delay[Node][Node];
double Temp_Cost[Node][Node];
int Temp_ConflictGraph[Link][Link];
int Count;

//// End to End Delay Bound
double delayBound, max_delay, delayValue, maxdelayValue, LCA_ave_delay, LCA_max_delay, SPT_ave_delay, SPT_max_delay, costValue, LCA_costValue, SPT_costValue, max_cost;
int minConflictValue,LCA_conflict,SPT_conflict;

//// To Declare of Chromosome
struct
{
	int Temp_chromosome[Node][Node];
	vector<int> Length;
	vector<int> checkedNode;
	double fitness;
	double cost;
} Optimal, LCAMulticastTree, SPTMulticastTree, Routing[2];

//// Temp Storage Vector (Replace Genes)
vector<int> Temp1;
vector<int> Temp2;

class SAMulticast
{
	public:	
	  //// Generators ////
		SAMulticast();
		//// Encoding ////
		void Step_Init();
		void Init();
		void Init_Routing();
		void ReadTopo();
		//void Init_Routing();
		int iRandom(int);
		void LCA_Result(int);
		void SPT_Result(int);
		double dRandom();
		void Encoding(int,int); //int -> Solution
		void Init_Encoding(int,int,int);
		void Init_Temp_Matrices();
		void Delete_Path(int);
		int nextLocation(int);
		int checkDelay(vector<int> &);
		void CoarseGrainedNeighbor(int);
        void FineGrainedNeighbor(int);
        void Run_FineNeighbor(int,int,int);
        void NewNeighbor_Encoding(int,int,int);
        void Init_Temp_ConflictGraph();
		int Channel_Assignment(int);
		//// Fitness Function ////
		void Fitness_Function(int);		
};
#endif
