////////////////////////////////////////////////////////////////////
//////// Copy Right 2008 by H. Cheng   ///////
//////////     hc118@le.ac.uk          /////////
////////////////////////////////////////////////////////////////////

#include "WMNMulticast_GAweights.h"

//// Generator of class
GAMulticast :: GAMulticast(){}

//// Initial Whole Population
void GAMulticast :: Init_Routing()
{
	int i,x,y;
    for(i=0;i<Size;i++)
	{
		Routing[i].Length.clear();
		Routing[i].checkedNode.clear();
		for(x=0; x<Node; x++)
		{
			for(y=0; y<Node; y++)
				Routing[i].Temp_chromosome[x][y] = 0;
		}
	}
	
	Optimal.Length.clear();
	for(x=0; x<Node; x++)
	{
		for(y=0; y<Node; y++)
			Optimal.Temp_chromosome[x][y] = 0;
    }
    
    LCAMulticastTree.Length.clear();
	for(x=0; x<Node; x++)
	{
		for(y=0; y<Node; y++)
			LCAMulticastTree.Temp_chromosome[x][y] = 0;
    }
    
    SPTMulticastTree.Length.clear();
	for(x=0; x<Node; x++)
	{
		for(y=0; y<Node; y++)
			SPTMulticastTree.Temp_chromosome[x][y] = 0;
    }
		
	Destination.clear();
}

//// Terminate Condition 
int GAMulticast :: Convergence()
{
	int flag=0;
	Fitness_Function();
	Elitism();
	Tournament_Selection();
	
	for(int i=1;i<Population;i++)
	{
		//if(Routing[0].fitness != Routing[i].fitness || Routing[0].cost != Routing[i].cost )
		for(int j=0;j<Destination.size();j++)
            if(Routing[0].Length[j]!= Routing[i].Length[j])
            {
               flag=-1; 
               break;
            }
        if(flag==-1)
           break;
	}
	if(flag==0)
	{
       for(int i=1;i<Population;i++)
	   {
		//if(Routing[0].fitness != Routing[i].fitness || Routing[0].cost != Routing[i].cost )
		   for(int j=0;j<Destination.size();j++)
		   {
               for(int k=0;k<Routing[0].Length[j];k++)		   
                   if(Routing[0].Temp_chromosome[j][k]!= Routing[i].Temp_chromosome[j][k])
                   {
                      flag=-1; 
                      break;
                   }
               if(flag==-1)
                  break;
           
           }
           if(flag==-1)
              break;
	   }               
    }
	if(flag == -1)
	{
		Init_Crossover();
		Repair_Function();
		Mutation();
	}
	return flag;
}
//// Random number generator
int GAMulticast :: iRandom(int num)
{
	int temp = rand()%num;
	return temp;
}

double GAMulticast :: dRandom()
{
	double temp = (double)rand()/(double)RAND_MAX;
	return temp;
}
///////////////////
void GAMulticast :: ReadTopo()
{
    int i,j;
    fin >> Iteration;
    //// Delay Matrix
    for(i=0;i<Node;i++)
	{
		for(j=0;j<Node;j++)
			fin >> Delay[i][j];
	}
	//// Cost Matrix
	for(i=0;i<Node;i++)
	{
		for(j=0;j<Node;j++)
		  fin >> Cost[i][j];
	}	
	//// LinkNo Matrix
	for(i=0;i<Node;i++)
	{
		for(j=0;j<Node;j++)
		  fin >> LinkNo[i][j];
	}	
	//// Conflict Relationship Matrix
	for(i=0;i<Link;i++)
	{
		for(j=0;j<Link;j++)
		  fin >> ConflictGraph[i][j];
	}
	
	fin >> Source; 
}
//// Part of Initial State
void GAMulticast :: Init() //read LCA tree into the chromosome and initialize the initial population
{
	int i,j,temp;
	
	max_delay = max_cost = -(RAND_MAX-1);
	
	for(j=0;j<Destination.size();j++)
	{
	    fin >> temp;
	    i=0;
	    while(temp !=Destination[j])
	    {
      		LCAMulticastTree.Temp_chromosome[j][i] = temp;
      		i++;
      		fin >> temp;
        }
        LCAMulticastTree.Temp_chromosome[j][i] = temp;
        i++;
        LCAMulticastTree.Length.push_back(i);
    }
    
    for(j=0;j<Destination.size();j++)
	{
	    fin >> temp;
	    i=0;
	    while(temp !=Destination[j])
	    {
      		SPTMulticastTree.Temp_chromosome[j][i] = temp;
      		i++;
      		fin >> temp;
        }
        SPTMulticastTree.Temp_chromosome[j][i] = temp;
        i++;
        SPTMulticastTree.Length.push_back(i);
    }
    
    /*
    for(j=0;j<Destination.size();j++)
	{
	    i=0;
	    while(LCAMulticastTree.Temp_chromosome[j][i]!=Destination[j])
	    {
      		fout << LCAMulticastTree.Temp_chromosome[j][i] <<" ";
      		i++;
        }
        fout << LCAMulticastTree.Temp_chromosome[j][i] <<" ";
        fout << "Path length: "<< LCAMulticastTree.Length[j]<<endl;
    }*/
    
   	//// Set of Probabilities
	rateMutation = 0.05; //0.10
	rateCrossover = 0.80;
	
	//// Set of Boundaries
	delayBound = 50.0;
	//MaxFitness = -(RAND_MAX-1);
	minConflictValue = RAND_MAX-1;
	maxFitness = 0.0;
	
	//// Generation 
	//Generation = 0;
    
	//// Call of Encoding Method
	
	Routing[0]=SPTMulticastTree;
	Routing[1]=LCAMulticastTree;
	
	for(i=2;i<22;i++)
	{
        if(i%2==0)
        {
           Routing[i]=LCAMulticastTree;    
           TreeSingleMutation(i);                     
        }
        else
        {
           Routing[i]=SPTMulticastTree;    
           TreeSingleMutation(i);
        }
    }
    
    for(i=22;i<Population;i++)
	{
		//fout << "The chromosome No is "<<i<<endl;
        for(j=0;j<Destination.size();j++)
        	Encoding(i,j);
	}
}

void GAMulticast :: TreeSingleMutation(int chromosome)
{
	int selected_destination, selected_point;
    	
	Init_Temp_Matrices();
	//if(dRandom() <= rateMutation)
	Count=0;
	selected_destination = iRandom(Destination.size());
	selected_point = iRandom(Routing[chromosome].Length[selected_destination]);
	Run_FineNeighbor(chromosome,selected_destination,selected_point);		
}

void GAMulticast :: Run_FineNeighbor(int chromosome,int selected_destination,int selected_point)
{
	Temp1.clear();
	int flag=0;
	int temp, locus, start;
	
    for(int selection=0; selection<=selected_point; selection++)
		Temp1.push_back(Routing[chromosome].Temp_chromosome[selected_destination][selection]);
	
    locus = start = Routing[chromosome].Temp_chromosome[selected_destination][selected_point];
	
    NewNeighbor_Encoding(chromosome,selected_destination,locus);
	
    for(int i=0;i<Node/2;i++)
	{
		temp = nextLocation(locus);
		if(temp != -1)
		{
			Temp1.push_back(temp);
			Delete_Path(locus);
			locus=temp;
		}
		if(temp == Destination[selected_destination] && checkDelay(Temp1) == 1)
		{
			for(int j=0;j<Temp1.size();j++)
				Routing[chromosome].Temp_chromosome[selected_destination][j] = Temp1[j];
			Routing[chromosome].Length[selected_destination] = Temp1.size();
			flag = 1;
			break;
		}
	}
	if(Count != Node/10 && flag != 1)
	{
		Count++;
		Run_FineNeighbor(chromosome,selected_destination,selected_point);
	}
}

void GAMulticast :: NewNeighbor_Encoding(int chromosome,int dest,int start)
{
    Init_Temp_Matrices();
	for(int i=0;i<Routing[chromosome].checkedNode.size();i++)
	{
		if(Destination[dest] != Routing[chromosome].checkedNode[i] && start != Routing[chromosome].checkedNode[i])
		  Delete_Path(Routing[chromosome].checkedNode[i]);
	}
}

//// Part of Encoding
void GAMulticast :: Encoding(int chromosome,int num_destination)
{
	int flag;
	int start, temp, locus;
	do
	{
	  start = Source;
	  Temp1.clear();
      Temp2.clear();
	  if(num_destination != 0)
	  {
		 int destination = iRandom(num_destination);
		 int where = iRandom(Routing[chromosome].Length[destination]);
		 start = Routing[chromosome].Temp_chromosome[destination][where];
		 for(int i=0;i<where;i++)
			 Temp1.push_back(Routing[chromosome].Temp_chromosome[destination][i]);
      }
	  locus = start;
	  Temp1.push_back(start);
      Temp2.push_back(start);
      Init_Encoding(chromosome,num_destination,start);
      //fout << "\nThe source is "<<start<<endl;
	  for(int i=0;i<Node;i++)
	  {
		  temp = nextLocation(locus);
		  if(temp != -1)
		  {
			 Temp1.push_back(temp);
			 Temp2.push_back(temp);
			 Delete_Path(locus);
			 locus=temp;
		  }
		  if(temp == Destination[num_destination])
		  {
			 flag = checkDelay(Temp1);
			 if(flag == 1)
			 {
				for(int j=0;j<Temp1.size();j++)
					Routing[chromosome].Temp_chromosome[num_destination][j] = Temp1[j];
				for(int j=0;j<Temp2.size();j++)
					Routing[chromosome].checkedNode.push_back(Temp2[j]);
	            Routing[chromosome].Length.push_back(Temp1.size());
			 }
			 break;
		  }
	  }
    }while(temp != Destination[num_destination] || flag == -1);
		 //Encoding(chromosome,num_destination);
}

void GAMulticast :: Init_Temp_Matrices()
{
	int i,j; 
    for(i=0;i<Node;i++)
	{
		for(j=0;j<Node;j++)
		{
			Temp_Delay[i][j] = Delay[i][j];
			Temp_Cost[i][j] = Cost[i][j];
		}
	}
}

//// To remove the overlapping nodes
void GAMulticast :: Init_Encoding(int chromosome,int num_destination,int start)
{
	int i;
    Init_Temp_Matrices();
	for(i=0;i<Destination.size();i++)
	{
		if(start == Destination[i])
			continue;
		if(i != num_destination)
			Delete_Path(Destination[i]);
	}
	for(int i=0;i<Routing[chromosome].checkedNode.size();i++)
	{
		if(start != Routing[chromosome].checkedNode[i])
			Delete_Path(Routing[chromosome].checkedNode[i]);
	}
}

void GAMulticast :: Delete_Path(int destination)
{
	int i;
    for(i=0;i<Node;i++)
	  Temp_Cost[destination][i] = Temp_Cost[i][destination] = 0;
}

//// To find adjancent node 
int GAMulticast :: nextLocation(int locus)
{
	int location = iRandom(Node);
	if(Temp_Cost[locus][location] != 0)
		return location;
	else
		return -1;
}

//// To check delaybound
int GAMulticast :: checkDelay(vector<int> &temp)
{
	int i;
    double delay = 0.0;
	for(i=1; i<temp.size(); i++)
		delay += Delay[temp[i-1]][temp[i]];
	if(delay <= delayBound)
		return 1;
	else
		return -1;
}

void GAMulticast :: Init_Temp_ConflictGraph()
{
	int i,j;
    for(i=0;i<Link;i++)
		for(j=0;j<Link;j++)
			Temp_ConflictGraph[i][j] = ConflictGraph[i][j];		
}

int GAMulticast :: Channel_Assignment(int chromosome) //ul return the pair number of conflicts
{
    int conflict_count = 0, firstlink, secondlink;
    Init_Temp_Matrices();
    Init_Temp_ConflictGraph();
    //fout << "\n";
    for(int dest=0;dest<Destination.size();dest++)
	{
		for(int j=1;j<Routing[chromosome].Length[dest];j++)
		{
			if(Temp_Cost[Routing[chromosome].Temp_chromosome[dest][j-1]][Routing[chromosome].Temp_chromosome[dest][j]] != 0.0)
			{
				firstlink = LinkNo[Routing[chromosome].Temp_chromosome[dest][j-1]][Routing[chromosome].Temp_chromosome[dest][j]];
                
                for (int d=dest;d<Destination.size();d++)
				{
                   if (d == dest)
                   {
                      for (int k=j+1;k<Routing[chromosome].Length[d];k++)
                      {
                       if(Temp_Cost[Routing[chromosome].Temp_chromosome[d][k-1]][Routing[chromosome].Temp_chromosome[d][k]] != 0.0)
                       {
                         secondlink = LinkNo[Routing[chromosome].Temp_chromosome[d][k-1]][Routing[chromosome].Temp_chromosome[d][k]];
                         if (((j-1) % Channel) == ((k-1) % Channel) && Routing[chromosome].Temp_chromosome[dest][j-1] != Routing[chromosome].Temp_chromosome[d][k-1])
                         {
                             if(Temp_ConflictGraph[firstlink][secondlink] == 1)
                             {
                                conflict_count++; 
                                Temp_ConflictGraph[firstlink][secondlink] = 0;
                                Temp_ConflictGraph[secondlink][firstlink] = 0;
                                //fout << "The firstlink is "<<firstlink<<endl;
                                //fout << "The secondlink is "<<secondlink<<endl;
                             }         
                         }
                       }				       				
                      }
                   }
                   else
                   {
                      for (int k=1;k<Routing[chromosome].Length[d];k++)
                      {
                       if(Temp_Cost[Routing[chromosome].Temp_chromosome[d][k-1]][Routing[chromosome].Temp_chromosome[d][k]] != 0.0)
                       {
                         secondlink = LinkNo[Routing[chromosome].Temp_chromosome[d][k-1]][Routing[chromosome].Temp_chromosome[d][k]];
                         if (((j-1) % Channel) == ((k-1) % Channel) && Routing[chromosome].Temp_chromosome[dest][j-1] != Routing[chromosome].Temp_chromosome[d][k-1])
                         {
                             if(Temp_ConflictGraph[firstlink][secondlink] == 1)
                             {
                                conflict_count++; 
                                Temp_ConflictGraph[firstlink][secondlink] = 0;
                                Temp_ConflictGraph[secondlink][firstlink] = 0;
                                //fout << "The firstlink is "<<firstlink<<endl;
                                //fout << "The secondlink is "<<secondlink<<endl;
                             }         
                         }
                       }				       				
                      }                       
                   }
                }
                Temp_Cost[Routing[chromosome].Temp_chromosome[dest][j-1]][Routing[chromosome].Temp_chromosome[dest][j]]=0.0;
                Temp_Cost[Routing[chromosome].Temp_chromosome[dest][j]][Routing[chromosome].Temp_chromosome[dest][j-1]]=0.0;
			}			
		}			
    }
    return conflict_count;
}

int GAMulticast :: Tree_Cost(int chromosome)
{
    int i,j,dest,NodeID[Node],leaf_num, treenode_num=0, treecost;
    
    for(i=0;i<Node;i++)
        NodeID[i]=-1;
    
    for(dest=0;dest<Destination.size();dest++)
		for(j=0;j<Routing[chromosome].Length[dest];j++)
            NodeID[Routing[chromosome].Temp_chromosome[dest][j]]=1;        
    
    for(i=0;i<Node;i++)
    {
        if(NodeID[i]==1)
           treenode_num++; 
    }    
    
    leaf_num=Destination.size();
    
    for(dest=0;dest<Destination.size();dest++)
		for(j=0;j<Destination.size();j++)
		{
            if(j!=dest)
            {
               for(i=0;i<Routing[chromosome].Length[j];i++)
                   if(Routing[chromosome].Temp_chromosome[j][i]==Routing[chromosome].Temp_chromosome[dest][Routing[chromosome].Length[dest]-1]) 
                      leaf_num--;           
            }
        }
    treecost=1+leaf_num+2*(treenode_num-1-leaf_num);
    return treecost;
}

//// Part of Fitness Function
void GAMulticast :: Fitness_Function()
{	
	int delay_count,count,conflict_value,treecost_value; //ul
	double whole_cost, temp_path_cost, path_cost, temp_delay_cost, delay_cost, maxdelay;
	
    for(int i=0;i<Population;i++)
	{
		Init_Temp_Matrices();
		Routing[i].fitness = Routing[i].cost = path_cost = delay_cost = maxdelay = 0.0;
		count=0;
		for(int d=0;d<Destination.size();d++)
		{
			//delay_count= 0;
			temp_path_cost= temp_delay_cost = 0.0;
			for(int j=1;j<Routing[i].Length[d];j++)
			{
				if(Temp_Cost[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]] != 0.0)
				{
					count++; 
					//// Cost
					temp_path_cost += Temp_Cost[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]];
					Temp_Cost[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]]=0.0;
					Temp_Cost[Routing[i].Temp_chromosome[d][j]][Routing[i].Temp_chromosome[d][j-1]]=0.0;
					//// Delay
					//temp_delay_cost += Temp_Delay[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]];
					//Temp_Delay[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]]=0.0;
					//Temp_Delay[Routing[i].Temp_chromosome[d][j]][Routing[i].Temp_chromosome[d][j-1]]=0.0;
				}
				temp_delay_cost += Temp_Delay[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]];
			}
			if(temp_delay_cost>maxdelay)
			   maxdelay=temp_delay_cost;
			path_cost += temp_path_cost;
			delay_cost += temp_delay_cost;
		}
		conflict_value = Channel_Assignment(i);
		treecost_value = Tree_Cost(i);
		//fout<<"Tree cost: "<<treecost_value<<endl;
		Routing[i].fitness = 1.0/(aPara*conflict_value + bPara*treecost_value);
        //Routing[i].fitness = 1.0/(conflict_value + 1.0); //ul
        Routing[i].cost = path_cost;
        		
		/*if(conflict_value < minConflictValue && delay_cost/Destination.size() <= delayBound)
		{
		   minConflictValue = conflict_value;
           Optimal = Routing[i];
		   delayValue = delay_cost/Destination.size();
		   maxdelayValue = maxdelay;
	       costValue = path_cost;
        }
        
		if(conflict_value == minConflictValue && path_cost < costValue && delay_cost/Destination.size() <= delayBound)
		{
            Optimal = Routing[i];
		    delayValue= delay_cost/Destination.size();
		    maxdelayValue = maxdelay;
	        costValue = path_cost;
        }*/
        if(Routing[i].fitness > maxFitness && delay_cost/Destination.size() <= delayBound)
		{
		   maxFitness = Routing[i].fitness;
           Optimal = Routing[i];
           conflictvalue_inoptimal=conflict_value;
           treecost_inoptimal=treecost_value;
		   delayValue = delay_cost/Destination.size();
		   maxdelayValue = maxdelay;
	       costValue = path_cost;
        }        
	}	
}

void GAMulticast :: Elitism()
{
     int worst_id;
     double worst_chromo_fitness[Size+1];
          
     for(int j=0;j<Size;j++)
         worst_chromo_fitness[j]=Routing[j].fitness;
     
     worst_chromo_fitness[Size]=worst_chromo_fitness[0];
     worst_id=0;
     for(int j=1;j<Size;j++)
     {
         if(worst_chromo_fitness[j]<worst_chromo_fitness[Size])
         {
            worst_chromo_fitness[Size]=worst_chromo_fitness[j];
            worst_id=j;                                                       
         }
     }
     Routing[worst_id]=Optimal;
     //Fitness_Individual(worst_id);
}

void GAMulticast :: LCA_Result(int i)
{	
	int delay_count,count,conflict_value; //ul
	double whole_cost, temp_path_cost, path_cost, temp_delay_cost, delay_cost, maxdelay;
	
    Init_Temp_Matrices();
	Routing[i].fitness = Routing[i].cost = path_cost = delay_cost = maxdelay = 0.0;
	count=0;
	for(int d=0;d<Destination.size();d++)
	{
		//delay_count= 0;
		temp_path_cost= temp_delay_cost = 0.0;
		for(int j=1;j<Routing[i].Length[d];j++)
		{
			if(Temp_Cost[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]] != 0.0)
			{
				count++; 
				//// Cost
				temp_path_cost += Temp_Cost[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]];
				Temp_Cost[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]]=0.0;
				Temp_Cost[Routing[i].Temp_chromosome[d][j]][Routing[i].Temp_chromosome[d][j-1]]=0.0;
				//// Delay
				//temp_delay_cost += Temp_Delay[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]];
				//Temp_Delay[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]]=0.0;
				//Temp_Delay[Routing[i].Temp_chromosome[d][j]][Routing[i].Temp_chromosome[d][j-1]]=0.0;
			}
			temp_delay_cost += Temp_Delay[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]];
		}
		if(temp_delay_cost>maxdelay)
		   maxdelay=temp_delay_cost;
		path_cost += temp_path_cost;
		delay_cost += temp_delay_cost;
	}
	LCA_conflict = Channel_Assignment(i);
		
    Routing[i].fitness = 1.0/(conflict_value + 1.0); //ul
    Routing[i].cost = path_cost;
        		
	LCA_ave_delay = delay_cost/Destination.size();
	LCA_max_delay = maxdelay;
	LCA_costValue = path_cost;   
}

void GAMulticast :: SPT_Result(int i)
{	
	int delay_count,count,conflict_value; //ul
	double whole_cost, temp_path_cost, path_cost, temp_delay_cost, delay_cost, maxdelay;
	
    Init_Temp_Matrices();
	Routing[i].fitness = Routing[i].cost = path_cost = delay_cost = maxdelay = 0.0;
	count=0;
	for(int d=0;d<Destination.size();d++)
	{
		//delay_count= 0;
		temp_path_cost= temp_delay_cost = 0.0;
		for(int j=1;j<Routing[i].Length[d];j++)
		{
			if(Temp_Cost[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]] != 0.0)
			{
				count++; 
				//// Cost
				temp_path_cost += Temp_Cost[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]];
				Temp_Cost[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]]=0.0;
				Temp_Cost[Routing[i].Temp_chromosome[d][j]][Routing[i].Temp_chromosome[d][j-1]]=0.0;
				//// Delay
				//temp_delay_cost += Temp_Delay[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]];
				//Temp_Delay[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]]=0.0;
				//Temp_Delay[Routing[i].Temp_chromosome[d][j]][Routing[i].Temp_chromosome[d][j-1]]=0.0;
			}
			temp_delay_cost += Temp_Delay[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]];
		}
		if(temp_delay_cost>maxdelay)
		   maxdelay=temp_delay_cost;
		path_cost += temp_path_cost;
		delay_cost += temp_delay_cost;
	}
	SPT_conflict = Channel_Assignment(i);
		
    Routing[i].fitness = 1.0/(conflict_value + 1.0); //ul
    Routing[i].cost = path_cost;
        		
	SPT_ave_delay = delay_cost/Destination.size();
	SPT_max_delay = maxdelay;
	SPT_costValue = path_cost;   
}

//// Part of Selection (i.e., Tournament Selection)
void GAMulticast :: Tournament_Selection()
{
	for(int i=0;i<Population;i++)
	{
		int temp = iRandom(Population);
		chromosomeExchange(i,temp);
	}
}

void GAMulticast :: chromosomeExchange(int first,int second)
{
	if(Routing[first].fitness <= Routing[second].fitness)
	  Routing[first] = Routing[second];
	else
	  Routing[second] = Routing[first];
}

//// Before Crossover, Mixing Chromosomes
void GAMulticast :: Shuffle()
{
	int first,second;
	for(int i=0;i<Population;i++)
	{
		first=iRandom(Population);
        second=iRandom(Population);
		Mix(first,second);
	}
}

void GAMulticast :: Mix(int first,int second)
{
	Routing[Size] = Routing[first];
	Routing[first] = Routing[second];
	Routing[second] = Routing[Size];
}

//// Part of Crossover 
void GAMulticast :: Init_Crossover()
{
	Shuffle();
	for(int i=0;i<Population/2;i++)
	{
	   if(Check_Crossover() == 1)
		  Run_Crossover(i,Population/2+i);
  }
}

void GAMulticast :: Run_Crossover(int first,int second)
{
	int gene;
    for(int dest=0; dest<Destination.size(); dest++)
	{
	    X.clear();
        Y.clear();
		for(int x=0;x<Routing[first].Length[dest]-1;x++)
		{
			for(int y=0;y<Routing[second].Length[dest]-1;y++)
			{
				if(Routing[first].Temp_chromosome[dest][x] == Routing[second].Temp_chromosome[dest][y])
				{
					X.push_back(x);
                    Y.push_back(y);
				}
			}
		}
		gene = iRandom(X.size());
		Exchange_subtree(first,second, X[gene], Y[gene],dest);
	}
}

void GAMulticast :: Exchange_subtree(int first,int second,int crosspoint1,int crosspoint2,int dest)
{
	int flag;
	Temp1.clear();
	Temp2.clear();
	//// Father 
	for(int i=0; i<=crosspoint1; i++)
		Temp1.push_back(Routing[first].Temp_chromosome[dest][i]);
	for(int i=crosspoint2+1; i<Routing[second].Length[dest]; i++)
		Temp1.push_back(Routing[second].Temp_chromosome[dest][i]);
	//// Mother
	for(int i=0; i<=crosspoint2; i++)
		Temp2.push_back(Routing[second].Temp_chromosome[dest][i]);
	for(int i=crosspoint1+1; i<Routing[first].Length[dest]; i++)
		Temp2.push_back(Routing[first].Temp_chromosome[dest][i]);
	if(checkDelay(Temp1) == 1)
	{
		for(int i=0;i<Temp1.size();i++)
			Routing[first].Temp_chromosome[dest][i] = Temp1[i];
		Routing[first].Length[dest]=Temp1.size();
	}
	if(checkDelay(Temp2) == 1)
	{
		for(int i=0;i<Temp2.size();i++)
			Routing[second].Temp_chromosome[dest][i] = Temp2[i];
		Routing[second].Length[dest]=Temp2.size();
	}
}

int GAMulticast :: Check_Crossover()
{
	double rate = dRandom();
	if(rate <= rateCrossover)
		return 1;
	else
		return -1;
}

//// Part of Repair Function
//// To remove infeasible chromosome (loop) and Recombination of Chromosome
void GAMulticast :: Repair_Function()
{
	Temp1.clear();
	int i,front,rear;
	int flag;
	for(i=0; i<Population; i++)
	{
		flag = 0;
		for(front=0; front<Routing[i].Length[0]; front++)
		{
			for(rear=Routing[i].Length[0]-1; rear>front; rear--)
			{
				if(Routing[i].Temp_chromosome[0][front] == Routing[i].Temp_chromosome[0][rear])
				{
					flag = 1;
					break;
				}
			}
			if(flag == 1)
			{
				for(int a=0; a<=front; a++)
					Temp1.push_back(Routing[i].Temp_chromosome[0][a]);
				for(int a=rear+1; a<Routing[i].Length[0]; a++)
					Temp1.push_back(Routing[i].Temp_chromosome[0][a]);
				for(int a=0;a<Temp1.size();a++)
					Routing[i].Temp_chromosome[0][a] = Temp1[a];
				Routing[i].Length[0] = Temp1.size();
				break;
			}
		}
		for(int dest=1; dest<Destination.size(); dest++)
			Check_Recombination(i,dest);
	  Check_Path(i);
	}
}
void GAMulticast :: Check_Recombination(int chromosome, int num_destination)
{
	int i,first,second,flag;
	for(second=Routing[chromosome].Length[num_destination]-2; second >= 0 ; second--)
	{
		flag=0;
		for(i=0;i<num_destination;i++)
		{
			for(first=0; first <Routing[chromosome].Length[i]; first++)
			{
				if(Routing[chromosome].Temp_chromosome[i][first]==Routing[chromosome].Temp_chromosome[num_destination][second])
				{
					flag = -1;
					break;
				}
			}
			if(flag == -1)
				break;
		}
		if(flag == -1)
		{
			Run_Recombination(chromosome,i,num_destination,first,second);
			break;
		}
	}
}
void GAMulticast :: Run_Recombination(int chromosome,int before,int next,int first,int second)
{
	Temp1.clear();
	for(int i=0; i<=first;i++)
		Temp1.push_back(Routing[chromosome].Temp_chromosome[before][i]);
	for(int i=second+1; i<Routing[chromosome].Length[next];i++)
		Temp1.push_back(Routing[chromosome].Temp_chromosome[next][i]);
	for(int i=0;i<Temp1.size();i++)
		Routing[chromosome].Temp_chromosome[next][i] = Temp1[i];
	Routing[chromosome].Length[next] = Temp1.size();
}
void GAMulticast :: Check_Path(int chromosome)
{
	Init_Temp_Matrices();
	Temp1.clear();
	for(int i=0;i<Destination.size();i++)
	{
		for(int j=1;j<Routing[chromosome].Length[i];j++)
		{
			if(Temp_Cost[Routing[chromosome].Temp_chromosome[i][j-1]][Routing[chromosome].Temp_chromosome[i][j]]!= 0.0)
			{
				Temp1.push_back(Routing[chromosome].Temp_chromosome[i][j-1]);
				Temp1.push_back(Routing[chromosome].Temp_chromosome[i][j]);
				Temp_Cost[Routing[chromosome].Temp_chromosome[i][j-1]][Routing[chromosome].Temp_chromosome[i][j]]= 0.0;
				Temp_Cost[Routing[chromosome].Temp_chromosome[i][j]][Routing[chromosome].Temp_chromosome[i][j-1]]= 0.0;
			}
		}
	}
	Routing[chromosome].checkedNode = Temp1;
}

//// Part of Mutation
void GAMulticast :: Mutation()
{
	int mutation_destination,mutation_point;
	for(int i=0;i<Population;i++)
	{
		Init_Temp_Matrices();
		if(dRandom() <= rateMutation)
		{
			Count=0;
			mutation_destination = iRandom(Destination.size());
			mutation_point = iRandom(Routing[i].Length[mutation_destination]);
			Run_Mutation(i,mutation_destination,mutation_point);
		}
	}
}
void GAMulticast :: Run_Mutation(int chromosome,int mutation_destination,int mutation_point)
{
	Temp1.clear();
	int flag=0;
	int temp, locus, start;
	for(int mutation=0; mutation<=mutation_point; mutation++)
		Temp1.push_back(Routing[chromosome].Temp_chromosome[mutation_destination][mutation]);
	locus = start = Routing[chromosome].Temp_chromosome[mutation_destination][mutation_point];
	Muatation_Encoding(chromosome,mutation_destination,locus);
	for(int i=0;i<Node/2;i++)
	{
		temp = nextLocation(locus);
		if(temp != -1)
		{
			Temp1.push_back(temp);
			Delete_Path(locus);
			locus=temp;
		}
		if(temp == Destination[mutation_destination] && checkDelay(Temp1) == 1)
		{
			for(int j=0;j<Temp1.size();j++)
				Routing[chromosome].Temp_chromosome[mutation_destination][j] = Temp1[j];
			Routing[chromosome].Length[mutation_destination] = Temp1.size();
			flag = 1;
			break;
		}
	}
	if(Count != Node/10 && flag != 1)
	{
		Count++;
		Run_Mutation(chromosome,mutation_destination,mutation_point);
	}
}
void GAMulticast :: Muatation_Encoding(int chromosome,int dest,int start)
{
    Init_Temp_Matrices();
	for(int i=0;i<Routing[chromosome].checkedNode.size();i++)
	{
		if(Destination[dest] != Routing[chromosome].checkedNode[i] && start != Routing[chromosome].checkedNode[i])
		  Delete_Path(Routing[chromosome].checkedNode[i]);
	}
}

//// Part of Main Function
int main(int argc, char *argv[])
{
	//time_t now1,now2;
	clock_t now1,now2;
    double duration;
    int i,j,k,temp,condition,conflict,Generation;
    char *inputfile;
    char *outputfile = new char[60];
    
    NodeNum = atoi(argv[1]);
    aPara = atof(argv[2]);
    bPara = atof(argv[3]);
    
    if(NodeNum == 11)
       inputfile="WMNTopo11.in";
    if(NodeNum == 23)
       inputfile="WMNTopo23.in";  
    if(NodeNum == 50)
       inputfile="WMNTopo50.in";  
    
    sprintf(outputfile, "JointMCA_GA_N%d_a%4.2f_b%4.2f.out", NodeNum, aPara, bPara);
    
    fin.open(inputfile);    
    fout.open(outputfile,ios::out);
    
	srand(time(0));
	GAMulticast GAM;	
	GAM.ReadTopo();
	for(int step=0; step<Iteration; step++)
	{
		//time(&now1);
		now1=clock();
        Generation = 0;	
        while(1)
	    {
		    fin >> temp;
		    if(temp != -1)
			   Destination.push_back(temp);
		    else 
			   break;
	    }
        GAM.Init();
        //// Init Population		
		//// Convergence	
		while(1)
		{
			condition = GAM.Convergence();
			if(condition != 0)
			   Generation++;
			else
			{
			   conflict=GAM.Channel_Assignment(0);
               break;       
            }
            if(Generation == Node) 
               break;            
		}
		//time(&now2);
		now2=clock();
		duration=(double)(now2 - now1) / CLOCKS_PER_SEC;
		fout << duration << "seconds" <<endl; 
        //fout << "\nStart time is "<<ctime(&now1);
		//fout << "End time is "<<ctime(&now2);
		//fout << "The best solution is like that"<<endl;
		//fout << "In Generation "<<Generation<<endl;
		//fout << "total "<<total<<endl;
        //fout << "condition "<<condition<<endl;
        //fout << "The maximum Delay: "<<maxdelayValue<<endl;
		//fout << "The average Delay: "<<delayValue<<endl;	    
	    //fout << "The best Tree Cost is "<<costValue<<endl;	    
	    //fout << "The conflict value is "<<conflict<<endl;
	    fout << "The GA Tree: "<<endl;
		for(int dest=0; dest<Destination.size(); dest++)
		{
		  for(int col=0; col<Optimal.Length[dest]; col++)
		    fout<<Optimal.Temp_chromosome[dest][col]<<" ";
		  fout<<endl;
		}
		//fout << "The minimum conflict: "<<minConflictValue<<endl;
	    fout<<endl;
	    fout << "GA conflict value: "<<conflictvalue_inoptimal<<endl;
	    fout << "GA tree cost value: "<<treecost_inoptimal<<endl;
        fout << "GA average delay: "<<delayValue<<endl;
        fout << "GA max delay: "<<maxdelayValue<<endl;
	    
        /*fout << "The LCA Tree: "<<endl;
		Routing[0]=LCAMulticastTree;		
		for(j=0;j<Destination.size();j++)
	    {
	        i=0;
	        while(Routing[0].Temp_chromosome[j][i]!=Destination[j])
	        {
 		          fout << Routing[0].Temp_chromosome[j][i] <<" ";
      		      i++;
            }
            fout << Routing[0].Temp_chromosome[j][i] <<" ";
            fout<<endl;
        }
        //LCA_conflict=GAM.Channel_Assignment(0);
        GAM.LCA_Result(0);
        //fout << "LCA conflict value: "<<LCA_conflict<<endl;
        
        fout << "The SP Tree: "<<endl;
        Routing[0]=SPTMulticastTree;		
		for(j=0;j<Destination.size();j++)
	    {
	        i=0;
	        while(Routing[0].Temp_chromosome[j][i]!=Destination[j])
	        {
 		          fout << Routing[0].Temp_chromosome[j][i] <<" ";
      		      i++;
            }
            fout << Routing[0].Temp_chromosome[j][i] <<" ";
            fout<<endl;
        }
        GAM.SPT_Result(0);*/
        //SPT_conflict=GAM.Channel_Assignment(0);
        
        //fout << "LCA conflict value: "<<LCA_conflict<<endl;
        //fout << "SPT conflict value: "<<SPT_conflict<<endl;        
        //fout << "LCA average delay: "<<LCA_ave_delay<<endl;
        //fout << "SPT average delay: "<<SPT_ave_delay<<endl;       
        //fout << "LCA max delay: "<<LCA_max_delay<<endl;
        //fout << "SPT max delay: "<<SPT_max_delay<<endl;
		
        GAM.Init_Routing();
    }	
	return 0;
}
