////////////////////////////////////////////////////////////////////
//////// Copy Right 2008 by H. Cheng   ///////
//////////     hc118@le.ac.uk  //////////
////////////////////////////////////////////////////////////////////

#ifndef WMNMulticast_GAweights_H
#define WMNMulticast_GAweights_H
//#define MAX 100
#define Size 50 // Node 20 -> Size 270

//// Total Nodes
#define Node 50 //maximum node number
#define Link 201
#define Channel 3
#define Population 50

//// Iteration (No. of sample_networks)
#include <iostream>
using namespace std;
#include <fstream>
#include <cstdlib>
#include <ctime>
#include <cmath>
#include <vector>

//// Input file of Sample_Network
//ifstream fin("WMNTopo.in");
/* Ouput file */
//ofstream fout("JointMuCA_GA.out");

fstream fin;
fstream fout;

int Source;
vector<int> Destination;
int Iteration;
int NodeNum;
float aPara, bPara;

vector<int> X;
vector<int> Y;
//// Delay, and Cost
double Delay[Node][Node];
double Cost[Node][Node];
int LinkNo[Node][Node];
int ConflictGraph[Link][Link];
//// Temp Delay, Cost, Conflict
double Temp_Delay[Node][Node];
double Temp_Cost[Node][Node];
int Temp_ConflictGraph[Link][Link];
int Count, Generation;
//// Crossover and Mutation Rate
double rateCrossover, rateMutation;

double delayBound, max_delay, delayValue, maxdelayValue, LCA_ave_delay, LCA_max_delay, SPT_ave_delay, SPT_max_delay;
double costValue, LCA_costValue, SPT_costValue, max_cost, maxFitness;
int minConflictValue,LCA_conflict,SPT_conflict,conflictvalue_inoptimal,treecost_inoptimal;

//// To Declare of Chromosome
struct 
{
	int Temp_chromosome[Node][Node];
	vector<int> Length;
	vector<int> checkedNode;
	double fitness;
	double cost;
	//int ConflictValue;
} Optimal,LCAMulticastTree,SPTMulticastTree,Routing[Size+1];

//// Temp Storage Vector (Replace Genes)
vector<int> Temp1;
vector<int> Temp2;

class GAMulticast
{
	public:	
	  //// Generators ////
		GAMulticast();
		//// Encoding ////
		void Init();
		void ReadTopo();
		int iRandom(int);
		double dRandom();
		void Encoding(int,int);
		void Init_Temp_Matrices();
		void Delete_Temp_Cost();
		void Init_Encoding(int,int,int);
		void Delete_Path(int);
		int nextLocation(int);
		int checkDelay(vector<int> &);
		void Init_Temp_ConflictGraph();
		int Channel_Assignment(int chromosome);
		int Tree_Cost(int chromosome);
		//// Fitness Function ////
		void Fitness_Function();	
		void LCA_Result(int);
		void SPT_Result(int);
		//// Genetic Opoerator ////
		//// Selection
		void Tournament_Selection();
		void chromosomeExchange(int,int);
		//// Crossover
		void Init_Crossover();
		void Shuffle();
		void Mix(int,int);
		void Run_Crossover(int,int);
		void Exchange_subtree(int,int,int,int,int);
		//// Penality Function 
		//int Prnality_Function(vector<int> &T);
		//// Repair Function
		void Repair_Function();
		void Check_Recombination(int,int);
		void Run_Recombination(int,int,int,int,int);
		void Check_Path(int);
		int Check_Crossover();
		//// Mutation
		void Mutation();
		void Run_Mutation(int,int,int);
		void Muatation_Encoding(int,int,int);
		//// Convergence
		int Convergence();
		void Elitism();
		void TreeSingleMutation(int);
		void Run_FineNeighbor(int,int,int);
		void NewNeighbor_Encoding(int,int,int);
		//// Initial Routing
		void Init_Routing();
};
#endif
