////////////////////////////////////////////////////////////////////
//////// Copy Right 2008 by H. Cheng   ///////
//////////     hc118@le.ac.uk          /////////
////////////////////////////////////////////////////////////////////
#include "WMNMulticast_SAweights.h"

//// Generator of class
SAMulticast :: SAMulticast(){}

//// Random number generator
int SAMulticast :: iRandom(int num)
{
	int temp = rand()%num;
	return temp;
}

double SAMulticast :: dRandom()
{
	double temp = (double)rand()/(double)RAND_MAX;
	return temp;
}

void SAMulticast :: Step_Init()
{
	Sin >> CoeDecreTempe >> MaxDecreTempeNum >> CoeContDecreTempe >> CoeConsTempeNoChange;
}

void SAMulticast :: Init_Routing()
{
	int i,x,y;
    for(i=0;i<2;i++)
	{
		Routing[i].Length.clear();
		Routing[i].checkedNode.clear();
		for(x=0; x<Node; x++)
		{
			for(y=0; y<Node; y++)
				Routing[i].Temp_chromosome[x][y] = 0;
		}
	}
	
	Optimal.Length.clear();
	for(x=0; x<Node; x++)
	{
		for(y=0; y<Node; y++)
			Optimal.Temp_chromosome[x][y] = 0;
    }
    
    LCAMulticastTree.Length.clear();
	for(x=0; x<Node; x++)
	{
		for(y=0; y<Node; y++)
			LCAMulticastTree.Temp_chromosome[x][y] = 0;
    }
    
    SPTMulticastTree.Length.clear();
	for(x=0; x<Node; x++)
	{
		for(y=0; y<Node; y++)
			SPTMulticastTree.Temp_chromosome[x][y] = 0;
    }
		
	Destination.clear();
}

void SAMulticast :: ReadTopo()
{
    int i,j;
    fin >> Iteration;
    //// Delay Matrix
    for(i=0;i<Node;i++)
	{
		for(j=0;j<Node;j++)
			fin >> Delay[i][j];
	}

	//// Cost Matrix
	for(i=0;i<Node;i++)
	{
		for(j=0;j<Node;j++)
		  fin >> Cost[i][j];
	}
	
	//// LinkNo Matrix
	for(i=0;i<Node;i++)
	{
		for(j=0;j<Node;j++)
		  fin >> LinkNo[i][j];
	}
	
	//// Conflict Relationship Matrix
	for(i=0;i<Link;i++)
	{
		for(j=0;j<Link;j++)
		  fin >> ConflictGraph[i][j];
	}
	
	fin >> Source; 
}
//// Part of Initial State
void SAMulticast :: Init()
{
	int i,j,temp;
	int LCA_conflict, SPT_conflict;
	//// Starting Node 
	
	//// Input of Destinations
	max_delay = max_cost = -(RAND_MAX-1);
		
	//// Delay Matrix
	
	for(j=0;j<Destination.size();j++)
	{
	    fin >> temp;
	    i=0;
	    while(temp !=Destination[j])
	    {
      		LCAMulticastTree.Temp_chromosome[j][i] = temp;
      		i++;
      		fin >> temp;
        }
        LCAMulticastTree.Temp_chromosome[j][i] = temp;
        i++;
        LCAMulticastTree.Length.push_back(i);
    }
	
	for(j=0;j<Destination.size();j++)
	{
	    fin >> temp;
	    i=0;
	    while(temp !=Destination[j])
	    {
      		SPTMulticastTree.Temp_chromosome[j][i] = temp;
      		i++;
      		fin >> temp;
        }
        SPTMulticastTree.Temp_chromosome[j][i] = temp;
        i++;
        SPTMulticastTree.Length.push_back(i);
    }
   	//// Set of Boundaries
	delayBound = 50.0;
	minConflictValue = RAND_MAX-1;
	maxFitness = 0.0;
        
	//// Generate the initial solution and give it to Optimal
	for(int j=0;j<Destination.size();j++)
    {
		Encoding(0,j);//encoding the path to Destination[j]
		//for(int col=0; col<Routing[0].Length[j]; col++)
	    //   fout<<Routing[0].Temp_chromosome[j][col]<<" ";
        //fout<<endl;		    		    
	    
    }
    Routing[0]=LCAMulticastTree;
    Routing[1]=SPTMulticastTree;
    
    LCA_conflict=Channel_Assignment(0);
    SPT_conflict=Channel_Assignment(1);
    
    if(LCA_conflict<SPT_conflict)
       Routing[0]=LCAMulticastTree;
    else
       Routing[0]=SPTMulticastTree;
    
    //Fitness_Function(0);		
}

//// Part of Encoding
void SAMulticast :: Encoding(int chromosome,int num_destination)
{
	int flag;
	int start, temp, locus;
	do
	{
	  start = Source;
	  Temp1.clear();
      Temp2.clear();
	  if(num_destination != 0)
	  {
		 int destination = iRandom(num_destination);
		 int where = iRandom(Routing[chromosome].Length[destination]);
		 start = Routing[chromosome].Temp_chromosome[destination][where];
		 for(int i=0;i<where;i++)
			 Temp1.push_back(Routing[chromosome].Temp_chromosome[destination][i]);
      }
	  locus = start;
	  Temp1.push_back(start);
      Temp2.push_back(start);
      Init_Encoding(chromosome,num_destination,start);
      //fout << "\nThe source is "<<start<<endl;
	  for(int i=0;i<Node;i++)
	  {
		  temp = nextLocation(locus);
		  if(temp != -1)
		  {
			 Temp1.push_back(temp);
			 Temp2.push_back(temp);
			 Delete_Path(locus);
			 locus=temp;
		  }
		  if(temp == Destination[num_destination])
		  {
			 flag = checkDelay(Temp1);
			 if(flag == 1)
			 {
				for(int j=0;j<Temp1.size();j++)
					Routing[chromosome].Temp_chromosome[num_destination][j] = Temp1[j];
				for(int j=0;j<Temp2.size();j++)
					Routing[chromosome].checkedNode.push_back(Temp2[j]);
	            Routing[chromosome].Length.push_back(Temp1.size());
			 }
			 break;
		  }
	  }
    }while(temp != Destination[num_destination] || flag == -1);
}

//// To remove the overlapping nodes
void SAMulticast :: Init_Encoding(int chromosome,int num_destination,int start)
{
	Init_Temp_Matrices();
	for(int i=0;i<Destination.size();i++)
	{
		if(start == Destination[i])
			continue;
		if(i != num_destination)
			Delete_Path(Destination[i]);
	}
	for(int i=0;i<Routing[chromosome].checkedNode.size();i++)
	{
		if(start != Routing[chromosome].checkedNode[i])
			Delete_Path(Routing[chromosome].checkedNode[i]);
	}
}

void SAMulticast :: Delete_Path(int destination)
{
	for(int i=0;i<Node;i++)
	  Temp_Cost[destination][i] = Temp_Cost[i][destination] = 0;
}

//// To find adjancent node 
int SAMulticast :: nextLocation(int locus)
{
	int location = iRandom(Node);
	if(Temp_Cost[locus][location] != 0)
		return location;
	else
		return -1;
}

//// To check delaybound
int SAMulticast :: checkDelay(vector<int> &temp)
{
	double delay = 0.0;
	for(int i=1; i<temp.size(); i++)
		delay += Delay[temp[i-1]][temp[i]];
	if(delay <= delayBound)
		return 1;
	else
		return -1;
}

void SAMulticast :: Init_Temp_Matrices()
{
	for(int i=0;i<Node;i++)
	{
		for(int j=0;j<Node;j++)
		{
			Temp_Delay[i][j] = Delay[i][j];
			Temp_Cost[i][j] = Cost[i][j];
		}
	}
}
//if(dRandom() <= rateMutation)
//Randomly select two destinations and change the paths to them
void SAMulticast :: CoarseGrainedNeighbor(int chromosome)
{
    int selected_destination1, selected_point1, selected_destination2, selected_point2;
    
    Init_Temp_Matrices();
	Count=0;
	selected_destination1 = iRandom(Destination.size());
	selected_point1 = iRandom(Routing[chromosome].Length[selected_destination1]);
	Run_FineNeighbor(chromosome,selected_destination1,selected_point1);
	
	Init_Temp_Matrices();
	Count=0;
	selected_destination2 = selected_destination1;
	while(selected_destination2 == selected_destination1)
	{
	    selected_destination2 = iRandom(Destination.size());
    }
	selected_point2 = iRandom(Routing[chromosome].Length[selected_destination2]);
	Run_FineNeighbor(chromosome,selected_destination2,selected_point2);
}

//Randomly select one destination and change the path to it
// solution1 -> solution2
//Mutation 
void SAMulticast :: FineGrainedNeighbor(int chromosome)
{
	int selected_destination, selected_point;
    	
	Init_Temp_Matrices();
	//if(dRandom() <= rateMutation)
	Count=0;
	selected_destination = iRandom(Destination.size());
	selected_point = iRandom(Routing[chromosome].Length[selected_destination]);
	Run_FineNeighbor(chromosome,selected_destination,selected_point);
		
}

//Run_Mutation
void SAMulticast :: Run_FineNeighbor(int chromosome,int selected_destination,int selected_point)
{
	Temp1.clear();
	int flag=0;
	int temp, locus, start;
	for(int selection=0; selection<=selected_point; selection++)
		Temp1.push_back(Routing[chromosome].Temp_chromosome[selected_destination][selection]);
	locus = start = Routing[chromosome].Temp_chromosome[selected_destination][selected_point];
	NewNeighbor_Encoding(chromosome,selected_destination,locus);
	for(int i=0;i<Node/2;i++)
	{
		temp = nextLocation(locus);
		if(temp != -1)
		{
			Temp1.push_back(temp);
			Delete_Path(locus);
			locus=temp;
		}
		if(temp == Destination[selected_destination] && checkDelay(Temp1) == 1)
		{
			for(int j=0;j<Temp1.size();j++)
				Routing[chromosome].Temp_chromosome[selected_destination][j] = Temp1[j];
			Routing[chromosome].Length[selected_destination] = Temp1.size();
			flag = 1;
			break;
		}
	}
	if(Count != Node/10 && flag != 1)
	{
		Count++;
		Run_FineNeighbor(chromosome,selected_destination,selected_point);
	}
}

void SAMulticast :: NewNeighbor_Encoding(int chromosome,int dest,int start)
{
    Init_Temp_Matrices();
	for(int i=0;i<Routing[chromosome].checkedNode.size();i++)
	{
		if(Destination[dest] != Routing[chromosome].checkedNode[i] && start != Routing[chromosome].checkedNode[i])
		  Delete_Path(Routing[chromosome].checkedNode[i]);
	}
}

void SAMulticast :: Init_Temp_ConflictGraph()
{
	for(int i=0;i<Link;i++)
		for(int j=0;j<Link;j++)
			Temp_ConflictGraph[i][j] = ConflictGraph[i][j];		
}

int SAMulticast :: Channel_Assignment(int chromosome) //ul return the pair number of conflicts
{
    int conflict_count = 0, firstlink, secondlink;
    Init_Temp_Matrices();
    Init_Temp_ConflictGraph();
    //fout << "\n";
    for(int dest=0;dest<Destination.size();dest++)
	{
		for(int j=1;j<Routing[chromosome].Length[dest];j++)
		{
			if(Temp_Cost[Routing[chromosome].Temp_chromosome[dest][j-1]][Routing[chromosome].Temp_chromosome[dest][j]] != 0.0)
			{
				firstlink = LinkNo[Routing[chromosome].Temp_chromosome[dest][j-1]][Routing[chromosome].Temp_chromosome[dest][j]];
                
                for (int d=dest;d<Destination.size();d++)
				{
                   if (d == dest)
                   {
                      for (int k=j+1;k<Routing[chromosome].Length[d];k++)
                      {
                       if(Temp_Cost[Routing[chromosome].Temp_chromosome[d][k-1]][Routing[chromosome].Temp_chromosome[d][k]] != 0.0)
                       {
                         secondlink = LinkNo[Routing[chromosome].Temp_chromosome[d][k-1]][Routing[chromosome].Temp_chromosome[d][k]];
                         if (((j-1) % Channel) == ((k-1) % Channel) && Routing[chromosome].Temp_chromosome[dest][j-1] != Routing[chromosome].Temp_chromosome[d][k-1])
                         {
                             if(Temp_ConflictGraph[firstlink][secondlink] == 1)
                             {
                                conflict_count++; 
                                Temp_ConflictGraph[firstlink][secondlink] = 0;
                                Temp_ConflictGraph[secondlink][firstlink] = 0;
                             }         
                         }
                       }				       				
                      }
                   }
                   else
                   {
                      for (int k=1;k<Routing[chromosome].Length[d];k++)
                      {
                       if(Temp_Cost[Routing[chromosome].Temp_chromosome[d][k-1]][Routing[chromosome].Temp_chromosome[d][k]] != 0.0)
                       {
                         secondlink = LinkNo[Routing[chromosome].Temp_chromosome[d][k-1]][Routing[chromosome].Temp_chromosome[d][k]];
                         if (((j-1) % Channel) == ((k-1) % Channel) && Routing[chromosome].Temp_chromosome[dest][j-1] != Routing[chromosome].Temp_chromosome[d][k-1])
                         {
                             if(Temp_ConflictGraph[firstlink][secondlink] == 1)
                             {
                                conflict_count++; 
                                Temp_ConflictGraph[firstlink][secondlink] = 0;
                                Temp_ConflictGraph[secondlink][firstlink] = 0;
                             }         
                         }
                       }				       				
                      }                       
                   }
                }
                Temp_Cost[Routing[chromosome].Temp_chromosome[dest][j-1]][Routing[chromosome].Temp_chromosome[dest][j]]=0.0;
                Temp_Cost[Routing[chromosome].Temp_chromosome[dest][j]][Routing[chromosome].Temp_chromosome[dest][j-1]]=0.0;
			}			
		}			
    }
    return conflict_count;
}

int SAMulticast :: Tree_Cost(int chromosome)
{
    int i,j,dest,NodeID[Node],leaf_num, treenode_num=0, treecost;
    
    for(i=0;i<Node;i++)
        NodeID[i]=-1;
    
    for(dest=0;dest<Destination.size();dest++)
		for(j=0;j<Routing[chromosome].Length[dest];j++)
            NodeID[Routing[chromosome].Temp_chromosome[dest][j]]=1;        
    
    for(i=0;i<Node;i++)
    {
        if(NodeID[i]==1)
           treenode_num++; 
    }    
    
    leaf_num=Destination.size();
    
    for(dest=0;dest<Destination.size();dest++)
		for(j=0;j<Destination.size();j++)
		{
            if(j!=dest)
            {
               for(i=0;i<Routing[chromosome].Length[j];i++)
                   if(Routing[chromosome].Temp_chromosome[j][i]==Routing[chromosome].Temp_chromosome[dest][Routing[chromosome].Length[dest]-1]) 
                      leaf_num--;           
            }
        }
    treecost=1+leaf_num+2*(treenode_num-1-leaf_num);
    return treecost;
}

//// Part of Fitness Function
void SAMulticast :: Fitness_Function(int chromosome)
{
	
	int delay_count,count,conflict_value,treecost_value; //ul
	double whole_cost, temp_path_cost, path_cost, temp_delay_cost, delay_cost, maxdelay;
	
    Init_Temp_Matrices();
	Routing[chromosome].fitness = path_cost = delay_cost = maxdelay = 0.0;
	count=0;
	for(int d=0;d<Destination.size();d++)
	{
		//delay_count= 0;
		temp_path_cost= temp_delay_cost = 0.0;
		for(int j=1;j<Routing[chromosome].Length[d];j++)
		{
			if(Temp_Cost[Routing[chromosome].Temp_chromosome[d][j-1]][Routing[chromosome].Temp_chromosome[d][j]] != 0.0)
			{
				count++; 
				//// Cost
				temp_path_cost += Temp_Cost[Routing[chromosome].Temp_chromosome[d][j-1]][Routing[chromosome].Temp_chromosome[d][j]];
				Temp_Cost[Routing[chromosome].Temp_chromosome[d][j-1]][Routing[chromosome].Temp_chromosome[d][j]]=0.0;
				Temp_Cost[Routing[chromosome].Temp_chromosome[d][j]][Routing[chromosome].Temp_chromosome[d][j-1]]=0.0;
				//// Delay
				//temp_delay_cost += Temp_Delay[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]];
				//Temp_Delay[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]]=0.0;
				//Temp_Delay[Routing[i].Temp_chromosome[d][j]][Routing[i].Temp_chromosome[d][j-1]]=0.0;
			}
			temp_delay_cost += Temp_Delay[Routing[chromosome].Temp_chromosome[d][j-1]][Routing[chromosome].Temp_chromosome[d][j]];
		}
		if(temp_delay_cost>maxdelay)
		   maxdelay=temp_delay_cost;
		path_cost += temp_path_cost;
		delay_cost += temp_delay_cost;
	}
	conflict_value = Channel_Assignment(chromosome);
	treecost_value = Tree_Cost(chromosome);
	//fout << "The conflict value is "<<conflict_value<<endl;
    //Routing[chromosome].fitness = 1.0/(conflict_value + 1.0); //ul
	Routing[chromosome].fitness = 1.0/(aPara*conflict_value + bPara*treecost_value);
	
	/*if(conflict_value < minConflictValue && delay_cost/Destination.size() <= delayBound)
	{
	   minConflictValue = conflict_value;
       Optimal = Routing[chromosome];
	   delayValue= delay_cost/Destination.size();
	   maxdelayValue = maxdelay;
	   costValue = path_cost; //ul
    }
         
	if(conflict_value == minConflictValue && path_cost < costValue && delay_cost/Destination.size() <= delayBound)
	{
       Optimal = Routing[chromosome];
	   delayValue= delay_cost/Destination.size();
	   maxdelayValue = maxdelay;
	   costValue = path_cost; //ul  
    }*/
    if(Routing[chromosome].fitness > maxFitness && delay_cost/Destination.size() <= delayBound)
	{
	   maxFitness = Routing[chromosome].fitness;
       Optimal = Routing[chromosome];
       conflictvalue_inoptimal=conflict_value;
       treecost_inoptimal=treecost_value;
	   delayValue = delay_cost/Destination.size();
	   maxdelayValue = maxdelay;
	   costValue = path_cost;
    }
}

void SAMulticast :: LCA_Result(int i)
{	
	int delay_count,count,conflict_value; //ul
	double whole_cost, temp_path_cost, path_cost, temp_delay_cost, delay_cost, maxdelay;
	
    Init_Temp_Matrices();
	Routing[i].fitness = Routing[i].cost = path_cost = delay_cost = maxdelay = 0.0;
	count=0;
	for(int d=0;d<Destination.size();d++)
	{
		//delay_count= 0;
		temp_path_cost= temp_delay_cost = 0.0;
		for(int j=1;j<Routing[i].Length[d];j++)
		{
			if(Temp_Cost[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]] != 0.0)
			{
				count++; 
				//// Cost
				temp_path_cost += Temp_Cost[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]];
				Temp_Cost[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]]=0.0;
				Temp_Cost[Routing[i].Temp_chromosome[d][j]][Routing[i].Temp_chromosome[d][j-1]]=0.0;
				//// Delay
				//temp_delay_cost += Temp_Delay[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]];
				//Temp_Delay[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]]=0.0;
				//Temp_Delay[Routing[i].Temp_chromosome[d][j]][Routing[i].Temp_chromosome[d][j-1]]=0.0;
			}
			temp_delay_cost += Temp_Delay[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]];
		}
		if(temp_delay_cost>maxdelay)
		   maxdelay=temp_delay_cost;
		path_cost += temp_path_cost;
		delay_cost += temp_delay_cost;
	}
	LCA_conflict = Channel_Assignment(i);
		
    Routing[i].fitness = 1.0/(conflict_value + 1.0); //ul
    Routing[i].cost = path_cost;
        		
	LCA_ave_delay = delay_cost/Destination.size();
	LCA_max_delay = maxdelay;
	LCA_costValue = path_cost;   
}

void SAMulticast :: SPT_Result(int i)
{	
	int delay_count,count,conflict_value; //ul
	double whole_cost, temp_path_cost, path_cost, temp_delay_cost, delay_cost, maxdelay;
	
    Init_Temp_Matrices();
	Routing[i].fitness = Routing[i].cost = path_cost = delay_cost = maxdelay = 0.0;
	count=0;
	for(int d=0;d<Destination.size();d++)
	{
		//delay_count= 0;
		temp_path_cost= temp_delay_cost = 0.0;
		for(int j=1;j<Routing[i].Length[d];j++)
		{
			if(Temp_Cost[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]] != 0.0)
			{
				count++; 
				//// Cost
				temp_path_cost += Temp_Cost[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]];
				Temp_Cost[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]]=0.0;
				Temp_Cost[Routing[i].Temp_chromosome[d][j]][Routing[i].Temp_chromosome[d][j-1]]=0.0;
				//// Delay
				//temp_delay_cost += Temp_Delay[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]];
				//Temp_Delay[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]]=0.0;
				//Temp_Delay[Routing[i].Temp_chromosome[d][j]][Routing[i].Temp_chromosome[d][j-1]]=0.0;
			}
			temp_delay_cost += Temp_Delay[Routing[i].Temp_chromosome[d][j-1]][Routing[i].Temp_chromosome[d][j]];
		}
		if(temp_delay_cost>maxdelay)
		   maxdelay=temp_delay_cost;
		path_cost += temp_path_cost;
		delay_cost += temp_delay_cost;
	}
	SPT_conflict = Channel_Assignment(i);
		
    Routing[i].fitness = 1.0/(conflict_value + 1.0); //ul
    Routing[i].cost = path_cost;
        		
	SPT_ave_delay = delay_cost/Destination.size();
	SPT_max_delay = maxdelay;
	SPT_costValue = path_cost;   
}

//// Terminate Condition: total iteration number reached
//// or the number of temperature decreasing without improvement on the optimal 
//// Part of Main Function
int main(int argc, char *argv[])
{
	time_t now1,now2;
	
	int TotDecreTempeNum,ContDecreTempeNum,ContDecreTempe_UpLimit;
    int ConsTempeIteNum,ConsTempeIte_UpLimit,ConsTempeIte_UpLimit_base;
    int ConsTempeNoChangeNum,ConsTempeNoChange_UpLimit;
    int i,j,count,temp; // total iteration number
    double rate;
    float delta_cost,T1,prob,prob1;
    char *inputfile;
    char *outputfile = new char[60];
    
    NodeNum = atoi(argv[1]);
    aPara = atof(argv[2]);
    bPara = atof(argv[3]);
    
    if(NodeNum == 11)
       inputfile="WMNTopo11.in";
    if(NodeNum == 23)
       inputfile="WMNTopo23.in";  
    if(NodeNum == 50)
       inputfile="WMNTopo50.in";  
    
    sprintf(outputfile, "JointMCA_SA_N%d_a%4.2f_b%4.2f.out", NodeNum, aPara, bPara);
    
    fin.open(inputfile);    
    fout.open(outputfile,ios::out);
    	
	srand(time(0));
	SAMulticast SAM;
	
	SAM.Step_Init();
	SAM.ReadTopo();
	for(int step=0; step<Iteration; step++)
	{
	    time(&now1);
	
	/// Initializing, read parameters
	//SAM.Init_Routing();
	
	    while(1)
	    {
		    fin >> temp;
		    if(temp != -1)
			   Destination.push_back(temp);
		    else 
			   break;
	    }
	    
	    SAM.Init();
	
	    TotDecreTempeNum=0;
        ContDecreTempeNum=0;
    
	    // applied to the whole temperature decreasing procedure
	    ContDecreTempe_UpLimit=(int)(CoeContDecreTempe*MaxDecreTempeNum); 
	    ConsTempeIte_UpLimit_base=Destination.size();
     
        count=0;    
	    T1=100;
	    //first half of temperature decreasing
        //while((ContDecreTempeNum<ContDecreTempe_UpLimit)&&(TotDecreTempeNum<MaxDecreTempeNum))
        while(ContDecreTempeNum<ContDecreTempe_UpLimit)
        {
		    ConsTempeIteNum=0;
	        ConsTempeIte_UpLimit=(TotDecreTempeNum+1)*ConsTempeIte_UpLimit_base;
	    
            ConsTempeNoChangeNum=0;
            ConsTempeNoChange_UpLimit=(int)(CoeConsTempeNoChange*ConsTempeIte_UpLimit);
                		
            while((ConsTempeNoChangeNum<ConsTempeNoChange_UpLimit)&&(ConsTempeIteNum<ConsTempeIte_UpLimit))
		    {  
		        SAM.Fitness_Function(0);
                Routing[1]=Routing[0];
		        //if(TotDecreTempeNum<MaxDecreTempeNum/2)
		        //   SAM.CoarseGrainedNeighbor(1); //generate a neighbor of Solution1, denoted as Solution2
                //else
		        SAM.FineGrainedNeighbor(1);
		        count++;
                SAM.Fitness_Function(1);		   
		   
		        delta_cost=Routing[1].fitness-Routing[0].fitness;
		        //if(delta_cost != 0)
           	       //fout << "delta_cost is"<<delta_cost<<endl;
		        if(delta_cost>0||SAM.dRandom()<exp(delta_cost/T1)) // Solution2 is better than Solution1
                {
			       Routing[0]=Routing[1];
			       if(Routing[1].fitness<=Optimal.fitness)
			          ConsTempeNoChangeNum++;
                   else
                   {
                      ConsTempeNoChangeNum=0;
                      ContDecreTempeNum=0;
                   }
		        }
		        ConsTempeIteNum++;
		    }
		    T1=CoeDecreTempe*T1;
		    //fout << "T1 is"<<T1<<endl;
		    TotDecreTempeNum++;
		    ContDecreTempeNum++;		  
	    }
	
   	    time(&now2);
	    //fout << "\nStart time is "<<ctime(&now1);
	    //fout << "End time is "<<ctime(&now2);
	    //fout << "The best solution is like that"<<endl;
	    //fout << "The best Delay value is "<<delayValue<<endl;	    
	    //fout << "The best Tree Cost is "<<costValue<<endl;
	    //fout << "The minimum conflict value is "<<minConflictValue<<endl;
	    //fout << "The count is "<<count<<endl;
	    //fout << "The best path is "<<endl;
	    fout << "The SA Tree: "<<endl;
	    for(int dest=0; dest<Destination.size(); dest++)
	    {
	        for(int col=0; col<Optimal.Length[dest]; col++)
	            fout<<Optimal.Temp_chromosome[dest][col]<<" ";
	        fout<<endl;
	    }
	    fout<<endl;
	    fout << "SA conflict value: "<<conflictvalue_inoptimal<<endl;
	    fout << "SA tree cost value: "<<treecost_inoptimal<<endl;
        //fout << "GA average delay: "<<delayValue<<endl;
        //fout << "GA max delay: "<<maxdelayValue<<endl;
        /*fout << "The LCA Tree: "<<endl;
	    Routing[0]=LCAMulticastTree;		
	    for(j=0;j<Destination.size();j++)
	    {
	        i=0;
	        while(Routing[0].Temp_chromosome[j][i]!=Destination[j])
	        {
 		        fout << Routing[0].Temp_chromosome[j][i] <<" ";
      	        i++;
            }
            fout << Routing[0].Temp_chromosome[j][i] <<" ";
            fout<<endl;
        }
        //LCA_conflict=SAM.Channel_Assignment(0);
        SAM.LCA_Result(0);
        
        fout << "The SPT Tree: "<<endl;
        Routing[0]=SPTMulticastTree;		
		for(j=0;j<Destination.size();j++)
	    {
	        i=0;
	        while(Routing[0].Temp_chromosome[j][i]!=Destination[j])
	        {
 		          fout << Routing[0].Temp_chromosome[j][i] <<" ";
      		      i++;
            }
            fout << Routing[0].Temp_chromosome[j][i] <<" ";
            fout<<endl;
        }        
        SAM.SPT_Result(0);
        //SPT_conflict=SAM.Channel_Assignment(0);
        fout << "SA conflict value: "<<minConflictValue<<endl;
        fout << "LCA conflict value: "<<LCA_conflict<<endl;
        fout << "SPT conflict value: "<<SPT_conflict<<endl;
        
        fout << "SA average delay: "<<delayValue<<endl;
        fout << "LCA average delay: "<<LCA_ave_delay<<endl;
        fout << "SPT average delay: "<<SPT_ave_delay<<endl;
        
        fout << "SA max delay: "<<maxdelayValue<<endl;
        fout << "LCA max delay: "<<LCA_max_delay<<endl;
        fout << "SPT max delay: "<<SPT_max_delay<<endl;*/
        
        
        SAM.Init_Routing();
    }
	//return 0;
}
